# 機能設計書 45-コメント表示

## 概要

本ドキュメントは、LEGACY CMSのコメント管理機能における「コメント表示」機能の設計仕様を定義する。

### 本機能の処理概要

特定のコンテンツ（記事、ページ、イベント等）に紐づくコメント一覧を表示する機能である。管理画面のコンテンツ編集画面などから、Ajaxで呼び出され、そのコンテンツに投稿されたコメントを一覧形式で表示する。コメントの承認状態が視覚的に区別され、承認・非承認・削除の操作が可能。

**業務上の目的・背景**：コンテンツ編集画面から、そのコンテンツに対するコメントを確認できると、管理者はコンテンツとコメントの関連を把握しやすい。記事やイベントの内容を編集しながら、読者からのフィードバックを同時に確認・管理できるため、運用効率が向上する。

**機能の利用シーン**：記事編集画面でその記事に投稿されたコメントを確認する場合、イベント詳細画面でイベントへのコメントを確認する場合、ページ編集画面でそのページへのフィードバックを確認する場合などに使用される。

**主要な処理内容**：
1. コンテンツタイプとスレーブIDの取得
2. 該当コンテンツに紐づくコメントを取得
3. ユーザー情報をJOINして表示
4. 承認状態に応じた視覚的区別と操作ボタンの表示

**関連システム・外部連携**：ユーザー管理システムと連携し、コメント投稿者の情報を表示する。コンテンツ編集画面のタブとして呼び出される。

**権限による制御**：`gcomments`（コメントモジュールアクセス権限）を持つユーザーのみがコメントを表示できる。追加で`gcommentsstatus`権限があれば承認操作、`gcommentdelete`権限があれば削除操作が可能。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 86 | コメント表示画面 | 主画面 | コメントの詳細を表示 |
| 38 | 記事詳細画面 | 参照元画面 | 記事のコメントを表示 |
| 63 | ページ詳細画面 | 参照元画面 | ページのコメントを表示 |
| 51 | イベント詳細画面 | 参照元画面 | イベントのコメントを表示 |

## 機能種別

CRUD操作（Read） / Ajaxコンポーネント / 一覧表示

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| type | string | Yes | コンテンツタイプ（A:記事, P:ページ, E:イベント） | 1文字のタイプコード |
| slave | integer | Yes | 紐づくコンテンツのID | 数値 |

### 入力データソース

- type: URLパラメータから取得（/admin/comments/show/type/{type}/slave/{slave}/）
- slave: URLパラメータから取得

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| commentArray | array | コメント一覧 |
| type | string | コンテンツタイプ |

### 出力先

- Ajaxレスポンスとしてshow.phtmlを出力

## 処理フロー

### 処理シーケンス

```
1. リクエスト受信
   └─ showActionがコールされる
2. 権限チェック
   └─ gcomments権限を確認
3. レイアウト無効化
   └─ Ajaxレスポンス用に無効化
4. パラメータ取得
   └─ type, slaveパラメータを取得
5. クエリ構築・実行
   └─ comments + usersをJOINしてSELECT
6. ビューへデータ渡し
   └─ commentArrayとtypeを設定
```

### フローチャート

```mermaid
flowchart TD
    A[開始] --> B{権限チェック}
    B -->|NG| C[権限エラー画面へ]
    B -->|OK| D[レイアウト無効化]
    D --> E[パラメータ取得]
    E --> F[SELECTクエリ構築]
    F --> G[comments + users JOIN]
    G --> H[データ取得]
    H --> I[ビューへ渡す]
    I --> J[終了]
    C --> J
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-45-01 | 権限チェック | gcomments権限が必要 | 常時 |
| BR-45-02 | 承認状態表示 | 未承認コメントは視覚的に区別 | 常時 |
| BR-45-03 | 日付順ソート | 投稿日時の降順で表示 | 常時 |
| BR-45-04 | 全件表示 | ページネーションなしで全件表示 | 常時 |

### 計算ロジック

特になし。

## データベース操作仕様

### 操作別データベース影響一覧

| 操作 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| コメント取得 | comments | SELECT | 特定コンテンツのコメントを取得 |
| ユーザー情報取得 | users | JOIN | 投稿者情報を取得 |

### テーブル別操作詳細

#### comments（SELECT）

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | * | WHERE comment_type = {type} AND comment_slave = {slave} | フィルター条件 |
| ORDER BY | comment_date | DESC | 投稿日時降順 |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | 権限エラー | gcomments権限なし | privileges画面へフォワード |
| - | データなし | コメントが0件 | 「No Comments!」メッセージ表示 |

### リトライ仕様

特になし。

## トランザクション仕様

参照のみのため、トランザクション制御は不要。

## パフォーマンス要件

- Ajaxレスポンス時間: 1秒以内
- レイアウトを無効化することでレスポンスサイズを最小化

## セキュリティ考慮事項

- ACLによるアクセス制御（gcomments権限の確認）
- XSS対策: コメント内容の表示時にエスケープ処理

## 備考

- レイアウトを無効化してAjaxレスポンスとして返却される
- コンテンツ編集画面のタブとしてロードされることが想定されている
- ページネーションなしで全件を表示する

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | database.sql | `database.sql` | commentsテーブルの構造を確認（87-97行目） |

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | CommentsController.php | `application/modules/admin/controllers/CommentsController.php` | showActionメソッド（129-160行目） |

**主要処理フロー**:
1. **131行目**: ACL権限チェック（gcomments）
2. **133行目**: レイアウト無効化
3. **135-136行目**: type, slaveパラメータ取得
4. **143-149行目**: SELECTクエリ構築（comments + users JOIN）
5. **152行目**: commentArrayとしてビューに渡す

#### Step 3: ビュー層を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | show.phtml | `application/modules/admin/views/scripts/comments/show.phtml` | コメント一覧HTML構造（9-36行目） |

### プログラム呼び出し階層図

```
Admin_CommentsController::showAction()
    │
    ├─ $this->view->acl->isAllowed()
    │      └─ 権限チェック（gcomments）
    │
    ├─ $this->_helper->layout->disableLayout()
    │      └─ レイアウト無効化
    │
    └─ $registry->db->select()
           ├─ ->from('comments')
           ├─ ->join('users')
           ├─ ->where('comment_type')
           ├─ ->where('comment_slave')
           └─ ->order('comment_date DESC')
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| CommentsController.php | `application/modules/admin/controllers/CommentsController.php` | コントローラー | コメント表示アクションの定義 |
| show.phtml | `application/modules/admin/views/scripts/comments/show.phtml` | ビュー | コメント一覧のHTML |
| database.sql | `database.sql` | スキーマ | commentsテーブル定義 |
