# 機能設計書 46-コメント削除

## 概要

本ドキュメントは、LEGACY CMSのコメント管理機能における「コメント削除」機能の設計仕様を定義する。

### 本機能の処理概要

投稿されたコメントをデータベースから削除する機能である。管理者はAjaxダイアログを通じてコメントを即座に削除できる。削除操作は確認なしで即時実行され、結果がダイアログ内に表示される。

**業務上の目的・背景**：ユーザー投稿型のCMSでは、スパムコメント、誹謗中傷、不適切な内容のコメントが投稿される可能性がある。これらの問題コメントを迅速に削除し、サイトの品質とユーザー体験を維持する必要がある。コメント削除機能により、管理者はモデレーション業務を効率的に遂行できる。

**機能の利用シーン**：スパムコメントの削除、不適切な内容のコメント削除、テスト投稿の削除、ユーザーからの削除依頼への対応など、コメントを完全に削除する必要がある場合に使用される。

**主要な処理内容**：
1. 削除対象コメントIDの取得
2. commentsテーブルから対象レコードを削除
3. 削除完了メッセージの表示

**関連システム・外部連携**：Dojo Toolkitを使用したAjaxダイアログで削除インターフェースを実現している。

**権限による制御**：`gcomments`（コメントモジュールアクセス権限）と`gcommentdelete`（コメント削除権限）の両方を持つユーザーのみがコメントを削除できる。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 85 | コメント管理画面 | 遷移元画面 | コメント削除ダイアログへの遷移 |
| 86 | コメント表示画面 | 遷移元画面 | コメント削除ダイアログへの遷移 |

## 機能種別

CRUD操作（Delete） / Ajaxダイアログ処理

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| id | integer | Yes | 削除対象コメントのID | URLパラメータから取得 |
| ajax | integer | No | Ajaxモードフラグ（1の場合はページリロードなし） | 0または1 |

### 入力データソース

- id: URLパラメータから取得（/admin/comments/delete/id/{id}/）
- ajax: URLパラメータから取得

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| 完了メッセージ | HTML | 「Comment deleted」のメッセージと閉じるボタン |

### 出力先

- Ajaxダイアログ内にHTMLレスポンスとして出力
- commentsテーブルから対象レコードを削除

## 処理フロー

### 処理シーケンス

```
1. リクエスト受信
   └─ deleteActionがコールされる
2. 権限チェック
   └─ gcomments AND gcommentdelete権限を確認
3. レイアウト・ビュー無効化
   └─ Ajaxレスポンス用に無効化
4. パラメータ取得
   └─ id, ajaxパラメータを取得
5. データベース削除
   └─ commentsテーブルから直接DELETE
6. 完了レスポンス出力
   └─ ajaxフラグに応じたCloseボタンを表示
```

### フローチャート

```mermaid
flowchart TD
    A[開始] --> B{権限チェック}
    B -->|NG| C[権限エラー画面へ]
    B -->|OK| D[レイアウト・ビュー無効化]
    D --> E{IDが設定?}
    E -->|No| F[終了]
    E -->|Yes| G[DELETE実行]
    G --> H[完了メッセージ出力]
    H --> I{ajax=1?}
    I -->|Yes| J[リロードなしCloseボタン]
    I -->|No| K[リロードありCloseボタン]
    J --> F
    K --> F
    C --> F
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-46-01 | 権限チェック | gcommentsとgcommentdelete権限が必要 | 常時 |
| BR-46-02 | 即時削除 | 確認ダイアログなしで即時削除 | 常時 |
| BR-46-03 | 物理削除 | 論理削除ではなく物理削除を実行 | 常時 |
| BR-46-04 | ajaxモード | ajax=1の場合はページリロードなし | Ajax呼び出し時 |

### 計算ロジック

特になし。

## データベース操作仕様

### 操作別データベース影響一覧

| 操作 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| コメント削除 | comments | DELETE | 対象コメントレコードを削除 |

### テーブル別操作詳細

#### comments

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| DELETE | - | WHERE comment_id = {id} | 対象レコードを完全削除 |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | 権限エラー | gcomments/gcommentdelete権限なし | privileges画面へフォワード |

### リトライ仕様

特になし。削除操作は冪等性を持たないため、1回限りの操作となる。

## トランザクション仕様

単一のDELETE操作のため、明示的なトランザクション制御は行っていない。

## パフォーマンス要件

- Ajaxレスポンス時間: 1秒以内
- レイアウトとビューを無効化することでレスポンスサイズを最小化

## セキュリティ考慮事項

- ACLによるアクセス制御（gcomments, gcommentdelete権限の確認）
- IDパラメータの存在チェック

## 備考

- スライド削除と異なり、確認ダイアログなしで即座に削除される
- ajax=1の場合はダイアログを閉じてもページリロードしない（タブ内での操作想定）
- 物理削除のため、削除後のデータ復旧は不可能

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | database.sql | `database.sql` | commentsテーブルの構造を確認（87-97行目） |

**読解のコツ**: comment_idが主キーであり、削除時はこのカラムで対象を特定する。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | CommentsController.php | `application/modules/admin/controllers/CommentsController.php` | deleteActionメソッド（165-205行目） |

**主要処理フロー**:
1. **167行目**: ACL権限チェック（gcomments AND gcommentdelete）
2. **169-170行目**: レイアウト・ビューレンダラー無効化
3. **172-173行目**: id, ajaxパラメータ取得
4. **175行目**: IDの存在チェック
5. **181行目**: DELETEクエリ実行
6. **183-195行目**: ajaxフラグに応じた完了メッセージ出力

### プログラム呼び出し階層図

```
Admin_CommentsController::deleteAction()
    │
    ├─ $this->view->acl->isAllowed()
    │      └─ 権限チェック（gcomments AND gcommentdelete）
    │
    ├─ $this->_helper->layout()->disableLayout()
    │      └─ レイアウト無効化
    │
    ├─ $this->_helper->viewRenderer->setNoRender(true)
    │      └─ ビューレンダラー無効化
    │
    └─ $registry->db->delete('comments', 'comment_id = '.$id)
           └─ MySQLへのDELETE実行
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| CommentsController.php | `application/modules/admin/controllers/CommentsController.php` | コントローラー | コメント削除アクションの定義 |
| Comments.php | `application/models/Comments.php` | モデル | deleteCommentメソッド（未使用） |
| database.sql | `database.sql` | スキーマ | commentsテーブル定義 |
| comments.js | `public/_scripts/admin/comments.js` | JavaScript | deleteComment関数 |
