# 機能設計書 48-コメントタブ表示

## 概要

本ドキュメントは、LEGACY CMSのコメント管理機能における「コメントタブ表示」機能の設計仕様を定義する。

### 本機能の処理概要

コンテンツ編集画面などのタブインターフェースにおいて、コメント数をタブタイトルに表示する機能である。「Comments (5)」のような形式で、該当コンテンツに紐づくコメントの総数を動的に表示し、管理者がコメントの存在を把握しやすくする。

**業務上の目的・背景**：コンテンツ編集画面にはタブ形式で複数の関連情報（コメント、タグ、添付ファイルなど）が表示される。各タブのタイトルに件数を表示することで、管理者はタブを開く前にコメントの有無や件数を把握できる。これにより、コメント管理の効率が向上し、対応が必要なコンテンツを素早く特定できる。

**機能の利用シーン**：記事編集画面、ページ編集画面、イベント編集画面などで、コメントタブのタイトルにコメント件数を表示する際に使用される。Ajaxで呼び出され、タブタイトルを動的に更新する。

**主要な処理内容**：
1. コンテンツタイプとスレーブIDの取得
2. 該当コンテンツに紐づくコメント数をカウント
3. 「Comments (件数)」形式でテキストを出力

**関連システム・外部連携**：Dojo Toolkit（Dijit）のTabContainerと連携し、タブタイトルを動的に更新する。

**権限による制御**：`gcomments`（コメントモジュールアクセス権限）を持つユーザーのみがコメント数を取得できる。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 38 | 記事詳細画面 | 参照元画面 | 記事のコメント数をタブ表示 |
| 63 | ページ詳細画面 | 参照元画面 | ページのコメント数をタブ表示 |
| 51 | イベント詳細画面 | 参照元画面 | イベントのコメント数をタブ表示 |

## 機能種別

データ集計 / Ajax API / タブUI更新

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| type | string | Yes | コンテンツタイプ（A:記事, P:ページ, E:イベント, U:ユーザー） | 1文字のタイプコード |
| slave | integer | Yes | 紐づくコンテンツのID（typeが'U'の場合はユーザーID） | 数値 |

### 入力データソース

- type: リクエストパラメータから取得
- slave: リクエストパラメータから取得

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| タブタイトル | string | 「Comments (件数)」形式のテキスト |

### 出力先

- プレーンテキストとしてAjaxレスポンスで返却

## 処理フロー

### 処理シーケンス

```
1. リクエスト受信
   └─ tabActionがコールされる
2. 権限チェック
   └─ gcomments権限を確認
3. レイアウト・ビュー無効化
   └─ プレーンテキスト出力用に無効化
4. パラメータ取得
   └─ type, slaveパラメータを取得
5. タイプ判定とクエリ構築
   └─ type='U'の場合: comment_userで検索
   └─ それ以外: comment_type + comment_slaveで検索
6. コメント数カウント
   └─ 取得結果の配列の長さをカウント
7. テキスト出力
   └─ 「Comments (件数)」を出力
```

### フローチャート

```mermaid
flowchart TD
    A[開始] --> B{権限チェック}
    B -->|NG| C[権限エラー画面へ]
    B -->|OK| D[レイアウト・ビュー無効化]
    D --> E[パラメータ取得]
    E --> F{type='U'?}
    F -->|Yes| G[comment_user=slaveで検索]
    F -->|No| H[comment_type+comment_slaveで検索]
    G --> I[コメント配列取得]
    H --> I
    I --> J[count配列で件数取得]
    J --> K[「Comments 件数」出力]
    K --> L[終了]
    C --> L
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-48-01 | 権限チェック | gcomments権限が必要 | 常時 |
| BR-48-02 | ユーザータイプ | type='U'の場合はユーザーの全コメントをカウント | type='U'時 |
| BR-48-03 | コンテンツタイプ | type+slaveで特定コンテンツのコメントをカウント | type!='U'時 |
| BR-48-04 | 出力形式 | 「Comments (件数)」形式で出力 | 常時 |

### 計算ロジック

- コメント件数 = SELECT結果の配列要素数（count関数で取得）

## データベース操作仕様

### 操作別データベース影響一覧

| 操作 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| コメント数取得 | comments | SELECT | コメント一覧を取得してカウント |

### テーブル別操作詳細

#### comments（type='U'の場合）

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | * | WHERE comment_user = {slave} | ユーザーの全コメント |

#### comments（type!='U'の場合）

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | * | WHERE comment_slave = {slave} AND comment_type = {type} | 特定コンテンツのコメント |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | 権限エラー | gcomments権限なし | privileges画面へフォワード |

### リトライ仕様

特になし。

## トランザクション仕様

参照のみのため、トランザクション制御は不要。

## パフォーマンス要件

- Ajaxレスポンス時間: 500ms以内
- レイアウトとビューを無効化し、プレーンテキストのみを返却

## セキュリティ考慮事項

- ACLによるアクセス制御（gcomments権限の確認）

## 備考

- viewHelperのCommentCountも同様の機能を提供するが、tabActionはAjax呼び出し用
- COUNT(*)ではなくfetchallでデータを取得し、PHPのcount関数で件数を取得している
- 承認状態に関係なく全コメントをカウントする（未承認コメントも含む）

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | database.sql | `database.sql` | commentsテーブルの構造を確認（87-97行目） |

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | CommentsController.php | `application/modules/admin/controllers/CommentsController.php` | tabActionメソッド（292-329行目） |

**主要処理フロー**:
1. **294行目**: ACL権限チェック（gcomments）
2. **296-297行目**: レイアウト・ビューレンダラー無効化
3. **302-303行目**: type, slaveパラメータ取得
4. **305-310行目**: type='U'の場合のクエリ構築
5. **312-316行目**: それ以外の場合のクエリ構築
6. **320行目**: コメント配列を取得
7. **322行目**: 「Comments (件数)」をecho出力

#### Step 3: ビューヘルパーを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | CommentCount.php | `application/modules/admin/views/helpers/CommentCount.php` | commentCountヘルパー（23-46行目） |

**読解のコツ**: viewHelperは同様のロジックだが、ビューテンプレートから直接呼び出す場合に使用する。tabActionはAjax呼び出し専用。

### プログラム呼び出し階層図

```
Admin_CommentsController::tabAction()
    │
    ├─ $this->view->acl->isAllowed()
    │      └─ 権限チェック（gcomments）
    │
    ├─ $this->_helper->layout()->disableLayout()
    │      └─ レイアウト無効化
    │
    ├─ $this->_helper->viewRenderer->setNoRender(true)
    │      └─ ビューレンダラー無効化
    │
    ├─ $registry->db->select()
    │      ├─ [type='U'] WHERE comment_user = {slave}
    │      └─ [other] WHERE comment_slave = {slave} AND comment_type = {type}
    │
    └─ echo 'Comments ('.count($commentArray).')'
           └─ プレーンテキスト出力
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| CommentsController.php | `application/modules/admin/controllers/CommentsController.php` | コントローラー | タブアクションの定義 |
| CommentCount.php | `application/modules/admin/views/helpers/CommentCount.php` | ヘルパー | コメント数カウント（ビュー用） |
| database.sql | `database.sql` | スキーマ | commentsテーブル定義 |
