# 機能設計書 49-タグ一覧表示

## 概要

本ドキュメントは、LEGACY CMSのタグ管理機能における「タグ一覧表示」機能の設計仕様を定義する。

### 本機能の処理概要

コンテンツ（記事、ページ、イベント等）に紐づくタグの一覧を表示する機能である。管理画面のコンテンツ編集画面などから、Ajaxで呼び出され、そのコンテンツに設定されているタグをタグクラウド形式で表示する。各タグはクリックで削除可能。

**業務上の目的・背景**：CMSでは、コンテンツの分類や検索を効率化するためにタグ機能が提供されている。タグによりコンテンツをカテゴリとは別の切り口で整理でき、ユーザーは関連するコンテンツを容易に見つけられる。管理者がコンテンツのタグを確認・管理するための一覧表示機能が必要である。

**機能の利用シーン**：記事編集画面でその記事に付けられたタグを確認する場合、イベント編集画面でタグを管理する場合、ページのタグを確認・削除する場合などに使用される。

**主要な処理内容**：
1. コンテンツタイプとスレーブIDの取得
2. 該当コンテンツに紐づくタグを取得
3. タグ一覧の表示（クリックで削除可能な形式）

**関連システム・外部連携**：コンテンツ編集画面のタブとしてAjaxで呼び出される。タグ削除機能と連携して動作する。

**権限による制御**：特に権限チェックは実装されていない（コンテンツ編集画面へのアクセス権限で間接的に制御）。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 2 | タグ一覧画面 | 主画面 | サイト内の全タグを一覧表示 |
| 15 | 記事タグ一覧画面 | 参照元画面 | 記事に関連するタグを表示 |
| 24 | ページタグ一覧画面 | 参照元画面 | ページに関連するタグを表示 |
| 13 | 記事詳細画面 | 参照元画面 | 記事のタグを表示 |

## 機能種別

CRUD操作（Read） / Ajaxコンポーネント / 一覧表示

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| type | string | Yes | コンテンツタイプ（A:記事, P:ページ, E:イベント） | 1文字のタイプコード |
| slave | integer | Yes | 紐づくコンテンツのID | 数値 |

### 入力データソース

- type: URLパラメータから取得（/admin/tags/show/type/{type}/slave/{slave}/）
- slave: URLパラメータから取得

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| tagArray | array | タグ一覧 |

### 出力先

- Ajaxレスポンスとしてshow.phtmlを出力

## 処理フロー

### 処理シーケンス

```
1. リクエスト受信
   └─ showActionがコールされる
2. レイアウト無効化
   └─ Ajaxレスポンス用に無効化
3. パラメータ取得
   └─ type, slaveパラメータを取得
4. クエリ構築・実行
   └─ tagsテーブルからSELECT
5. ビューへデータ渡し
   └─ tagArrayを設定
```

### フローチャート

```mermaid
flowchart TD
    A[開始] --> B[レイアウト無効化]
    B --> C[パラメータ取得]
    C --> D[SELECTクエリ構築]
    D --> E[tags FROM WHERE type AND slave]
    E --> F[タグ配列取得]
    F --> G[ビューへ渡す]
    G --> H[終了]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-49-01 | タグ形式表示 | タグをクリック可能なタグ形式で表示 | 常時 |
| BR-49-02 | 削除可能 | 各タグはクリックで削除可能 | 常時 |
| BR-49-03 | 全件表示 | ページネーションなしで全タグを表示 | 常時 |

### 計算ロジック

特になし。

## データベース操作仕様

### 操作別データベース影響一覧

| 操作 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| タグ取得 | tags | SELECT | 特定コンテンツのタグを取得 |

### テーブル別操作詳細

#### tags（SELECT）

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | tag_id | - | タグID |
| SELECT | tag_tag | - | タグ文字列 |
| WHERE | tag_type | = {type} | コンテンツタイプ |
| WHERE | tag_slave | = {slave} | コンテンツID |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | データなし | タグが0件 | 「No Tags!」メッセージ表示 |

### リトライ仕様

特になし。

## トランザクション仕様

参照のみのため、トランザクション制御は不要。

## パフォーマンス要件

- Ajaxレスポンス時間: 1秒以内
- レイアウトを無効化することでレスポンスサイズを最小化

## セキュリティ考慮事項

- XSS対策: タグ文字列の表示時にエスケープ処理
- showActionには明示的な権限チェックがないが、親画面のアクセス権限で制御される

## 備考

- タグはホバー時にスタイルが変わり（tagItm_del）、削除可能であることを視覚的に示す
- クリック時にdeleteTag()関数が呼び出される
- タグ0件の場合は「No Tags!」というタグ形式のメッセージを表示

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | database.sql | `database.sql` | tagsテーブルの構造を確認（335-341行目） |

**読解のコツ**: tag_typeは1文字のコード（A/P/E等）、tag_slaveは紐づくコンテンツのID、tag_tagがタグの文字列。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | TagsController.php | `application/modules/admin/controllers/TagsController.php` | showActionメソッド（28-47行目） |

**主要処理フロー**:
1. **30行目**: レイアウト無効化
2. **32-33行目**: slave, typeパラメータ取得
3. **39-42行目**: SELECTクエリ構築
4. **45行目**: tagArrayとしてビューに渡す

#### Step 3: ビュー層を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | show.phtml | `application/modules/admin/views/scripts/tags/show.phtml` | タグ一覧HTML構造（9-15行目） |

**主要処理フロー**:
- **9行目**: タグ配列の件数チェック
- **10-11行目**: タグのループ表示（tagItmクラス、ホバーでtogItm_del）
- **11行目**: onClick時にdeleteTag関数呼び出し

### プログラム呼び出し階層図

```
Admin_TagsController::showAction()
    │
    ├─ $this->_helper->layout->disableLayout()
    │      └─ レイアウト無効化
    │
    └─ $registry->db->select()
           ├─ ->from('tags')
           ├─ ->where('tag_type')
           └─ ->where('tag_slave')
```

### データフロー図

```
[入力]                    [処理]                         [出力]

URLパラメータ            TagsController               ビュー
  - type           ─────▶  ::showAction()       ─────▶ show.phtml
  - slave                  │                           │
                           └─ SELECT構築               └─ タグ一覧
                               + WHERE type, slave
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| TagsController.php | `application/modules/admin/controllers/TagsController.php` | コントローラー | タグ一覧アクションの定義 |
| Tags.php | `application/models/Tags.php` | モデル | タグのCRUD操作 |
| show.phtml | `application/modules/admin/views/scripts/tags/show.phtml` | ビュー | タグ一覧のHTML |
| database.sql | `database.sql` | スキーマ | tagsテーブル定義 |
| TagCount.php | `application/modules/admin/views/helpers/TagCount.php` | ヘルパー | タグ数カウント |
