# 機能設計書 53-タグタブ表示

## 概要

本ドキュメントは、LEGACY CMSにおけるタグタブ表示機能の設計を定義する。この機能は、コンテンツ編集画面のタブタイトルにタグ数を動的に表示するための機能である。

### 本機能の処理概要

**業務上の目的・背景**：コンテンツ編集画面では、タグ、コメント、添付ファイルなどの関連情報がタブ形式で整理されている。各タブのタイトルに件数を表示することで、管理者はタブを開かなくても関連データの有無や数量を把握できる。これにより、コンテンツ管理の効率性が向上する。

**機能の利用シーン**：記事、ページ、イベントなどのコンテンツ編集画面を開いた際、「Tags」タブのタイトルに「Tags (3)」のように現在のタグ数が表示される。タグの追加・削除後もタブタイトルが動的に更新される。

**主要な処理内容**：
1. コンテンツタイプとスレーブID（コンテンツID）の受け取り
2. 該当コンテンツに紐づくタグ数のカウント
3. タブタイトル形式での文字列出力

**関連システム・外部連携**：Dojo ToolkitのTabContainerと連携。タブコンテンツの更新時に、タブタイトルも同時に更新される。

**権限による制御**：タブ表示はコンテンツ編集画面の一部として表示されるため、該当コンテンツの編集権限を持つユーザーが利用可能。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 36 | 記事編集画面 | 主画面 | タグタブタイトルにタグ数を表示 |
| 37 | 記事新規作成画面 | 主画面 | タグタブタイトルにタグ数を表示 |
| 49 | イベント編集画面 | 主画面 | タグタブタイトルにタグ数を表示 |
| 50 | イベント新規作成画面 | 主画面 | タグタブタイトルにタグ数を表示 |
| 61 | ページ編集画面 | 主画面 | タグタブタイトルにタグ数を表示 |
| 62 | ページ新規作成画面 | 主画面 | タグタブタイトルにタグ数を表示 |

## 機能種別

データ表示 / UI補助機能

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| type | string | Yes | コンテンツタイプ（A=記事, P=ページ, E=イベント等） | なし |
| slave | integer | Yes | コンテンツID（スレーブID） | 数値チェック |

### 入力データソース

- URLパラメータ経由でtype、slaveを取得
- Ajax経由でリクエストされる

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| タブタイトル | string | "Tags (件数)" 形式の文字列 |

### 出力先

- HTTPレスポンス（プレーンテキスト）
- Dojoのタブコンテナが消費

## 処理フロー

### 処理シーケンス

```
1. リクエスト受信
   └─ tabActionメソッドがコールされる
2. レイアウト・ビュー無効化
   └─ テキスト応答のためレイアウトとビューレンダリングを無効化
3. パラメータ取得
   └─ URLパラメータからtypeとslaveを取得
4. データベースクエリ実行
   └─ tagsテーブルから該当コンテンツのタグを取得
5. 件数カウント
   └─ 取得した配列のcount()を実行
6. タブタイトル出力
   └─ "Tags (件数)" 形式で出力
```

### フローチャート

```mermaid
flowchart TD
    A[開始] --> B[tabAction呼び出し]
    B --> C[レイアウト・ビュー無効化]
    C --> D[パラメータ取得]
    D --> E[DB: tagsテーブルから検索]
    E --> F[タグ配列取得]
    F --> G[count関数で件数算出]
    G --> H["Tags (件数)" 形式で出力]
    H --> I[終了]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-53-01 | タイプ指定 | コンテンツタイプ（type）で対象を絞り込む | 常時 |
| BR-53-02 | スレーブ指定 | コンテンツID（slave）で対象を絞り込む | 常時 |
| BR-53-03 | 表示形式 | "Tags (件数)" の形式で表示される | 常時 |

### 計算ロジック

タグ数 = SELECT結果のレコード件数（count関数）

## データベース操作仕様

### 操作別データベース影響一覧

| 操作 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| タグ数取得 | tags | SELECT | 指定コンテンツのタグを取得 |

### テーブル別操作詳細

#### tags

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | 全カラム | WHERE tag_slave = {slave} AND tag_type = {type} | 件数カウント用 |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | パラメータエラー | type/slaveが未指定 | 0件として処理 |

### リトライ仕様

リトライ処理は実装されていない。

## トランザクション仕様

SELECT文のみのため、トランザクション制御は不要。

## パフォーマンス要件

- タブ表示の動的更新のため、高速なレスポンスが必要
- tag_slaveとtag_typeにインデックスがあることが望ましい

## セキュリティ考慮事項

- CMS_Controller_Action_Adminを継承しており、管理者認証が必須
- 出力はcount()の数値のみのため、XSSリスクは低い

## 備考

- TagCountビューヘルパーでも同様の処理が実装されている
- タブアクションはAjax経由で呼び出され、タブタイトルを動的に更新する

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

タグとコンテンツの関連を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | Tags.php | `application/models/Tags.php` | tagsテーブルの構造（tag_type, tag_slave） |

**読解のコツ**: tag_typeはコンテンツタイプ（A=Article, P=Page等）、tag_slaveはコンテンツIDを表す。

#### Step 2: エントリーポイントを理解する

コントローラのアクションを確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | TagsController.php | `application/modules/admin/controllers/TagsController.php` | tabActionメソッドの処理フロー |

**主要処理フロー**:
1. **217-236行目**: tabAction - タブタイトル生成
2. **219-220行目**: レイアウトとビューの無効化
3. **225-226行目**: パラメータからtype、slaveを取得
4. **228-231行目**: tagsテーブルから該当タグを検索
5. **233行目**: 取得結果をfetchall
6. **235行目**: "Tags (件数)" 形式でecho出力

#### Step 3: ビューヘルパーとの関連を理解する

同等機能を持つビューヘルパーを確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | TagCount.php | `application/modules/admin/views/helpers/TagCount.php` | 同様のカウント処理の実装 |

**主要処理フロー**:
- **23-35行目**: tagCountメソッド - スレーブとタイプでタグをカウント

### プログラム呼び出し階層図

```
Admin_TagsController::tabAction()
    │
    ├─ $this->_helper->layout()->disableLayout()
    │
    ├─ $this->_helper->viewRenderer->setNoRender(true)
    │
    ├─ $this->_request->getParam('type')
    │
    ├─ $this->_request->getParam('slave')
    │
    ├─ $registry->db->select()
    │      ├─ ->from('tags')
    │      ├─ ->where('tag_slave = ?', $slave)
    │      └─ ->where('tag_type = ?', $type)
    │
    ├─ $registry->db->fetchall($select)
    │
    └─ echo 'Tags ('.count($tagArray).')'
```

### データフロー図

```
[入力]               [処理]                    [出力]

URLパラメータ ───▶ TagsController     ───▶ テキスト応答
(type, slave)      ::tabAction()           "Tags (件数)"
                        │
                        ▼
                   tagsテーブル
                   (SELECT WHERE条件)
                        │
                        ▼
                   count()で件数算出
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| TagsController.php | `application/modules/admin/controllers/TagsController.php` | コントローラ | タブタイトル生成アクションを提供 |
| TagCount.php | `application/modules/admin/views/helpers/TagCount.php` | ヘルパー | 同等のタグカウント機能（ビューヘルパー版） |
| Tags.php | `application/models/Tags.php` | モデル | タグデータ構造の参照 |
