# 機能設計書 54-添付ファイル一覧表示

## 概要

本ドキュメントは、LEGACY CMSにおける添付ファイル一覧表示機能の設計を定義する。この機能は、コンテンツに紐づく添付ファイルの一覧を表示するための機能である。

### 本機能の処理概要

**業務上の目的・背景**：コンテンツ管理において、記事やページに関連するファイル（PDF、画像、文書など）を添付することは一般的な要件である。添付ファイル一覧表示機能により、管理者はコンテンツにどのようなファイルが紐づけられているかを確認でき、適切なファイル管理が可能となる。

**機能の利用シーン**：管理画面で記事やページなどのコンテンツを編集する際、「Attachments」タブを開くと、現在そのコンテンツに紐づけられている添付ファイルの一覧が表示される。各ファイルはファイル名と拡張子で表示され、削除可能な状態ではマウスオーバーで削除UIが表示される。

**主要な処理内容**：
1. コンテンツタイプとスレーブID（コンテンツID）の受け取り
2. 添付ファイルテーブルとアセットテーブルの結合クエリ
3. 添付ファイル情報（ファイル名、拡張子等）の取得
4. 一覧形式でのHTML出力

**関連システム・外部連携**：assetsテーブル（アセット管理）との結合。添付ファイルはattachmentsテーブルで管理され、実際のファイル情報はassetsテーブルから取得される。

**権限による制御**：添付ファイル一覧の表示は、該当コンテンツの編集権限を持つユーザーが利用可能。メールの場合、送信済み（sent）状態では削除UIが無効化される。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 13 | 記事詳細画面 | 主画面 | 記事の添付ファイルを表示 |
| 38 | 記事詳細画面（管理） | 主画面 | 記事の添付ファイルを表示 |
| 63 | ページ詳細画面 | 主画面 | ページの添付ファイルを表示 |

## 機能種別

データ表示 / 一覧表示

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| type | string | Yes | コンテンツタイプ（A=記事, P=ページ, M=メール等） | なし |
| slave | integer | Yes | コンテンツID（スレーブID） | 数値チェック |
| status | string | No | ステータス（sent等）。削除UI表示制御に使用 | なし |

### 入力データソース

- URLパラメータ経由でtype、slave、statusを取得
- Ajax経由でContentPaneからリクエストされる

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| 添付ファイル一覧 | HTML | ファイル名と拡張子を含むspan要素のリスト |

### 出力先

- HTTPレスポンス（HTML）
- Dojo ContentPaneが消費

## 処理フロー

### 処理シーケンス

```
1. リクエスト受信
   └─ showActionメソッドがコールされる
2. レイアウト無効化
   └─ HTML断片応答のためレイアウトレンダリングを無効化
3. パラメータ取得
   └─ URLパラメータからtype、slave、statusを取得
4. データベースクエリ実行
   └─ attachmentsテーブルとassetsテーブルを結合してデータ取得
5. ビューレンダリング
   └─ show.phtmlでHTML一覧を生成
6. レスポンス出力
   └─ 添付ファイル一覧HTMLを返却
```

### フローチャート

```mermaid
flowchart TD
    A[開始] --> B[showAction呼び出し]
    B --> C[レイアウト無効化]
    C --> D[パラメータ取得]
    D --> E[DB: attachments JOIN assets]
    E --> F[添付ファイル配列取得]
    F --> G{添付ファイルあり?}
    G -->|Yes| H[ファイル一覧をspan要素で出力]
    G -->|No| I["No Attachments!" を出力]
    H --> J[終了]
    I --> J
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-54-01 | タイプ指定 | コンテンツタイプ（type）で対象を絞り込む | 常時 |
| BR-54-02 | スレーブ指定 | コンテンツID（slave）で対象を絞り込む | 常時 |
| BR-54-03 | 削除UI制御 | statusが'sent'の場合、削除UIを非表示 | メール添付の場合 |
| BR-54-04 | 表示形式 | "ファイル名.拡張子" 形式で表示 | 常時 |

### 計算ロジック

計算ロジックは存在しない。

## データベース操作仕様

### 操作別データベース影響一覧

| 操作 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| 添付ファイル取得 | attachments, assets | SELECT (JOIN) | 添付ファイルとアセット情報を結合取得 |

### テーブル別操作詳細

#### attachments JOIN assets

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | a.*, f.* | JOIN ON f.asset_key = a.attach_asset | 結合条件 |
| WHERE | attach_type | = {type} | タイプで絞り込み |
| WHERE | attach_slave | = {slave} | スレーブIDで絞り込み |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | データなし | 添付ファイルが存在しない | "No Attachments!" を表示 |

### リトライ仕様

リトライ処理は実装されていない。

## トランザクション仕様

SELECT文のみのため、トランザクション制御は不要。

## パフォーマンス要件

- タブ内の動的コンテンツ表示のため、高速なレスポンスが必要
- assetsテーブルとのJOINがあるため、適切なインデックスが必要

## セキュリティ考慮事項

- CMS_Controller_Action_Adminを継承しており、管理者認証が必須
- ファイル名の出力時にXSS対策（HTMLエスケープ）が必要

## 備考

- AttachmentsモデルクラスにもfetchAttachmentsメソッドがあり、同様の処理が実装されている
- 削除UIはJavaScript（deleteAttachment関数）と連携

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

添付ファイルとアセットの関連を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | Attachments.php | `application/models/Attachments.php` | attachmentsテーブル構造、fetchAttachmentsメソッド |

**読解のコツ**: attach_typeはコンテンツタイプ、attach_slaveはコンテンツID、attach_assetはassetsテーブルへのキー参照。

#### Step 2: エントリーポイントを理解する

コントローラのアクションを確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | AttachmentsController.php | `application/modules/admin/controllers/AttachmentsController.php` | showActionメソッドの処理フロー |

**主要処理フロー**:
1. **28-49行目**: showAction - 添付ファイル一覧取得
2. **30行目**: レイアウト無効化
3. **32-34行目**: パラメータ（slave, type, status）取得
4. **39-44行目**: attachmentsとassetsをJOIN
5. **47行目**: ビューに配列を渡す

#### Step 3: ビューテンプレートを理解する

一覧表示のUIを確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | show.phtml | `application/modules/admin/views/scripts/attachments/show.phtml` | 添付ファイル一覧のHTML生成 |

**主要処理フロー**:
- **9-15行目**: 添付ファイルの有無による条件分岐
- **11行目**: statusによる削除UI表示制御
- **11行目**: deleteAttachment関数呼び出し

### プログラム呼び出し階層図

```
Admin_AttachmentsController::showAction()
    │
    ├─ $this->_helper->layout->disableLayout()
    │
    ├─ $this->_getParam('slave')
    ├─ $this->_getParam('type')
    ├─ $this->_getParam('status')
    │
    ├─ $registry->db->select()
    │      ├─ ->from('attachments')
    │      ├─ ->join('assets', 'f.asset_key = a.attach_asset')
    │      ├─ ->where('a.attach_type = ?', $type)
    │      └─ ->where('a.attach_slave = ?', $slave)
    │
    └─ View: show.phtml
           └─ foreach($attachmentArray) で一覧HTML生成
```

### データフロー図

```
[入力]               [処理]                    [出力]

URLパラメータ ───▶ AttachmentsController ───▶ HTML応答
(type, slave,      ::showAction()              (添付ファイル一覧)
 status)                │
                        ▼
              attachmentsテーブル
                   JOIN
              assetsテーブル
                        │
                        ▼
                   show.phtml
              (HTMLリスト生成)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| AttachmentsController.php | `application/modules/admin/controllers/AttachmentsController.php` | コントローラ | 添付ファイル一覧アクションを提供 |
| Attachments.php | `application/models/Attachments.php` | モデル | 添付ファイルデータ操作 |
| show.phtml | `application/modules/admin/views/scripts/attachments/show.phtml` | ビュー | 添付ファイル一覧HTML生成 |
