# 機能設計書 56-添付ファイル削除

## 概要

本ドキュメントは、LEGACY CMSにおける添付ファイル削除機能の設計を定義する。この機能は、コンテンツから添付ファイルの紐付けを削除するための機能である。

### 本機能の処理概要

**業務上の目的・背景**：コンテンツ管理において、不要になった添付ファイルや誤って追加されたファイルを削除する機能は必須である。この機能により、管理者はコンテンツと添付ファイルの紐付けを解除でき、コンテンツの整理・管理が可能となる。なお、この機能はあくまで「紐付けの削除」であり、アセット自体（実ファイル）は削除されない。

**機能の利用シーン**：管理画面で記事やページなどのコンテンツを編集する際、「Attachments」タブ内に表示されている添付ファイルをクリックして削除する。ファイルにマウスオーバーすると削除可能な状態に変化し、クリックすることで即座に紐付け解除が実行される。

**主要な処理内容**：
1. 削除対象添付ファイルIDの受け取り
2. IDの存在確認
3. データベースからの添付レコード削除
4. 削除完了メッセージの表示

**関連システム・外部連携**：Dojo Toolkitを使用したAjaxダイアログとの連携。削除後、ContentPaneの再読み込みにより添付ファイル一覧が自動更新される。

**権限による制御**：添付ファイルの削除は、該当コンテンツの編集権限を持つユーザーが利用可能。コントローラはCMS_Controller_Action_Adminを継承しており、管理者認証が必要。メール添付の場合、送信済み（sent）状態では削除UIが表示されない。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 36 | 記事編集画面 | 主画面 | 添付ファイルタブ内で削除を実行 |
| 49 | イベント編集画面 | 主画面 | 添付ファイルタブ内で削除を実行 |
| 61 | ページ編集画面 | 主画面 | 添付ファイルタブ内で削除を実行 |
| 65 | メール編集画面 | 主画面 | 添付ファイルタブ内で削除を実行（未送信時のみ） |

## 機能種別

CRUD操作（Delete）

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| id | integer | Yes | 削除対象の添付ファイルID（attach_id） | 数値チェック、NULL不可 |

### 入力データソース

- URLパラメータ経由で削除対象IDを取得
- Ajax経由でリクエストされる

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| 結果メッセージ | HTML | 削除完了メッセージとCloseボタンを含むHTML |

### 出力先

- Ajaxダイアログ（dijit.Dialog）内にHTML形式で出力

## 処理フロー

### 処理シーケンス

```
1. リクエスト受信
   └─ deleteActionメソッドがコールされる
2. レイアウト・ビュー無効化
   └─ Ajax応答のためレイアウトとビューレンダリングを無効化
3. パラメータ取得
   └─ URLパラメータからIDを取得
4. ID検証
   └─ IDがセットされているか確認
5. データベース削除実行
   └─ attachmentsテーブルから該当レコードを削除
6. 結果出力
   └─ 削除完了メッセージとCloseボタンをHTML出力
```

### フローチャート

```mermaid
flowchart TD
    A[開始] --> B[deleteAction呼び出し]
    B --> C[レイアウト・ビュー無効化]
    C --> D[パラメータ'id'取得]
    D --> E{idがセット?}
    E -->|Yes| F[DB: attachmentsテーブルから削除]
    F --> G[削除完了HTML出力]
    E -->|No| H[処理終了]
    G --> I[終了]
    H --> I
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-56-01 | ID必須 | 削除対象のIDは必須パラメータである | 常時 |
| BR-56-02 | 紐付け削除 | 添付レコードのみ削除し、アセット実体は保持 | 常時 |
| BR-56-03 | 物理削除 | 添付レコードは物理削除される | 常時 |
| BR-56-04 | 送信済み制限 | メールが送信済みの場合、削除UIは表示されない | メール添付時 |

### 計算ロジック

計算ロジックは存在しない。

## データベース操作仕様

### 操作別データベース影響一覧

| 操作 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| 添付ファイル削除 | attachments | DELETE | 指定IDの添付レコードを削除 |

### テーブル別操作詳細

#### attachments

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| DELETE | attach_id | WHERE attach_id = {パラメータID} | 主キーによる削除 |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | パラメータエラー | idパラメータが未指定 | 処理を行わず終了 |
| Exception | 無効なID | idがNULLまたは非数値（Attachmentsモデル使用時） | 例外スロー |

### リトライ仕様

リトライ処理は実装されていない。

## トランザクション仕様

単一のDELETE文による削除のため、明示的なトランザクション制御は行われていない。

## パフォーマンス要件

- Ajax経由での即時応答が求められる
- 主キーによる削除のため、インデックスを活用した高速な処理が期待される

## セキュリティ考慮事項

- CMS_Controller_Action_Adminを継承しており、管理者認証が必須
- SQLインジェクション対策として、直接SQL連結が使用されている（改善の余地あり）
- アセット実体は削除されないため、ファイルシステムへの影響なし

## 備考

- Attachmentsモデルにはバリデーション付きのdeleteAttachmentメソッドがあるが、コントローラではレジストリ経由で直接削除を実行している
- 削除後の一覧更新は、クライアントサイドJavaScriptによるContentPaneの再読み込みで実現される

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

添付ファイルの削除処理を理解するために、まずデータ構造を確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | Attachments.php | `application/models/Attachments.php` | deleteAttachmentメソッドのバリデーションロジック |

**読解のコツ**: deleteAttachmentメソッドはIDがNULLまたは非数値の場合に例外をスローする。コントローラでは直接DB操作を使用。

#### Step 2: エントリーポイントを理解する

コントローラのアクションを確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | AttachmentsController.php | `application/modules/admin/controllers/AttachmentsController.php` | deleteActionメソッドの処理フロー |

**主要処理フロー**:
1. **54-78行目**: deleteAction - 添付ファイル削除処理のエントリーポイント
2. **56-57行目**: レイアウトとビューの無効化（Ajax応答用）
3. **59行目**: パラメータからIDを取得
4. **61-77行目**: IDが設定されている場合にDB削除と結果出力
5. **67行目**: attachmentsテーブルからDELETE実行

#### Step 3: ビューテンプレートとの連携を理解する

削除UIの表示制御を確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | show.phtml | `application/modules/admin/views/scripts/attachments/show.phtml` | 削除クリックイベントとstatus制御 |

**主要処理フロー**:
- **11行目**: statusが'sent'でない場合のみ削除UIを表示
- **11行目**: onClickでdeleteAttachment関数を呼び出し（JavaScript）

### プログラム呼び出し階層図

```
Admin_AttachmentsController::deleteAction()
    │
    ├─ $this->_helper->layout()->disableLayout()
    │
    ├─ $this->_helper->viewRenderer->setNoRender(true)
    │
    ├─ $this->_getParam('id')
    │
    └─ $registry->db->delete('attachments', 'attach_id = '.$id)
```

### データフロー図

```
[入力]               [処理]                    [出力]

URLパラメータ ───▶ AttachmentsController ───▶ HTML応答
(id=添付ID)        ::deleteAction()           (削除完了メッセージ)
                        │
                        ▼
                  attachmentsテーブル
                  (DELETE)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| AttachmentsController.php | `application/modules/admin/controllers/AttachmentsController.php` | コントローラ | 添付ファイル削除アクションを提供 |
| Attachments.php | `application/models/Attachments.php` | モデル | deleteAttachment, deleteSlaveAttachmentメソッド |
| show.phtml | `application/modules/admin/views/scripts/attachments/show.phtml` | ビュー | 添付ファイル一覧と削除UI |
