# 機能設計書 57-添付ファイルタブ表示

## 概要

本ドキュメントは、LEGACY CMSにおける添付ファイルタブ表示機能の設計を定義する。この機能は、コンテンツ編集画面のタブタイトルに添付ファイル数を動的に表示するための機能である。

### 本機能の処理概要

**業務上の目的・背景**：コンテンツ編集画面では、タグ、コメント、添付ファイルなどの関連情報がタブ形式で整理されている。各タブのタイトルに件数を表示することで、管理者はタブを開かなくても添付ファイルの有無や数量を把握できる。これにより、コンテンツ管理の効率性が向上する。

**機能の利用シーン**：記事、ページ、イベント、メールなどのコンテンツ編集画面を開いた際、「Attachments」タブのタイトルに「Attachments (2)」のように現在の添付ファイル数が表示される。ファイルの追加・削除後もタブタイトルが動的に更新される。

**主要な処理内容**：
1. コンテンツタイプとスレーブID（コンテンツID）の受け取り
2. 該当コンテンツに紐づく添付ファイル数のカウント
3. タブタイトル形式での文字列出力

**関連システム・外部連携**：Dojo ToolkitのTabContainerと連携。タブコンテンツの更新時に、タブタイトルも同時に更新される。

**権限による制御**：タブ表示はコンテンツ編集画面の一部として表示されるため、該当コンテンツの編集権限を持つユーザーが利用可能。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 36 | 記事編集画面 | 主画面 | 添付ファイルタブタイトルにファイル数を表示 |
| 49 | イベント編集画面 | 主画面 | 添付ファイルタブタイトルにファイル数を表示 |
| 61 | ページ編集画面 | 主画面 | 添付ファイルタブタイトルにファイル数を表示 |
| 65 | メール編集画面 | 主画面 | 添付ファイルタブタイトルにファイル数を表示 |

## 機能種別

データ表示 / UI補助機能

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| type | string | Yes | コンテンツタイプ（A=記事, P=ページ, E=イベント, M=メール等） | なし |
| slave | integer | Yes | コンテンツID（スレーブID） | 数値チェック |

### 入力データソース

- URLパラメータ経由でtype、slaveを取得
- Ajax経由でリクエストされる

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| タブタイトル | string | "Attachments (件数)" 形式の文字列 |

### 出力先

- HTTPレスポンス（プレーンテキスト）
- Dojoのタブコンテナが消費

## 処理フロー

### 処理シーケンス

```
1. リクエスト受信
   └─ tabActionメソッドがコールされる
2. レイアウト・ビュー無効化
   └─ テキスト応答のためレイアウトとビューレンダリングを無効化
3. パラメータ取得
   └─ URLパラメータからtypeとslaveを取得
4. データベースクエリ実行
   └─ attachmentsテーブルから該当コンテンツの添付を取得
5. 件数カウント
   └─ 取得した配列のcount()を実行
6. タブタイトル出力
   └─ "Attachments (件数)" 形式で出力
```

### フローチャート

```mermaid
flowchart TD
    A[開始] --> B[tabAction呼び出し]
    B --> C[レイアウト・ビュー無効化]
    C --> D[パラメータ取得]
    D --> E[DB: attachmentsテーブルから検索]
    E --> F[添付ファイル配列取得]
    F --> G[count関数で件数算出]
    G --> H["Attachments (件数)" 形式で出力]
    H --> I[終了]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-57-01 | タイプ指定 | コンテンツタイプ（type）で対象を絞り込む | 常時 |
| BR-57-02 | スレーブ指定 | コンテンツID（slave）で対象を絞り込む | 常時 |
| BR-57-03 | 表示形式 | "Attachments (件数)" の形式で表示される | 常時 |

### 計算ロジック

添付ファイル数 = SELECT結果のレコード件数（count関数）

## データベース操作仕様

### 操作別データベース影響一覧

| 操作 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| 添付ファイル数取得 | attachments | SELECT | 指定コンテンツの添付ファイルを取得 |

### テーブル別操作詳細

#### attachments

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | 全カラム | WHERE attach_slave = {slave} AND attach_type = {type} | 件数カウント用 |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | パラメータエラー | type/slaveが未指定 | 0件として処理 |

### リトライ仕様

リトライ処理は実装されていない。

## トランザクション仕様

SELECT文のみのため、トランザクション制御は不要。

## パフォーマンス要件

- タブ表示の動的更新のため、高速なレスポンスが必要
- attach_slaveとattach_typeにインデックスがあることが望ましい

## セキュリティ考慮事項

- CMS_Controller_Action_Adminを継承しており、管理者認証が必須
- 出力はcount()の数値のみのため、XSSリスクは低い

## 備考

- タブアクションはAjax経由で呼び出され、タブタイトルを動的に更新する
- タグタブ表示（No.53）と同様の設計パターン

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

添付ファイルとコンテンツの関連を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | Attachments.php | `application/models/Attachments.php` | attachmentsテーブルの構造（attach_type, attach_slave） |

**読解のコツ**: attach_typeはコンテンツタイプ（A=Article, P=Page, M=Mail等）、attach_slaveはコンテンツIDを表す。

#### Step 2: エントリーポイントを理解する

コントローラのアクションを確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | AttachmentsController.php | `application/modules/admin/controllers/AttachmentsController.php` | tabActionメソッドの処理フロー |

**主要処理フロー**:
1. **198-217行目**: tabAction - タブタイトル生成
2. **200-201行目**: レイアウトとビューの無効化
3. **206-207行目**: パラメータからtype、slaveを取得
4. **209-212行目**: attachmentsテーブルから該当添付を検索
5. **214行目**: 取得結果をfetchall
6. **216行目**: "Attachments (件数)" 形式でecho出力

### プログラム呼び出し階層図

```
Admin_AttachmentsController::tabAction()
    │
    ├─ $this->_helper->layout()->disableLayout()
    │
    ├─ $this->_helper->viewRenderer->setNoRender(true)
    │
    ├─ $this->_request->getParam('type')
    │
    ├─ $this->_request->getParam('slave')
    │
    ├─ $registry->db->select()
    │      ├─ ->from('attachments')
    │      ├─ ->where('attach_slave = ?', $slave)
    │      └─ ->where('attach_type = ?', $type)
    │
    ├─ $registry->db->fetchall($select)
    │
    └─ echo 'Attachments ('.count($attachmentArray).')'
```

### データフロー図

```
[入力]               [処理]                    [出力]

URLパラメータ ───▶ AttachmentsController ───▶ テキスト応答
(type, slave)      ::tabAction()             "Attachments (件数)"
                        │
                        ▼
                  attachmentsテーブル
                  (SELECT WHERE条件)
                        │
                        ▼
                   count()で件数算出
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| AttachmentsController.php | `application/modules/admin/controllers/AttachmentsController.php` | コントローラ | タブタイトル生成アクションを提供 |
| Attachments.php | `application/models/Attachments.php` | モデル | 添付ファイルデータ構造の参照 |
