# 機能設計書 58-メール一覧表示

## 概要

本ドキュメントは、LEGACY CMSにおけるメール一覧表示機能の設計を定義する。この機能は、送信済みメールおよび下書きメールの一覧をページネーション付きで表示するための機能である。

### 本機能の処理概要

**業務上の目的・背景**：CMS管理者は、ユーザーやメーリングリスト購読者に向けてメールを送信する機能を持つ。送信履歴や下書きメールを一覧で管理し、ステータスや送信先によるフィルタリング、ソートを行えることで、効率的なメール管理が可能となる。これにより、過去の送信メールの確認や、下書きの編集・送信作業が円滑に行える。

**機能の利用シーン**：管理画面の「Mail」セクションにアクセスすると、メール一覧が表示される。一覧では件名、宛先、著者、日付などの情報が確認でき、ステータス（sent/draft）やメーリングリスト、ロールでフィルタリングできる。各メールは編集画面へのリンクを持ち、下書きメールは削除も可能。

**主要な処理内容**：
1. フィルタパラメータの取得と解析
2. メール一覧データの取得（JOIN：usersテーブル）
3. ページネーション処理
4. フィルタ条件の表示用変換
5. メーリングリスト一覧の取得
6. ビューへのデータ渡しとHTML出力

**関連システム・外部連携**：Zend_Paginatorによるページネーション。メーリングリスト（mail_groups）、ユーザーロール（users_role）との連携。

**権限による制御**：メール管理機能へのアクセスはACL（アクセス制御リスト）により制御。'mmail'リソースへのアクセス権限が必要。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 64 | メール管理画面 | 主画面 | 送信済みメール一覧を表示 |
| 66 | メール詳細画面 | 参照画面 | メールの詳細情報を表示 |
| 70 | メールリスト画面 | 参照画面 | メーリングリストを表示 |

## 機能種別

データ表示 / 一覧表示 / フィルタリング / ページネーション

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| group | integer | No | メーリングリストID | 数値チェック |
| role | integer | No | ユーザーロールID | 数値チェック |
| user | integer | No | 宛先ユーザーID | 数値チェック |
| author | integer | No | 送信者ユーザーID | 数値チェック |
| status | string | No | ステータス（sent/draft） | 値チェック |
| sort | string | No | ソート項目（date/subject/author） | 値チェック |
| order | string | No | ソート順序（asc/desc） | 値チェック |
| page | integer | No | ページ番号 | 数値チェック |
| items | integer | No | 1ページあたりの件数（デフォルト15） | 数値チェック |
| range | integer | No | ページネーションの表示範囲（デフォルト5） | 数値チェック |

### 入力データソース

- URLパラメータ経由でフィルタ・ページネーション条件を取得

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| メール一覧 | array | Zend_Paginatorインスタンス（ページネーション対応） |
| フィルタ情報 | array | 現在適用中のフィルタ条件 |
| メーリングリスト一覧 | array | 利用可能なメーリングリストの配列 |

### 出力先

- 管理画面ビュー（manage.phtml）

## 処理フロー

### 処理シーケンス

```
1. ACL権限チェック
   └─ 'mmail'リソースへのアクセス権確認
2. パラメータ設定
   └─ items=15、range=5をリクエストに設定
3. パラメータ取得
   └─ 全リクエストパラメータを取得
4. Mailモデルインスタンス化
   └─ new Mail()
5. フィルタ情報生成
   └─ getFilter()でフィルタ表示用データ生成
6. メール一覧取得
   └─ fetchMails()でページネーション付き一覧取得
7. メーリングリスト取得
   └─ fetchGroups()でリスト一覧取得
8. ビューへデータ渡し
   └─ filter、mailArray、groupArrayをビューに設定
9. 権限エラー処理
   └─ 権限なしの場合はerror/privilegesへフォワード
```

### フローチャート

```mermaid
flowchart TD
    A[開始] --> B{ACL権限チェック}
    B -->|権限あり| C[パラメータ設定]
    B -->|権限なし| D[権限エラー画面へ]
    C --> E[リクエストパラメータ取得]
    E --> F[Mailモデル生成]
    F --> G[getFilter: フィルタ情報生成]
    G --> H[fetchMails: メール一覧取得]
    H --> I[fetchGroups: メーリングリスト取得]
    I --> J[ビューにデータ設定]
    J --> K[終了]
    D --> K
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-58-01 | デフォルト表示件数 | 1ページあたり15件表示 | 常時 |
| BR-58-02 | デフォルトソート | 日付降順でソート | sort未指定時 |
| BR-58-03 | ステータスフィルタ | sent（送信済み）またはdraft（下書き）でフィルタ可能 | status指定時 |
| BR-58-04 | 送信済み削除不可 | 送信済みメールは削除UIが表示されない | status=sent |

### 計算ロジック

計算ロジックは存在しない。

## データベース操作仕様

### 操作別データベース影響一覧

| 操作 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| メール一覧取得 | mail, users | SELECT (JOIN) | メールとユーザー情報を結合取得 |
| フィルタ情報取得 | mail_groups, users_role, users | SELECT | フィルタ表示用の名前を取得 |
| メーリングリスト取得 | mail_groups | SELECT | メーリングリスト一覧を取得 |

### テーブル別操作詳細

#### mail JOIN users

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | m.*, u.user_id, u.user_alias | JOIN ON m.mail_user = u.user_id | 結合条件 |
| WHERE | mail_type, mail_slave | group/role/userフィルタ時 | 宛先タイプによる絞り込み |
| WHERE | mail_user | author指定時 | 送信者絞り込み |
| WHERE | mail_status | status指定時 | ステータス絞り込み |
| ORDER BY | mail_date / mail_subject / user_alias | sort指定による | ソート |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | 権限エラー | 'mmail'アクセス権なし | error/privilegesへフォワード |
| - | データなし | メールが存在しない | "No Mail!" メッセージ表示 |

### リトライ仕様

リトライ処理は実装されていない。

## トランザクション仕様

SELECT文のみのため、トランザクション制御は不要。

## パフォーマンス要件

- ページネーションによりデータ取得量を制限
- 大量メール時のパフォーマンス維持のためインデックスが必要

## セキュリティ考慮事項

- CMS_Controller_Action_Adminを継承しており、管理者認証が必須
- ACLによる'mmail'リソースアクセス制御
- 出力時のHTMLエスケープ（$this->escape()）

## 備考

- メーリングリストの右クリックメニューから編集・削除が可能
- フィルタはタグ形式で表示され、クリックで解除可能
- 送信済みメールは削除不可（削除リンクが表示されない）

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

メールデータの構造とテーブル関連を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | Mail.php | `application/models/Mail.php` | メールテーブル構造、フィルタ処理、ページネーション |

**読解のコツ**: mail_typeはメールの宛先タイプ（G=グループ、R=ロール、U=ユーザー）を表す。mail_slaveは宛先のIDを表す。

#### Step 2: エントリーポイントを理解する

コントローラのアクションを確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | MailController.php | `application/modules/admin/controllers/MailController.php` | manageActionメソッドの処理フロー |

**主要処理フロー**:
1. **29-50行目**: manageAction - メール一覧表示処理全体
2. **31行目**: ACL権限チェック（'mmail'リソース）
3. **33-34行目**: ページネーションパラメータ設定
4. **36行目**: 全リクエストパラメータ取得
5. **38行目**: Mailモデルインスタンス化
6. **40-42行目**: フィルタ情報、メール一覧、グループ一覧の取得

#### Step 3: モデルの処理を理解する

Mailモデルの各メソッドを確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | Mail.php | `application/models/Mail.php` | getFilter, fetchMails, fetchGroupsメソッド |

**主要処理フロー**:
- **39-127行目**: getFilter - フィルタ表示用データ生成
- **134-211行目**: fetchMails - ページネーション付きメール一覧取得
- **217-224行目**: fetchGroups - メーリングリスト一覧取得

#### Step 4: ビューテンプレートを理解する

一覧表示のUIを確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | manage.phtml | `application/modules/admin/views/scripts/mail/manage.phtml` | メール一覧画面のHTML構造 |

**主要処理フロー**:
- **39-48行目**: 新規メール作成ドロップダウン
- **53-65行目**: フィルタ表示（タグ形式）
- **75-79行目**: ステータスフィルタ（Sent/Draft）
- **115-174行目**: メール一覧テーブル
- **176-183行目**: ページネーション

### プログラム呼び出し階層図

```
Admin_MailController::manageAction()
    │
    ├─ ACL::isAllowed('mmail')
    │
    ├─ $this->_request->setParam('items', 15)
    ├─ $this->_request->setParam('range', 5)
    │
    ├─ $this->_request->getParams()
    │
    ├─ new Mail()
    │      │
    │      ├─ getFilter($params)
    │      │      └─ SELECT: mail_groups, users_role, users
    │      │
    │      ├─ fetchMails($params)
    │      │      ├─ SELECT: mail JOIN users
    │      │      └─ Zend_Paginator::factory()
    │      │
    │      └─ fetchGroups()
    │             └─ SELECT: mail_groups
    │
    └─ View: manage.phtml
```

### データフロー図

```
[入力]               [処理]                    [出力]

URLパラメータ ───▶ MailController     ───▶ HTML応答
(filter, page,     ::manageAction()         (メール一覧画面)
 sort, order)           │
                        ▼
                   Mail Model
                        │
    ┌───────────────────┼───────────────────┐
    ▼                   ▼                   ▼
mail_groups        mailテーブル          usersテーブル
(フィルタ名)     (メールデータ)        (著者情報)
    │                   │                   │
    └───────────────────┼───────────────────┘
                        ▼
                   manage.phtml
                 (HTML一覧生成)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| MailController.php | `application/modules/admin/controllers/MailController.php` | コントローラ | メール管理アクションを提供 |
| Mail.php | `application/models/Mail.php` | モデル | メールデータ操作 |
| manage.phtml | `application/modules/admin/views/scripts/mail/manage.phtml` | ビュー | メール一覧画面 |
| MStatusCount.php | `application/modules/admin/views/helpers/MStatusCount.php` | ヘルパー | ステータス別件数表示 |
| MGroupCount.php | `application/modules/admin/views/helpers/MGroupCount.php` | ヘルパー | グループ別件数表示 |
| MgetTo.php | `application/modules/admin/views/helpers/MgetTo.php` | ヘルパー | 宛先情報表示 |
