# 機能設計書 6-記事新規作成

## 概要

本ドキュメントは、LEGACY CMSにおける記事新規作成機能の設計を記述したものである。新規記事を作成し、タイトル・カテゴリを設定する仕様を定義する。

### 本機能の処理概要

**業務上の目的・背景**：CMS運用において、新しいコンテンツを追加するための基本機能である。記事はサイトの主要なコンテンツであり、ニュースやブログ投稿などの形式で公開される。迅速かつ効率的に記事を作成できることが求められる。

**機能の利用シーン**：管理者またはコンテンツ編集者が記事管理画面から「新規作成」ボタンをクリックすると、Ajaxダイアログが表示される。タイトルとカテゴリを入力して「作成」をクリックすると、記事の骨格が作成され、続けて詳細編集画面に遷移する。

**主要な処理内容**：
1. 新規作成ダイアログの表示
2. タイトルとカテゴリの入力受付
3. 入力値のバリデーション
4. 記事レコードの作成（下書き状態）
5. 記事編集画面へのリダイレクト

**関連システム・外部連携**：特になし

**権限による制御**：`aarticles`（記事モジュールアクセス）および`aarticlenew`（記事新規作成）権限が必要。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 37 | 記事新規作成画面 | 主画面 | 新規記事の作成処理 |

## 機能種別

CRUD操作（Create） / データ入力

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| articletitle | string | Yes | 記事タイトル | NotEmpty |
| articlecategory | int | Yes | カテゴリID | NotEmpty |

### 入力データソース

フォーム入力（POSTリクエスト）

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| HTML | string | Ajaxダイアログ用HTML（入力フォームまたは完了画面） |
| messages | array | バリデーションエラーメッセージ |

### 出力先

- データベース挿入（articlesテーブル）
- Ajaxダイアログ（フォーム/完了画面）
- リダイレクト（記事編集画面）

## 処理フロー

### 処理シーケンス

```
1. 権限チェック
   └─ aarticles + aarticlenew 権限を確認
2. レイアウト無効化
   └─ Ajaxダイアログとして表示
3. POSTリクエスト判定
   ├─ GET: 入力フォームを表示
   └─ POST: バリデーション実行
4. バリデーション
   └─ タイトルとカテゴリの必須チェック
5. 記事レコード作成
   └─ newArticle()でDBに挿入
6. 完了画面表示
   └─ 「続ける」ボタンで編集画面へ遷移
```

### フローチャート

```mermaid
flowchart TD
    A[新規作成リクエスト] --> B{権限チェック}
    B -->|権限なし| C[権限エラー画面]
    B -->|権限あり| D{POSTリクエスト?}
    D -->|No| E[入力フォーム表示]
    D -->|Yes| F[バリデーション]
    F --> G{バリデーション成功?}
    G -->|No| H[エラーメッセージ表示]
    H --> E
    G -->|Yes| I[記事レコード作成]
    I --> J[完了画面表示]
    J --> K[編集画面へ遷移]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-001 | 初期ステータス | 新規作成時は下書き（draft）状態 | 常時 |
| BR-002 | 作成日時自動設定 | article_dateに現在日時を設定 | 常時 |
| BR-003 | 編集日時自動設定 | article_editに現在日時を設定 | 常時 |
| BR-004 | 作成者自動設定 | ログインユーザーを著者として設定 | 常時 |

### 計算ロジック

特になし

## データベース操作仕様

### 操作別データベース影響一覧

| 操作 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| 記事作成 | articles | INSERT | 新規記事レコードを挿入 |

### テーブル別操作詳細

#### articles（INSERT）

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| INSERT | article_title | 入力されたタイトル | 必須 |
| INSERT | article_category | 選択されたカテゴリID | 必須 |
| INSERT | article_user | ログインユーザーID | 自動設定 |
| INSERT | article_date | NOW() | 自動設定 |
| INSERT | article_edit | NOW() | 自動設定 |
| INSERT | article_status | 'draft'（デフォルト） | 暗黙的 |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | 権限エラー | aarticles または aarticlenew 権限がない | 権限エラー画面へフォワード |
| IS_EMPTY (title) | バリデーションエラー | タイトル未入力 | 'Title is required'を表示 |
| IS_EMPTY (category) | バリデーションエラー | カテゴリ未選択 | 'Category is required'を表示 |

### リトライ仕様

特になし

## トランザクション仕様

単一INSERT操作のため、暗黙的にトランザクション管理される

## パフォーマンス要件

- レスポンス時間: 1秒以内

## セキュリティ考慮事項

- 管理者権限（aarticles + aarticlenew）が必要
- XSS対策: タイトル入力値のエスケープ処理が必要

## 備考

- Ajaxダイアログとして実装
- 作成後は自動的に編集画面へ遷移
- 本文やその他の詳細は編集画面で入力

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | database.sql | `database.sql` | articlesテーブル（5-20行目）の構造、デフォルト値の確認 |

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | ArticlesController.php | `application/modules/admin/controllers/ArticlesController.php` | newAction()メソッド（336-402行目） |

**主要処理フロー**:
1. **338行目**: 権限チェック（`aarticles` + `aarticlenew`）
2. **340行目**: レイアウト無効化
3. **342行目**: POSTリクエスト判定
4. **348-359行目**: バリデータの設定
5. **361行目**: バリデーション実行
6. **363-377行目**: 記事作成と完了画面表示

#### Step 3: モデル層を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | Articles.php | `application/models/Articles.php` | newArticle()メソッド（222-237行目） |

**主要処理フロー**:
- **224行目**: パラメータチェック
- **225-231行目**: データ配列の準備
- **233行目**: DBへのINSERT実行

### プログラム呼び出し階層図

```
Admin_ArticlesController::newAction()
    │
    ├─ ACL権限チェック
    │      └─ $this->view->acl->isAllowed('aarticles', 'aarticlenew')
    │
    ├─ Zend_Filter_Input (バリデーション)
    │      └─ NotEmpty (title, category)
    │
    └─ Articles::newArticle($params)
           └─ Zend_Db::insert('articles', $data)
                  └─ lastInsertId()
```

### データフロー図

```
[入力]               [処理]                    [出力]

articletitle   ───▶ Zend_Filter_Input    ───▶ 検証済みtitle
articlecategory     (バリデーション)           検証済みcategory
                           │
                           ▼
                    Articles::newArticle()
                           │
                           ▼
                    INSERT articles
                    (新規レコード作成)
                           │
                           ▼
                    lastInsertId()
                    (新規記事ID取得)
                           │
                           ▼
                    編集画面へリダイレクト
                    (/admin/articles/edit/id/{id})
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| ArticlesController.php | `application/modules/admin/controllers/ArticlesController.php` | コントローラー | 新規作成処理（336-402行目: newAction） |
| Articles.php | `application/models/Articles.php` | モデル | 記事データの挿入（222-237行目: newArticle） |
| database.sql | `database.sql` | DDL | articlesテーブル定義（5-20行目） |
