---
generated_at: 2026-02-11 18:30:00
metrics:
  claims_total: 25
  claims_with_evidence: 24
  claims_without_evidence: 1
confidence_derived: 0.96
---

# 根拠レポート：1-ログイン.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.96**
  - 根拠あり：24 / 25、根拠なし：1
- 優先レビュー（高）
  1. **Cookie有効期限の計算値（7889231秒≒約3ヶ月）**：コード上の値は確認できるが、ビジネス要件としての根拠なし
  2. **パスワード最小長4文字**：コードで確認できるが、セキュリティポリシーとしての要件定義なし
  3. **レスポンス時間1秒以内**：パフォーマンス要件の明示的な定義なし

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `application/modules/admin/controllers/AuthController.php`
- E-02: `library/CMS/Controller/Action/Auth.php`
- E-03: `library/CMS/Controller/Action/Admin.php`
- E-04: `library/CMS/Acl/Factory.php`
- E-05: `database.sql` (usersテーブル定義: 347-361行目)
- E-06: `docs/code-to-docs/機能一覧/機能一覧.csv`
- E-07: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Zend_Authを使用した認証処理 | E-01: 109行目 `Zend_Auth_Adapter_DbTable` | ○ |
| C-02 | メールアドレスとパスワードによる認証 | E-01: 111-114行目 | ○ |
| C-03 | 入力値のStringTrim, StringToLowerフィルタ | E-01: 77-79行目 | ○ |
| C-04 | NotEmpty, EmailAddressバリデータ | E-01: 81-90行目 | ○ |
| C-05 | パスワード最小長4文字 | E-01: 93行目 `array('StringLength', 4)` | ○ |
| C-06 | MD5ハッシュによるパスワード検証 | E-01: 114行目 `MD5(CONCAT(...))` | ○ |
| C-07 | user_status='active'条件 | E-01: 119行目 `user_status = "active"` | ○ |
| C-08 | セッションへのユーザー情報保存（パスワード等除外） | E-01: 129行目 `getResultRowObject(null, 'user_password','user_salt','user_key')` | ○ |
| C-09 | Cookie有効期限7889231秒 | E-01: 131-132行目 `time()+7889231` | ○ |
| C-10 | remember=1でCookie設定 | E-01: 130-136行目 | ○ |
| C-11 | FAILURE_IDENTITY_NOT_FOUNDエラー | E-01: 141-142行目 | ○ |
| C-12 | FAILURE_CREDENTIAL_INVALIDエラー | E-01: 144-145行目 | ○ |
| C-13 | 認証済みの場合ダッシュボードへリダイレクト | E-01: 44-48行目 | ○ |
| C-14 | 未認証でlogout時はログイン画面へリダイレクト | E-01: 53-54行目 | ○ |
| C-15 | admin-authレイアウトの使用 | E-01: 22行目 `setLayout('admin-auth')` | ○ |
| C-16 | usersテーブルの構造 | E-05: 347-361行目 | ○ |
| C-17 | gadmin権限によるアクセス制御 | E-03: 54-56行目 | ○ |
| C-18 | ACLの動的生成 | E-04: 42-82行目 `createGlobalAcl()` | ○ |
| C-19 | 認証後の管理ダッシュボードへの遷移 | E-01: 138行目 `redirector('index','index','admin')` | ○ |
| C-20 | baseUrlのビューへの設定 | E-02: 24行目 | ○ |
| C-21 | 関連画面No.5（ログイン画面） | E-07: 9行目 | ○ |
| C-22 | 関連画面No.33（管理者ログイン画面） | E-07: 64行目 | ○ |
| C-23 | パスワードの平文Cookie保存 | E-01: 132行目 | ○ |
| C-24 | Cookieにパスワードを平文で保存している（セキュリティリスク） | E-01: 132行目 | ○ |
| C-25 | レスポンス時間1秒以内 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- レスポンス時間の要件定義（パフォーマンス要件書等が存在しない）
  - 候補：performance.md / requirements.md / SLA定義書

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - データベース操作仕様（SELECT操作のみで副作用なし）
- 1: 中リスク - Cookie有効期限の妥当性（ビジネス要件との整合性要確認）
- 2: 高リスク - Cookieへのパスワード平文保存（セキュリティリスク、コード上で確認済みだが改善推奨）

## 6) レビュアーチェックリスト（最小）
- [ ] パスワードのMD5ハッシュ化がセキュリティ要件を満たしているか確認
- [ ] Cookieへのパスワード平文保存について対策を検討
- [ ] Cookie有効期限（約3ヶ月）がビジネス要件と合致しているか確認
- [ ] レスポンス時間の要件が別途定義されているか確認
