---
generated_at: 2026-02-11 18:50:00
metrics:
  claims_total: 17
  claims_with_evidence: 16
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：15-ページ公開非公開

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：16 / 17、根拠なし：1
- 優先レビュー（高）
  1. **非公開（Unpublish）機能の未実装確認**：draftへの戻し機能の要否
  2. **2回のUPDATE間のトランザクション**：整合性リスク
  3. **Publishボタンの配置場所**：details.phtmlの確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `application/modules/admin/controllers/PagesController.php` (216-308行目)
- E-02: `application/models/Pages.php` (243-251行目)
- E-03: `application/models/Pages.php` (207-237行目)
- E-04: `database.sql` (206-220行目)
- E-05: `docs/code-to-docs/機能一覧/機能一覧.csv` (16行目)
- E-06: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` (136行目)

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | ppages + ppagepublish権限の複合チェック | E-01 (218行目) | ○ |
| C-02 | レイアウト/ビュー無効化 | E-01 (220-221行目) | ○ |
| C-03 | confirm='1'で公開実行 | E-01 (226行目) | ○ |
| C-04 | バリデータ定義がsaveActionと同様 | E-01 (232-251行目) | ○ |
| C-05 | Pages::updatePageStatus()を呼び出す | E-01 (260-262行目) | ○ |
| C-06 | page_status='published'に更新 | E-02 (246行目) | ○ |
| C-07 | page_published=NOW()に設定 | E-02 (247行目) | ○ |
| C-08 | Pages::updatePage()を呼び出す | E-01 (263-268行目) | ○ |
| C-09 | updatePage内でSearch::updateEntry()を呼び出す | E-03 (227行目) | ○ |
| C-10 | 確認ダイアログにPublish/Closeボタン表示 | E-01 (292-298行目) | ○ |
| C-11 | postDialogでフォームデータもPOST | E-01 (296行目) | ○ |
| C-12 | page_statusは'draft'または'published' | E-04 (216行目) | ○ |
| C-13 | 機能一覧で「ページ公開/非公開」として定義 | E-05 | ○ |
| C-14 | 画面機能マッピングで61番画面の補助機能 | E-06 | ○ |
| C-15 | slugの重複チェックあり（自身除外） | E-01 (247行目) | ○ |
| C-16 | エラー時はRenderMessagesでメッセージ表示 | E-01 (282行目) | ○ |
| C-17 | 非公開（Unpublish）機能は未実装 | **根拠なし（コード確認による推測）** | △ |

## 4) 不足情報（Unknown / Missing）
- 非公開（Unpublish）機能の実装有無
  - 候補：PagesControllerの他のアクション確認 / 要件定義書
- Publishボタンの実際の配置場所
  - 候補：details.phtmlまたはedit.phtml内の詳細確認

## 5) リスクフラグ（レビュー観点）
- 1: 中リスク - 2回のUPDATE間でトランザクション管理なし
- 1: 中リスク - 非公開機能の要否が不明
- 0: 低リスク - 入力バリデーションは実装済み

## 6) レビュアーチェックリスト（最小）
- [ ] PagesController.php publishActionの実装が設計書と一致するか
- [ ] Pages.php updatePageStatus()でpage_statusとpage_publishedが正しく更新されるか
- [ ] updatePageStatus()とupdatePage()の2回のUPDATE間の整合性リスクを評価
- [ ] 非公開（Unpublish）機能の要否を確認
- [ ] Publishボタンの配置場所と権限チェックを確認
