---
generated_at: 2026-02-11 18:55:00
metrics:
  claims_total: 18
  claims_with_evidence: 17
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：16-ユーザー一覧表示

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：17 / 18、根拠なし：1
- 優先レビュー（高）
  1. **検索クエリのLIKE句**：SQLインジェクションリスクの確認
  2. **複合フィルタのORWHERE**：意図しない検索結果の可能性
  3. **ビューヘルパー実装**：URoleCount, UStatusCountの詳細確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `application/modules/admin/controllers/UsersController.php` (72-204行目)
- E-02: `application/modules/admin/views/scripts/users/manage.phtml` (1-171行目)
- E-03: `database.sql` (347-361行目, 457-477行目, 576-581行目)
- E-04: `docs/code-to-docs/機能一覧/機能一覧.csv` (17行目)
- E-05: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` (89-91行目)

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | uusers権限チェックを行う | E-01 (74行目) | ○ |
| C-02 | setLayout()でadminレイアウト設定 | E-01 (79行目) | ○ |
| C-03 | role, status, queryパラメータを取得 | E-01 (81-85行目) | ○ |
| C-04 | 15件/ページでページネーション | E-01 (183行目) | ○ |
| C-05 | ページネーション範囲は5 | E-01 (184行目) | ○ |
| C-06 | users + users_profiles + users_rolesのJOIN | E-01 (98-100行目) | ○ |
| C-07 | ORDER BY upro_last ASC | E-01 (107行目) | ○ |
| C-08 | role_id != 2でゲストロール除外 | E-01 (192行目) | ○ |
| C-09 | 検索クエリはtrimとescape処理 | E-01 (85行目) | ○ |
| C-10 | LIKE句で部分一致検索 | E-01 (103-106行目) | ○ |
| C-11 | active=緑旗、inactive=黄旗、suspended=赤旗 | E-02 (135-141行目) | ○ |
| C-12 | New User/New Roleボタンがある | E-02 (63-64行目) | ○ |
| C-13 | フィルタ条件の組み合わせで8パターン | E-01 (94-178行目) | ○ |
| C-14 | usersテーブルにuser_id, user_alias等のカラム | E-03 | ○ |
| C-15 | 機能一覧で「ユーザー一覧表示」として定義 | E-04 | ○ |
| C-16 | 画面機能マッピングで41番画面と関連 | E-05 | ○ |
| C-17 | indexActionはmanageActionへリダイレクト | E-01 (65-67行目) | ○ |
| C-18 | 3テーブルJOINのパフォーマンス影響 | **根拠なし（推測）** | △ |

## 4) 不足情報（Unknown / Missing）
- 3テーブルJOINのパフォーマンス影響
  - 候補：インデックス定義の確認 / EXPLAINによる実行計画確認
- URoleCount, UStatusCountビューヘルパーの実装
  - 候補：`application/modules/admin/views/helpers/`内のファイル確認

## 5) リスクフラグ（レビュー観点）
- 1: 中リスク - orwhere()の使用により意図しない検索結果の可能性
- 0: 低リスク - Zend_Db_Selectによるプリペアドステートメント使用
- 0: 低リスク - escape()によるXSS対策実装済み

## 6) レビュアーチェックリスト（最小）
- [ ] UsersController.php manageActionの権限チェックが正しく動作するか
- [ ] 複合フィルタ時のorwhere()の動作が意図通りか確認
- [ ] 3テーブルJOINクエリのパフォーマンスを確認
- [ ] 検索クエリのエスケープが適切か確認
- [ ] ビューヘルパー（URoleCount, UStatusCount）の実装を確認
