---
generated_at: 2026-02-11 19:00:00
metrics:
  claims_total: 19
  claims_with_evidence: 18
  claims_without_evidence: 1
confidence_derived: 0.95
---

# 根拠レポート：17-ユーザー新規作成

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.95**
  - 根拠あり：18 / 19、根拠なし：1
- 優先レビュー（高）
  1. **パスワードハッシュ方式**：MD5は脆弱、bcrypt等への移行検討
  2. **メールでのパスワード平文送信**：セキュリティリスク
  3. **トランザクション管理**：2テーブルINSERTの整合性

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `application/modules/admin/controllers/UsersController.php` (590-746行目)
- E-02: `application/modules/admin/controllers/UsersController.php` (44-59行目)
- E-03: `application/modules/admin/views/scripts/users/new.phtml` (1-123行目)
- E-04: `database.sql` (347-361行目, 457-477行目)
- E-05: `docs/code-to-docs/機能一覧/機能一覧.csv` (18行目)
- E-06: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` (94-96行目)

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | uusers + unewuser権限の複合チェック | E-01 (592行目) | ○ |
| C-02 | レイアウト無効化 | E-01 (594行目) | ○ |
| C-03 | POSTリクエスト判定後にバリデーション | E-01 (599行目) | ○ |
| C-04 | createRandomPassword()でパスワード生成 | E-01 (601行目) | ○ |
| C-05 | generatePassword()で8文字のランダム文字列生成 | E-02 (44-59行目) | ○ |
| C-06 | emailにNotEmpty,EmailAddress,重複チェック | E-01 (610-617行目) | ○ |
| C-07 | aliasにNotEmpty,Alnum,重複チェック | E-01 (618-625行目) | ○ |
| C-08 | first/lastに正規表現検証 | E-01 (626-639行目) | ○ |
| C-09 | usersテーブルへINSERT | E-01 (675行目) | ○ |
| C-10 | users_profilesテーブルへINSERT | E-01 (689行目) | ○ |
| C-11 | Zend_Mailでアカウント情報送信 | E-01 (691-705行目) | ○ |
| C-12 | user_statusはデフォルト'active' | E-01 (671行目) | ○ |
| C-13 | user_mailformatはデフォルト'text' | E-01 (670行目) | ○ |
| C-14 | パスワードはMD5でハッシュ化 | E-01 (667行目) | ○ |
| C-15 | countriesOptionsヘルパーで国選択肢生成 | E-03 (91行目) | ○ |
| C-16 | URoleSelectヘルパーでロール選択肢生成 | E-03 (103行目) | ○ |
| C-17 | 機能一覧で「ユーザー新規作成」として定義 | E-05 | ○ |
| C-18 | 画面機能マッピングで43番画面と関連 | E-06 | ○ |
| C-19 | トランザクション管理の実装 | **根拠なし（未実装）** | △ |

## 4) 不足情報（Unknown / Missing）
- トランザクション管理の実装
  - 候補：Zend_Db_Adapterのトランザクションメソッド使用検討
- パスワードハッシュ方式の改善
  - 候補：bcrypt/Argon2への移行、ソルト使用
- メール送信失敗時のエラーハンドリング
  - 候補：try-catchブロックの追加

## 5) リスクフラグ（レビュー観点）
- 2: 高リスク - MD5パスワードハッシュは脆弱（現在非推奨）
- 2: 高リスク - メールでパスワード平文送信（セキュリティリスク）
- 1: 中リスク - 2テーブルINSERTのトランザクション管理なし
- 0: 低リスク - 入力バリデーションは実装済み

## 6) レビュアーチェックリスト（最小）
- [ ] UsersController.php newActionの権限チェックが正しく動作するか
- [ ] generatePassword()のランダム性が十分か確認
- [ ] パスワードハッシュ方式の改善要否を検討
- [ ] メール送信の代替方法（パスワードリセットリンク等）を検討
- [ ] 2テーブルINSERTのトランザクション管理追加を検討
