---
generated_at: 2026-02-11 10:30:00
metrics:
  claims_total: 18
  claims_with_evidence: 17
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：21-イベント一覧表示

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：17 / 18、根拠なし：1
- 優先レビュー（高）
  1. **パフォーマンス要件**：具体的な数値目標の根拠不足
  2. **イベント設定ファイル（events.ini）**：ファイル内容未確認
  3. **デフォルト会場（venue_id = 1）の特別扱い**：ビジネス要件の明確化が必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `application/modules/admin/controllers/EventsController.php` - 管理画面イベントコントローラー
- E-02: `application/modules/default/controllers/EventsController.php` - フロントエンドイベントコントローラー
- E-03: `application/modules/admin/views/scripts/events/manage.phtml` - 管理画面イベント一覧ビュー
- E-04: `library/CMS/Controller/Action/Admin.php` - 管理画面基底コントローラー
- E-05: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能一覧定義
- E-06: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 画面機能マッピング定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 管理画面でeevents権限チェックが行われる | E-01 125行目 `$this->view->acl->isAllowed($this->view->user->user_role, 'eevents')` | ○ |
| C-02 | カテゴリと会場でフィルタリングできる | E-01 133-134行目, 144-177行目 | ○ |
| C-03 | ページネーションは15件/ページ | E-01 182行目 `$paginator->setItemCountPerPage(15)` | ○ |
| C-04 | 管理画面はイベント日付降順でソート | E-01 153行目, 161行目, 169行目, 176行目 `order('e.event_date DESC')` | ○ |
| C-05 | フロントエンドはイベント日付昇順でソート | E-02 50行目 `order('e.event_date ASC')` | ○ |
| C-06 | フロントエンドは公開済みイベントのみ表示 | E-02 48行目 `where('event_status = ?','published')` | ○ |
| C-07 | フロントエンドは将来日付のイベントのみ表示 | E-02 49行目 `where('event_date >= NOW()')` | ○ |
| C-08 | events, events_categories, events_venues テーブルをJOIN | E-01 151-152行目, E-02 46-47行目 | ○ |
| C-09 | EDate()メソッドで日付フォーマット処理 | E-01 20-46行目 | ○ |
| C-10 | getVenue()で会場名取得 | E-01 48-83行目 | ○ |
| C-11 | getCategory()でカテゴリ名取得 | E-01 85-111行目 | ○ |
| C-12 | 権限エラー時はprivileges画面へ転送 | E-01 190-191行目 `$this->_forward('privileges','error','admin')` | ○ |
| C-13 | Zend_Paginatorを使用 | E-01 180行目 `Zend_Paginator::factory($select)` | ○ |
| C-14 | カレンダー表示は年月日パラメータで絞り込み | E-02 72-77行目, 85-154行目 | ○ |
| C-15 | Dojo Toolkitを使用したUI | E-03 9-21行目 dojoのrequire文 | ○ |
| C-16 | 管理画面アクセスには認証が必要 | E-04 47-59行目 preDispatch()での認証チェック | ○ |
| C-17 | 関連画面の機能マッピングが正確 | E-06 画面No.16,17,18,19,20,48 | ○ |
| C-18 | レスポンス時間の具体的要件 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- パフォーマンス要件の具体的数値（レスポンス時間等）はソースコードからは確認できない
  - 候補：要件定義書 / 非機能要件定義書 / 運用マニュアル
- events.iniの内容（rowsパラメータの具体値）
  - 候補：`application/configs/events.ini` ファイルの確認

## 5) リスクフラグ（レビュー観点）
- 0: フィルタリング機能・ページネーション機能 - 低リスク（コードで明確に確認可能）
- 0: 権限チェック処理 - 低リスク（ACL実装が明確）
- 1: デフォルト会場（venue_id = 1）の特別扱い - 中リスク（ビジネスロジックの妥当性確認必要）
- 1: パフォーマンス要件 - 中リスク（具体的数値の根拠不足）

## 6) レビュアーチェックリスト（最小）
- [ ] events.iniファイルの設定値（rows）がドキュメントの15件/ページと一致するか確認
- [ ] デフォルト会場（venue_id = 1）の特別扱いがビジネス要件として適切か確認
- [ ] カレンダー表示時のパラメータ不足エラー処理が適切か確認
- [ ] SQLインジェクション対策が適切に実装されているか確認（Zend_Db_Select使用）
