---
generated_at: 2026-02-11 10:35:00
metrics:
  claims_total: 15
  claims_with_evidence: 15
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：22-イベント新規作成

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：15 / 15、根拠なし：0
- 優先レビュー（高）
  1. **デフォルト終了時刻（+2時間）の妥当性**：ビジネス要件との整合確認
  2. **カテゴリデフォルト設定の運用**：実際の設定内容確認
  3. **draft状態での保存**：公開フローとの整合確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `application/modules/admin/controllers/EventsController.php` - 管理画面イベントコントローラー（newAction: 696-757行目, new2Action: 762-877行目）
- E-02: `application/modules/admin/views/scripts/events/new.phtml` - 新規作成フォーム（第1段階）
- E-03: `application/modules/admin/views/scripts/events/manage.phtml` - イベント管理画面（ダイアログ呼び出し元）
- E-04: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能一覧定義
- E-05: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 画面機能マッピング定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | eevents + eeventnew権限チェックが行われる | E-01 698行目, 764行目 `isAllowed($this->view->user->user_role, 'eeventnew')` | ○ |
| C-02 | 2段階ウィザード形式で実装されている | E-01 newAction, new2Action の2つのアクション | ○ |
| C-03 | 第1段階でeventvenue, eventcategoryが必須 | E-01 708-717行目 validators配列定義 | ○ |
| C-04 | 第2段階でeventtitle, eventdatestart, eventtimestartが必須 | E-01 778-802行目 validators配列定義 | ○ |
| C-05 | バリデーション成功時に第2段階へリダイレクト | E-01 724-731行目 `$this->_redirector->gotoSimple('new2'...)` | ○ |
| C-06 | カテゴリのデフォルト設定を取得 | E-01 809-820行目 events_categoriesテーブルからSELECT | ○ |
| C-07 | デフォルト終了時刻は開始から2時間後 | E-01 824行目 `strtotime($formatstart.' + 2 hours')` | ○ |
| C-08 | 会場が0の場合カテゴリデフォルト会場を適用 | E-01 826-830行目 条件分岐処理 | ○ |
| C-09 | カテゴリのecat_defaultを説明文初期値として設定 | E-01 837行目 `'event_description' => $this->view->categoryArray['ecat_default']` | ○ |
| C-10 | event_userにログインユーザーIDを設定 | E-01 840行目 `'event_user' => $this->view->user->user_id` | ○ |
| C-11 | データベースINSERT実行 | E-01 844行目 `$registry->db->insert('events', $data)` | ○ |
| C-12 | 成功メッセージ「Event Created」表示 | E-01 847行目 `<div class="cUpd">Event Created</div>` | ○ |
| C-13 | 編集画面への遷移ボタン表示 | E-01 850行目 `goTo('/admin/events/edit/id/'.$registry->db->lastInsertId().'')` | ○ |
| C-14 | Zend_Filter_Inputによるバリデーション | E-01 720行目, 805行目 `new Zend_Filter_Input(...)` | ○ |
| C-15 | レイアウト無効化（Ajaxダイアログ用） | E-01 699行目, 765行目 `$this->_helper->layout->disableLayout()` | ○ |

## 4) 不足情報（Unknown / Missing）
- 該当なし（全ての主張に根拠あり）

## 5) リスクフラグ（レビュー観点）
- 0: バリデーション処理 - 低リスク（コードで明確に確認可能）
- 0: 権限チェック処理 - 低リスク（ACL実装が明確）
- 1: デフォルト終了時刻（+2時間）- 中リスク（ビジネス要件との整合確認推奨）
- 0: データベースINSERT処理 - 低リスク（Zend_Dbによる安全な実装）

## 6) レビュアーチェックリスト（最小）
- [ ] デフォルト終了時刻（+2時間）がビジネス要件として適切か確認
- [ ] カテゴリデフォルト設定（ecat_default, ecat_venue）の実際の運用を確認
- [ ] draft状態で保存後の公開フロー（publishAction）との整合を確認
- [ ] new2.phtmlビューファイルの存在を確認
