---
generated_at: 2026-02-11 10:50:00
metrics:
  claims_total: 14
  claims_with_evidence: 13
  claims_without_evidence: 1
confidence_derived: 0.93
---

# 根拠レポート：25-イベント公開/非公開

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：13 / 14、根拠なし：1
- 優先レビュー（高）
  1. **非公開（unpublish）機能の有無**：コードに実装が見当たらない
  2. **公開前バリデーションの網羅性**：必須項目が適切か確認
  3. **検索インデックス登録タイミング**：パフォーマンス影響確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `application/modules/admin/controllers/EventsController.php` - 管理画面イベントコントローラー（publishAction: 449-620行目）
- E-02: `application/modules/admin/views/scripts/events/edit.phtml` - 編集画面ビュー
- E-03: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能一覧定義
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 画面機能マッピング定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | eevents + eeventpublish権限チェックが行われる | E-01 451行目 `isAllowed($this->view->user->user_role, 'eeventpublish')` | ○ |
| C-02 | confirm='1'かつid設定で公開処理実行 | E-01 459行目 `if ($this->view->confirm == '1' & isset($this->view->event))` | ○ |
| C-03 | 公開前にバリデーション実行 | E-01 481-516行目 validators配列、518行目 Zend_Filter_Input | ○ |
| C-04 | event_statusを'published'に設定 | E-01 543行目 `'event_status' => 'published'` | ○ |
| C-05 | event_publishedをNOW()に設定 | E-01 542行目 `'event_published' => new Zend_Db_Expr('NOW()')` | ○ |
| C-06 | 検索インデックスにadd（追加）実行 | E-01 573行目 `$this->_helper->searchIndex->add(...)` | ○ |
| C-07 | 検索インデックスキーは'e'+event_id | E-01 573行目 `'key' => 'e'.$this->view->event` | ○ |
| C-08 | 会場情報に基づいてdetailsを生成 | E-01 563-571行目 条件分岐でvenue_id != '1'判定 | ○ |
| C-09 | 成功メッセージ「Event Published」表示 | E-01 583行目 `<div class="cUpd">Event Published</div>` | ○ |
| C-10 | 確認メッセージ「Are you sure you want to publish this event?」表示 | E-01 605行目 | ○ |
| C-11 | 確認ダイアログにPublish/Cancelボタン表示 | E-01 608-609行目 | ○ |
| C-12 | postDialog()でフォームデータをPOST | E-01 608行目 `postDialog('/admin/events/publish/id/...')` | ○ |
| C-13 | バリデーションエラー時はエラーメッセージ表示 | E-01 591-598行目 messages->render | ○ |
| C-14 | 非公開（unpublish）機能は実装されていない | **根拠なし（コードに実装見当たらず）** | △ |

## 4) 不足情報（Unknown / Missing）
- 非公開（unpublish）機能の要件有無
  - 候補：要件定義書 / 他のコントローラーの確認
- edit.phtmlでの公開ボタン実装の詳細
  - 候補：ビューファイルの詳細確認

## 5) リスクフラグ（レビュー観点）
- 0: 権限チェック処理 - 低リスク（ACL実装が明確）
- 0: バリデーション処理 - 低リスク（Zend_Filter_Input使用）
- 1: 非公開機能の欠如 - 中リスク（運用要件との整合確認必要）
- 0: 検索インデックス追加 - 低リスク（add操作で明確）
- 1: 公開取り消し不可 - 中リスク（誤公開時の対応手段確認必要）

## 6) レビュアーチェックリスト（最小）
- [ ] 非公開（unpublish）機能が運用上必要かどうか確認
- [ ] 公開前バリデーションの必須項目が適切か確認
- [ ] 誤公開時の対応手順を確認（削除のみ？ステータス変更可能？）
- [ ] 検索インデックス追加のパフォーマンス影響を確認
