---
generated_at: 2026-02-11 18:40:00
metrics:
  claims_total: 20
  claims_with_evidence: 20
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：3-パスワードリセット.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：20 / 20、根拠なし：0
- 優先レビュー（高）
  1. なし - すべての主張に根拠あり

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `application/modules/admin/controllers/AuthController.php`
- E-02: `database.sql` (usersテーブル: 347-361行目、users_profilesテーブル: 456-477行目)
- E-03: `docs/code-to-docs/機能一覧/機能一覧.csv`
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | メールアドレスの存在確認バリデーション | E-01: 188行目 `Zend_Validate_Db_RecordExists('users','user_email')` | ○ |
| C-02 | StringTrim, StringToLowerフィルタ | E-01: 180行目 | ○ |
| C-03 | NotEmpty, EmailAddressバリデータ | E-01: 185-187行目 | ○ |
| C-04 | 8文字のランダムパスワード生成 | E-01: 32行目 `while ($i <= 7)` | ○ |
| C-05 | 紛らわしい文字を除外した文字セット | E-01: 27行目 | ○ |
| C-06 | srand/randによる乱数生成 | E-01: 28行目, 33行目 | ○ |
| C-07 | ソルトの再生成 | E-01: 213行目 `$salt = $this->generatePassword()` | ○ |
| C-08 | MD5ハッシュ化 | E-01: 217行目 `md5($registry->site->site->key.$password.$salt)` | ○ |
| C-09 | users + users_profilesのJOIN | E-01: 201-205行目 | ○ |
| C-10 | データベース更新 | E-01: 222行目 `$registry->db->update('users', ...)` | ○ |
| C-11 | Zend_Mailによるメール送信 | E-01: 224行目 `$mail = new Zend_Mail()` | ○ |
| C-12 | メール本文に平文パスワード | E-01: 227行目 `'Your new password is: '.$password` | ○ |
| C-13 | admin-authレイアウトの使用 | E-01: 173行目 `$this->setLayout()` → 22行目 | ○ |
| C-14 | IS_EMPTY エラーメッセージ | E-01: 189行目 | ○ |
| C-15 | INVALID エラーメッセージ | E-01: 189行目 | ○ |
| C-16 | ERROR_NO_RECORD_FOUND エラーメッセージ | E-01: 189行目 | ○ |
| C-17 | posted = 'Y' で成功表示 | E-01: 237行目 | ○ |
| C-18 | posted = 'N' でフォーム表示 | E-01: 241行目, 253行目 | ○ |
| C-19 | 関連画面No.6（パスワードリセット画面） | E-04: 11行目 | ○ |
| C-20 | メール送信機能との連携 | E-04: 12行目 | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし

## 5) リスクフラグ（レビュー観点）
- 1: 中リスク - メールアドレス列挙攻撃の可能性（存在しないメールアドレスと存在するアドレスで異なるエラーメッセージ）
- 2: 高リスク - MD5ハッシュの使用（現代のセキュリティ基準では脆弱）
- 2: 高リスク - rand/srandによる乱数生成（暗号学的に安全ではない）
- 1: 中リスク - トランザクション制御なし（DB更新後にメール送信失敗時の整合性）

## 6) レビュアーチェックリスト（最小）
- [ ] メールアドレス列挙攻撃への対策を検討（エラーメッセージの統一化）
- [ ] パスワードハッシュアルゴリズムの改善を検討（bcrypt等への移行）
- [ ] 暗号学的に安全な乱数生成への移行を検討
- [ ] パスワードリセットのレート制限の実装を検討
- [ ] トークンベースのパスワードリセットフローへの移行を検討
