---
generated_at: 2026-02-11 19:30:00
metrics:
  claims_total: 18
  claims_with_evidence: 17
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：31-アセット選択

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：17 / 18、根拠なし：1
- 優先レビュー（高）
  1. **assets.jsの実装詳細**：クライアントサイドJavaScriptの実装確認が必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `application/modules/admin/controllers/AssetsController.php` - indexAction() 59-114行目
- E-02: `application/modules/admin/controllers/AssetsController.php` - assetType() 31-54行目
- E-03: `application/modules/admin/controllers/AssetsController.php` - imageinsertAction() 1043-1078行目
- E-04: `application/modules/admin/controllers/AssetsController.php` - linkinsertAction() 1183-1196行目
- E-05: `application/modules/admin/views/scripts/assets/index.phtml` - 全体
- E-06: `application/modules/admin/views/scripts/assets/imageinsert.phtml` - 全体
- E-07: `application/modules/admin/views/scripts/assets/linkinsert.phtml` - 全体
- E-08: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 画面No.83, 84

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | fassets権限によるアクセス制御 | E-01 (61行目) | ○ |
| C-02 | フォルダ階層表示（親フォルダ、サブフォルダ） | E-01 (77-99行目) | ○ |
| C-03 | アセット一覧取得クエリ | E-01 (101-108行目) | ○ |
| C-04 | アセットタイプ判定（image/video/audio/flash/other） | E-02 (33-51行目) | ○ |
| C-05 | 画像のMIMEタイプ定義 | E-02 (33行目: jpeg, gif, png, bmp) | ○ |
| C-06 | 画像挿入時のサイズ取得 | E-03 (1069-1071行目) | ○ |
| C-07 | 3種類のリサイズモード（resize, adaptive, crop） | E-06 (19-21行目) | ○ |
| C-08 | 2種類のリンクタイプ（download, open） | E-07 (13-20行目) | ○ |
| C-09 | method=editorでの画像挿入処理分岐 | E-05 (102-112行目) | ○ |
| C-10 | method=linkでのリンク挿入処理分岐 | E-05 (114-116行目) | ○ |
| C-11 | method=selectでのchooseFile呼び出し | E-05 (118-120行目) | ○ |
| C-12 | Dojo Toolkitによるダイアログ表示 | E-05 (33行目), E-06 | ○ |
| C-13 | 関連画面No.83（画像挿入画面） | E-08 | ○ |
| C-14 | 関連画面No.84（リンク挿入画面） | E-08 | ○ |
| C-15 | PhpThumbFactoryによるサムネイル生成 | E-01 (thumbAction内) | ○ |
| C-16 | asset_keyはMD5ハッシュ値 | E-01 (480行目) | ○ |
| C-17 | assets_foldersテーブルからのフォルダ情報取得 | E-01 (80-99行目) | ○ |
| C-18 | imageInsert()、linkInsert()のJavaScript実装 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- assets.jsファイルの実装詳細が未確認
  - 候補：`public/_scripts/admin/assets.js` / `public/_scripts/admin/common.js`

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 機能設計書の主要な主張はコードで確認可能

## 6) レビュアーチェックリスト（最小）
- [ ] assets.jsのimageInsert()、linkInsert()、chooseFile()関数の実装を確認
- [ ] 権限チェックの実装が全アクションで統一されているか確認
- [ ] エラーハンドリングの実装を確認
