---
generated_at: 2026-02-11 19:35:00
metrics:
  claims_total: 12
  claims_with_evidence: 12
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：32-リソース一覧表示

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：12 / 12、根拠なし：0
- 優先レビュー（高）
  - なし（全主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `application/modules/admin/controllers/ResourcesController.php` - manageAction() 69-135行目
- E-02: `application/modules/admin/controllers/ResourcesController.php` - getType() 17-30行目
- E-03: `application/modules/admin/controllers/ResourcesController.php` - getCategory() 32-56行目
- E-04: `application/modules/admin/controllers/ResourcesController.php` - indexAction() 61-64行目
- E-05: `docs/code-to-docs/機能一覧/機能一覧.csv` - No.32

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | rresources権限によるアクセス制御 | E-01 (71行目) | ○ |
| C-02 | 15件/ページのページネーション | E-01 (123行目) | ○ |
| C-03 | ページ範囲5の設定 | E-01 (124行目) | ○ |
| C-04 | デフォルトページは1 | E-01 (84-88行目) | ○ |
| C-05 | resource_date DESCでソート | E-01 (98, 105, 112, 117行目) | ○ |
| C-06 | categoryパラメータでフィルタ可能 | E-01 (90-105行目) | ○ |
| C-07 | typeパラメータでフィルタ可能 | E-01 (90-112行目) | ○ |
| C-08 | resources_categoriesとのJOIN | E-01 (97, 104, 111, 116行目) | ○ |
| C-09 | getType()でrtype_plural取得 | E-02 (22-29行目) | ○ |
| C-10 | getCategory()でrcat_title取得 | E-03 (37-49行目) | ○ |
| C-11 | indexActionはmanageへリダイレクト | E-04 (63行目) | ○ |
| C-12 | Zend_Paginator使用 | E-01 (121行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - すべての主張がコードで確認可能

## 6) レビュアーチェックリスト（最小）
- [ ] ビューファイル（manage.phtml）の存在と内容を確認
- [ ] ページネーションコンポーネントの動作を確認
