---
generated_at: 2026-02-11 19:45:00
metrics:
  claims_total: 18
  claims_with_evidence: 18
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：34-リソース編集

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：18 / 18、根拠なし：0
- 優先レビュー（高）
  - なし（全主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `application/modules/admin/controllers/ResourcesController.php` - editAction() 140-172行目
- E-02: `application/modules/admin/controllers/ResourcesController.php` - saveAction() 234-415行目
- E-03: `docs/code-to-docs/機能一覧/機能一覧.csv` - No.34

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | rresources + rresourceedit権限チェック（edit） | E-01 (142行目) | ○ |
| C-02 | rresources + rresourceedit権限チェック（save） | E-02 (236行目) | ○ |
| C-03 | リソース未検出時はmanageへリダイレクト | E-01 (162-163行目) | ○ |
| C-04 | コメントチェックボックスY/N変換 | E-02 (246-250行目) | ○ |
| C-05 | モデレートチェックボックスY/N変換 | E-02 (252-257行目) | ○ |
| C-06 | title必須バリデーション | E-02 (277-281行目) | ○ |
| C-07 | category必須バリデーション | E-02 (282-286行目) | ○ |
| C-08 | brand必須バリデーション | E-02 (287-291行目) | ○ |
| C-09 | description必須バリデーション | E-02 (295-299行目) | ○ |
| C-10 | content必須バリデーション | E-02 (300-304行目) | ○ |
| C-11 | resource_type=='1'でISBN等保存 | E-02 (317-333行目) | ○ |
| C-12 | それ以外はISBN等NULL | E-02 (337-351行目) | ○ |
| C-13 | html_entity_decode適用 | E-02 (328, 346行目) | ○ |
| C-14 | resource_edit NOW()更新 | E-02 (332, 350行目) | ○ |
| C-15 | resourcesテーブルUPDATE | E-02 (356行目) | ○ |
| C-16 | 公開済みの場合検索インデックス更新 | E-02 (359行目) | ○ |
| C-17 | searchIndex->update()呼び出し | E-02 (367-374行目) | ○ |
| C-18 | id未指定時のエラーメッセージ | E-02 (398-405行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - すべての主張がコードで確認可能

## 6) レビュアーチェックリスト（最小）
- [ ] ビューファイル（edit.phtml）の存在と内容確認
- [ ] 検索インデックス更新の動作確認
- [ ] リッチテキストエディタとの連携確認
