---
generated_at: 2026-02-11 19:55:00
metrics:
  claims_total: 14
  claims_with_evidence: 14
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：36-リソース公開/非公開

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：14 / 14、根拠なし：0
- 優先レビュー（高）
  - なし（全主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `application/modules/admin/controllers/ResourcesController.php` - publishAction() 420-602行目
- E-02: `docs/code-to-docs/機能一覧/機能一覧.csv` - No.36

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | rresources + rresourcepublish権限チェック | E-01 (422行目) | ○ |
| C-02 | confirm + id パラメータ取得 | E-01 (427-428行目) | ○ |
| C-03 | confirm='1'で公開実行 | E-01 (430行目) | ○ |
| C-04 | 既存リソース情報取得 | E-01 (436-443行目) | ○ |
| C-05 | バリデーション実行 | E-01 (463-502行目) | ○ |
| C-06 | resource_type=='1'でISBN等保存 | E-01 (504-522行目) | ○ |
| C-07 | それ以外はISBN等NULL | E-01 (524-542行目) | ○ |
| C-08 | resource_status='published'設定 | E-01 (521, 541行目) | ○ |
| C-09 | resource_publish NOW()設定 | E-01 (520, 540行目) | ○ |
| C-10 | resource_edit NOW()設定 | E-01 (519, 539行目) | ○ |
| C-11 | DB UPDATE実行 | E-01 (547行目) | ○ |
| C-12 | 検索インデックスURL生成 | E-01 (549-550行目) | ○ |
| C-13 | searchIndex->add()呼び出し | E-01 (555-562行目) | ○ |
| C-14 | 確認ダイアログ表示（confirm未指定時） | E-01 (584-592行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - すべての主張がコードで確認可能

## 6) レビュアーチェックリスト（最小）
- [ ] 非公開化機能の有無を確認（現状は公開のみ）
- [ ] 公開済みリソースの再公開時の挙動確認
- [ ] 検索インデックス登録失敗時のエラーハンドリング確認
