---
generated_at: 2026-02-11 20:10:00
metrics:
  claims_total: 12
  claims_with_evidence: 11
  claims_without_evidence: 1
confidence_derived: 0.92
---

# 根拠レポート：39-ローテーター一覧表示

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.92**
  - 根拠あり：11 / 12、根拠なし：1
- 優先レビュー（高）
  1. **rotSlideCountヘルパー**：ビューヘルパーの実装確認が必要

## 2) 参照した情報（Evidence一覧）

- E-01: `application/modules/admin/controllers/RotatorsController.php` - manageAction() 29-47行目
- E-02: `application/modules/admin/controllers/RotatorsController.php` - indexAction() 22-24行目
- E-03: `application/models/Rotators.php` - fetchRotators() 24-54行目
- E-04: `application/modules/admin/views/scripts/rotators/manage.phtml` - 全体
- E-05: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 画面No.87
- E-06: `docs/code-to-docs/機能一覧/機能一覧.csv` - No.39

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | rotrotators権限チェック | E-01 (31行目) | ○ |
| C-02 | items=15, range=5パラメータ設定 | E-01 (33-34行目) | ○ |
| C-03 | indexActionはmanageへリダイレクト | E-02 (23行目) | ○ |
| C-04 | Rotators::fetchRotators()呼び出し | E-01 (40行目) | ○ |
| C-05 | rotatorsテーブルからSELECT | E-03 (26-27行目) | ○ |
| C-06 | rot_name ASCでソート | E-03 (28行目) | ○ |
| C-07 | Zend_Paginator使用 | E-03 (48行目) | ○ |
| C-08 | デフォルトページは1 | E-03 (30-34行目) | ○ |
| C-09 | ビューにテーブルヘッダー表示 | E-04 (30-37行目) | ○ |
| C-10 | ページネーションコントロール表示 | E-04 (67-71行目) | ○ |
| C-11 | rotSlideCountでスライド数表示 | E-04 (47行目) | ○ |
| C-12 | rotSlideCountヘルパーの実装 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- rotSlideCountビューヘルパーの実装ファイルが未確認
  - 候補：`application/modules/admin/views/helpers/RotSlideCount.php`

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 主要なロジックはコードで確認可能

## 6) レビュアーチェックリスト（最小）
- [ ] rotSlideCountヘルパーの実装確認
- [ ] ローテーター新規作成機能の有無確認（現状は一覧と編集のみ）
