---
generated_at: 2026-02-11 20:15:00
metrics:
  claims_total: 18
  claims_with_evidence: 18
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：40-ローテーター編集

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：18 / 18、根拠なし：0
- 優先レビュー（高）
  - なし（全主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `application/modules/admin/controllers/RotatorsController.php` - editAction() 53-80行目
- E-02: `application/modules/admin/controllers/RotatorsController.php` - slidenewAction() 85-166行目
- E-03: `application/modules/admin/controllers/RotatorsController.php` - slideAction() 171-257行目
- E-04: `application/modules/admin/controllers/RotatorsController.php` - slidedeleteAction() 262-302行目
- E-05: `application/models/Rotators.php` - fetchRotator() 103-116行目
- E-06: `application/models/Rotators.php` - fetchSlides() 61-96行目
- E-07: `application/models/Rotators.php` - fetchSlide() 123-136行目
- E-08: `application/models/Rotators.php` - newSlide() 142-159行目
- E-09: `application/models/Rotators.php` - updateSlide() 179-190行目
- E-10: `application/models/Rotators.php` - deleteSlide() 165-173行目
- E-11: `application/modules/admin/views/scripts/rotators/edit.phtml` - 全体
- E-12: `application/modules/admin/views/scripts/rotators/slidenew.phtml` - 全体
- E-13: `application/modules/admin/views/scripts/rotators/slide.phtml` - 全体
- E-14: `docs/code-to-docs/機能一覧/機能一覧.csv` - No.40

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | rotrotators + rotrotatoredit権限チェック（編集画面） | E-01 (55行目) | ○ |
| C-02 | items=15, range=5パラメータ設定 | E-01 (57-58行目) | ○ |
| C-03 | fetchRotator()でローテーター詳細取得 | E-01 (66行目), E-05 | ○ |
| C-04 | 存在しない場合は一覧へリダイレクト | E-01 (68-70行目) | ○ |
| C-05 | fetchSlides()でスライド一覧取得 | E-01 (72行目), E-06 | ○ |
| C-06 | slidenewでレイアウト無効化 | E-02 (87行目) | ○ |
| C-07 | slidetitle, slidelink, slidepriority, asset: NotEmpty | E-02 (97-123行目) | ○ |
| C-08 | newSlide()でスライド作成 | E-02 (130行目), E-08 | ○ |
| C-09 | slideActionで権限チェック | E-03 (173行目) | ○ |
| C-10 | fetchSlide()でスライド詳細取得 | E-03 (181行目), E-07 | ○ |
| C-11 | updateSlide()でスライド更新 | E-03 (221-227行目), E-09 | ○ |
| C-12 | slidedeleteで権限チェック | E-04 (264行目) | ○ |
| C-13 | レイアウト・ビュー無効化 | E-04 (266-267行目) | ○ |
| C-14 | confirm=1で削除実行 | E-04 (272行目) | ○ |
| C-15 | deleteSlide()でスライド削除 | E-04 (275行目), E-10 | ○ |
| C-16 | rots_title ASCでソート | E-06 (70行目) | ○ |
| C-17 | ビューにFunctionsボタン表示 | E-11 (35-41行目) | ○ |
| C-18 | ビューにスライド一覧テーブル表示 | E-11 (64-93行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 主要なロジックはコードで確認可能

## 6) レビュアーチェックリスト（最小）
- [ ] ローテーター自体の設定変更機能の有無確認（現状はスライド管理のみ）
- [ ] スライド削除時の画像アセットへの影響確認
- [ ] スライドの優先度（rots_order）による表示順序の確認
