---
generated_at: 2026-02-11 19:10:00
metrics:
  claims_total: 14
  claims_with_evidence: 14
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：49-タグ一覧表示

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：14 / 14、根拠なし：0
- 優先レビュー（高）
  - 全ての主張に根拠が存在するため、優先レビュー項目はありません

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `application/modules/admin/controllers/TagsController.php` - showAction（28-47行目）
- E-02: `application/modules/admin/views/scripts/tags/show.phtml` - 一覧表示ビュー
- E-03: `database.sql` - tagsテーブル定義（335-341行目）
- E-04: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能No.49の定義
- E-05: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 画面No.2等との関連

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | コンテンツに紐づくタグ一覧を表示する機能である | E-01, E-02 | ○ |
| C-02 | レイアウトを無効化する | E-01 (30行目) | ○ |
| C-03 | typeパラメータを取得する | E-01 (33行目) | ○ |
| C-04 | slaveパラメータを取得する | E-01 (32行目) | ○ |
| C-05 | tagsテーブルからSELECTする | E-01 (39行目) | ○ |
| C-06 | tag_typeでフィルタリング | E-01 (41行目) | ○ |
| C-07 | tag_slaveでフィルタリング | E-01 (42行目) | ○ |
| C-08 | クリックで削除可能な形式で表示 | E-02 (11行目: onClick="deleteTag") | ○ |
| C-09 | ホバー時にスタイルが変わる（tagItm_del） | E-02 (11行目: onmouseover) | ○ |
| C-10 | タグ0件の場合「No Tags!」を表示 | E-02 (14行目) | ○ |
| C-11 | tag_typeは1文字のコード | E-03 (337行目: varchar(1)) | ○ |
| C-12 | showActionには明示的な権限チェックがない | E-01 (権限チェックコードなし) | ○ |
| C-13 | ページネーションなしで全タグを表示 | E-01 (Paginatorなし) | ○ |
| C-14 | tagArrayとしてビューに渡す | E-01 (45行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- 全ての主張に対して根拠が確認できたため、不足情報はありません。

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての主張がソースコードによって裏付けられている
- 注意: showActionに明示的な権限チェックがないため、セキュリティレビューを推奨

## 6) レビュアーチェックリスト（最小）
- [ ] showActionに権限チェックを追加すべきか検討
- [ ] 必須パラメータ（type, slave）が指定されない場合のエラーハンドリングを確認
- [ ] タグ文字列のXSSエスケープ処理を確認
