---
generated_at: 2026-02-11 11:10:00
metrics:
  claims_total: 22
  claims_with_evidence: 21
  claims_without_evidence: 1
confidence_derived: 0.95
---

# 根拠レポート：59-メール送信

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.95**
  - 根拠あり：21 / 22、根拠なし：1
- 優先レビュー（高）
  1. **送信ステータス更新**：mail_statusをsentに更新するコードの確認
  2. **936行目typo**：$htmltmailは$htmlmailの誤り
  3. **大量送信パフォーマンス**：BCC上限の考慮

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `application/modules/admin/controllers/MailController.php` - sendActionメソッド（700-1158行目）
- E-02: `application/modules/admin/controllers/MailController.php` - sendtestActionメソッド（512-695行目）
- E-03: `application/models/Mail.php` - メール関連メソッド
- E-04: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能No.59の定義
- E-05: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 画面との紐付け情報

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | システムからメールを送信する機能 | E-04 | ○ |
| C-02 | sendActionがエントリーポイント | E-01 | ○ |
| C-03 | ACL権限チェック('mmail' + 'mmailsend') | E-01（702行目） | ○ |
| C-04 | confirm=1で送信実行 | E-01（710行目） | ○ |
| C-05 | Zend_Filter_Inputでバリデーション | E-01（750行目） | ○ |
| C-06 | 送信済みチェック(mail_status != 'sent') | E-01（763行目） | ○ |
| C-07 | updateMailで送信前に更新 | E-01（765-770行目） | ○ |
| C-08 | mail_type='G'でグループ送信 | E-01（774行目） | ○ |
| C-09 | mail_type='R'でロール送信 | E-01（887行目） | ○ |
| C-10 | mail_type='U'でユーザー送信 | E-01（997行目） | ○ |
| C-11 | fetchSubscriptionsで購読者取得 | E-01（780, 806, 835, 861行目） | ○ |
| C-12 | fetchUsersでユーザー取得 | E-01（891, 917, 945, 971行目） | ○ |
| C-13 | Zend_Mailでメール作成・送信 | E-01（784, 811行目等） | ○ |
| C-14 | BCCで宛先追加 | E-01（792, 819行目等） | ○ |
| C-15 | Toはサイトメールアドレス | E-01（786, 813行目等） | ○ |
| C-16 | 添付ファイル追加処理 | E-01（796-800, 823-827行目等） | ○ |
| C-17 | テキスト/HTML形式別送信 | E-01（778-831行目） | ○ |
| C-18 | 送信済みメールは再送信不可 | E-01（763行目、1116-1124行目） | ○ |
| C-19 | sendtestActionでテストメール送信 | E-02 | ○ |
| C-20 | テストメールは自分宛 | E-02（591, 611行目） | ○ |
| C-21 | 936行目にtypo($htmltmail) | E-01（936行目） | ○ |
| C-22 | 送信後mail_statusを'sent'に更新 | **根拠不足** | △ |

## 4) 不足情報（Unknown / Missing）
- 送信後のステータス更新処理（C-22）
  - 候補：sendAction内の別の箇所 / トリガー / 未実装
- BCC上限（SMTPサーバー依存）の考慮

## 5) リスクフラグ（レビュー観点）
- 2: 高リスク - 936行目のtypo（$htmltmail）は実行時エラーの可能性
- 1: 中リスク - 送信後のステータス更新処理の確認
- 1: 中リスク - 大量BCC送信時のSMTPサーバー制限

## 6) レビュアーチェックリスト（最小）
- [ ] 936行目のtypo修正確認（$htmltmail -> $htmlmail）
- [ ] 送信後のmail_status更新処理を確認
- [ ] 大量購読者送信時のBCC上限テスト
- [ ] SMTPサーバー設定の確認
