---
generated_at: 2026-02-11 18:55:00
metrics:
  claims_total: 16
  claims_with_evidence: 16
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：6-記事新規作成.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：16 / 16、根拠なし：0
- 優先レビュー（高）
  1. なし - すべての主張に根拠あり

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `application/modules/admin/controllers/ArticlesController.php`
- E-02: `application/models/Articles.php`
- E-03: `database.sql` (articlesテーブル: 5-20行目)
- E-04: `docs/code-to-docs/機能一覧/機能一覧.csv`
- E-05: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | aarticles + aarticlenew 権限チェック | E-01: 338行目 | ○ |
| C-02 | レイアウト無効化 | E-01: 340行目 | ○ |
| C-03 | タイトルのNotEmptyバリデーション | E-01: 349-353行目 | ○ |
| C-04 | カテゴリのNotEmptyバリデーション | E-01: 354-358行目 | ○ |
| C-05 | Articlesモデルのインスタンス化 | E-01: 365行目 | ○ |
| C-06 | newArticle()の呼び出し | E-01: 367-370行目 | ○ |
| C-07 | 記事タイトルのINSERT | E-02: 226行目 | ○ |
| C-08 | カテゴリIDのINSERT | E-02: 227行目 | ○ |
| C-09 | 著者IDのINSERT | E-02: 228行目 | ○ |
| C-10 | article_dateにNOW()設定 | E-02: 229行目 | ○ |
| C-11 | article_editにNOW()設定 | E-02: 230行目 | ○ |
| C-12 | デフォルトでdraft状態 | E-03: 18行目 `DEFAULT 'draft'` | ○ |
| C-13 | lastInsertId()で新規IDを取得 | E-01: 376行目 | ○ |
| C-14 | 編集画面へのリダイレクト | E-01: 376行目 | ○ |
| C-15 | 権限エラー時のフォワード | E-01: 399行目 | ○ |
| C-16 | 関連画面No.37（記事新規作成画面） | E-05: 77行目 | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 単一INSERT操作で副作用が限定的
- 0: 低リスク - 権限チェックが適切に実装されている

## 6) レビュアーチェックリスト（最小）
- [ ] タイトル入力値のXSSエスケープ処理を確認
- [ ] カテゴリIDの存在チェック（外部キー制約の有無）を確認
