---
generated_at: 2026-02-11 11:15:00
metrics:
  claims_total: 18
  claims_with_evidence: 18
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：60-検索インデックス更新

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：18 / 18、根拠なし：0
- 優先レビュー（高）
  1. **重複実装**：SearchモデルとSearchIndexヘルパーの使い分け確認
  2. **インデックスパス**：registry設定のsyspath確認
  3. **公開状態チェック**：下書き保存時のインデックス動作確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `application/models/Search.php` - Luceneインデックス操作クラス（135行）
- E-02: `application/helpers/SearchIndex.php` - アクションヘルパー版（129行）
- E-03: `application/models/Articles.php` - 記事モデル（updateArticle 358-366行目、deleteArticle 270-271行目）
- E-04: `application/models/Pages.php` - ページモデル（updatePage 226-234行目、deletePage 194-195行目）
- E-05: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能No.60の定義
- E-06: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 画面との紐付け情報

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Zend_Search_Luceneで全文検索インデックスを管理 | E-01（63行目）、E-05 | ○ |
| C-02 | コンテンツ保存時にインデックスを更新 | E-03（358行目）、E-04（226行目） | ○ |
| C-03 | コンテンツ削除時にインデックスから削除 | E-03（271行目）、E-04（195行目） | ○ |
| C-04 | updateEntryはdeleteEntry + createEntryで実装 | E-01（116-121行目） | ○ |
| C-05 | keyがNULLの場合は例外スロー | E-01（83-96行目） | ○ |
| C-06 | paramsが配列でない場合は例外スロー | E-01（105-109行目、118-123行目） | ○ |
| C-07 | 記事のkeyは'a'+ID形式 | E-03（271, 359行目） | ○ |
| C-08 | ページのkeyは'p'+ID形式 | E-04（195, 227行目） | ○ |
| C-09 | status='published'の場合のみインデックス更新 | E-03（349行目）、E-04（221行目） | ○ |
| C-10 | stubTrimで140文字に切り詰め | E-01（26行目） | ○ |
| C-11 | Keywordフィールドでkey, dateを格納 | E-01（67-68行目） | ○ |
| C-12 | Textフィールドでtitle, details, stub, urlを格納 | E-01（69-72行目） | ○ |
| C-13 | UnStoredフィールドでcontentsを格納（検索のみ） | E-01（73行目） | ○ |
| C-14 | インデックスパスはregistry->search->search->syspath | E-01（63, 85行目） | ○ |
| C-15 | createSiteIndexで新規インデックス作成 | E-01（129-132行目） | ○ |
| C-16 | SearchIndexヘルパーは同様の機能を持つ | E-02（62-126行目） | ○ |
| C-17 | SearchIndexヘルパーは現在使用されていない | Grep検索結果 | ○ |
| C-18 | 記事はdetailsに著者情報を含む | E-03（352-356行目） | ○ |

## 4) 不足情報（Unknown / Missing）
- 該当なし

## 5) リスクフラグ（レビュー観点）
- 1: 中リスク - SearchモデルとSearchIndexヘルパーの重複実装
- 1: 中リスク - インデックス更新失敗時のDB整合性（ロールバックなし）
- 0: 低リスク - 大量コンテンツ一括更新時のパフォーマンス

## 6) レビュアーチェックリスト（最小）
- [ ] registry->search->search->syspathの設定値確認
- [ ] site-indexディレクトリのパーミッション確認
- [ ] 下書き保存時にインデックスが更新されないことを確認
- [ ] SearchIndexヘルパーの削除または統合を検討
