---
generated_at: 2026-02-11 10:30:00
metrics:
  claims_total: 25
  claims_with_evidence: 23
  claims_without_evidence: 2
confidence_derived: 0.92
---

# 根拠レポート：61-アクセス制御

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.92**
  - 根拠あり：23 / 25、根拠なし：2
- 優先レビュー（高）
  1. **パフォーマンス要件**：キャッシュの検討については実装から推測
  2. **トランザクション仕様**：トランザクション未使用の確認が必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `library/CMS/Acl/Factory.php` - ACLファクトリクラス
- E-02: `library/CMS/Controller/Action/Admin.php` - 管理画面基底コントローラー
- E-03: `application/modules/admin/controllers/ArticlesController.php` - 記事コントローラー（権限チェック例）
- E-04: `application/modules/admin/controllers/UsersController.php` - ユーザー・ロール管理コントローラー
- E-05: `application/layouts/admin.phtml` - 管理画面レイアウト
- E-06: `application/modules/admin/views/scripts/articles/manage.phtml` - 記事一覧ビュー
- E-07: `database.sql` - データベーススキーマ
- E-08: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 画面機能マッピング

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Zend_Aclコンポーネントを使用してACLを実現 | E-01 (27行目: `$acl = new Zend_Acl()`) | ○ |
| C-02 | CMS_Acl_Factoryクラスでグローバルとリソース別ACLを生成 | E-01 (15-36行目, 42-82行目) | ○ |
| C-03 | users_rolesテーブルからロール情報を取得 | E-01 (56-64行目), E-07 (576-581行目) | ○ |
| C-04 | users_resourcesテーブルからリソース情報を取得 | E-01 (47-51行目), E-07 (483-491行目) | ○ |
| C-05 | users_privilegesテーブルから権限マッピングを取得 | E-01 (71-79行目), E-07 (367-372行目) | ○ |
| C-06 | preDispatch()でACLが初期化される | E-02 (17-60行目) | ○ |
| C-07 | 認証済みユーザーに対してACLオブジェクトをビューに渡す | E-02 (52-53行目: `$view->acl = $factory->createGlobalAcl()`) | ○ |
| C-08 | gadmin権限がないとerror/privilegesへフォワード | E-02 (54-56行目) | ○ |
| C-09 | 各アクションでisAllowed()を呼び出して権限チェック | E-03 (32行目, 57行目, 80行目など) | ○ |
| C-10 | 権限がない場合はerror/privilegesへフォワード | E-03 (47行目, 70行目, 114行目) | ○ |
| C-11 | ビューでhasRole()とisAllowed()を使用してメニュー表示制御 | E-05 (63-69行目) | ○ |
| C-12 | ビューでボタン表示を権限に基づいて制御 | E-06 (41-42行目, 71-74行目, 128行目) | ○ |
| C-13 | ロールID=3(Administrator)が特権ロール | E-07 (378-450行目のINSERT文: prv_role=3) | ○ |
| C-14 | ロール保存時に既存権限を削除して再登録 | E-04 (840行目, 846-857行目) | ○ |
| C-15 | ロール新規作成時に継承元ロールの権限をコピー可能 | E-04 (952-973行目) | ○ |
| C-16 | ロール削除時に関連権限も削除 | E-04 (1061-1064行目) | ○ |
| C-17 | ロール削除時にユーザーを移動先ロールに変更 | E-04 (1041-1058行目) | ○ |
| C-18 | 関連画面一覧が画面機能マッピングと整合 | E-08 (画面No 29, 30, 31, 32, 35, 39等) | ○ |
| C-19 | 入力パラメータとしてuser_roleとresourceを使用 | E-03 (32行目: `$this->view->user->user_role, 'aarticles'`) | ○ |
| C-20 | スーパー管理者(role_id=3)編集時は権限削除をスキップ | E-04 (837行目: `if($this->view->role != 3)`) | ○ |
| C-21 | UPrvFormヘルパーでロール編集フォーム生成 | E-08から参照、ファイル存在確認済み | ○ |
| C-22 | Zend_Filter_Inputでロール名・色のバリデーション | E-04 (804-818行目, 919-933行目) | ○ |
| C-23 | ロール削除時のユーザー移動先はフォーム必須入力 | E-04 (1027-1031行目) | ○ |
| C-24 | パフォーマンス要件：大規模運用時はキャッシュ検討が必要 | **根拠なし** | △ |
| C-25 | トランザクション仕様：明示的なトランザクション制御なし | **根拠なし**（コードに`beginTransaction`等がないことから推測） | △ |

## 4) 不足情報（Unknown / Missing）
- パフォーマンス要件のキャッシュについては、コードからの推測であり、要件定義書や設計指針がない
  - 候補：プロジェクト要件定義書 / 性能設計書 / 運用マニュアル
- トランザクション仕様は、コードに明示的な制御がないことからの推測
  - 候補：データベース設計書 / コーディング規約

## 5) リスクフラグ（レビュー観点）
- **1: 中リスク** - ロール保存時のDELETE/INSERTがトランザクションで囲まれていないため、途中でエラーが発生した場合にデータ不整合の可能性あり
- **0: 低リスク** - ACL生成のパフォーマンスは現状の規模では問題ないが、将来的な拡張時に検討が必要

## 6) レビュアーチェックリスト（最小）
- [ ] CMS_Acl_Factory::createGlobalAcl()の実装が設計書の記述と一致するか確認
- [ ] 権限チェックパターン（モジュール権限 & 操作権限）が全コントローラーで一貫しているか確認
- [ ] users_privilegesテーブルの初期データ（スーパー管理者権限）が適切か確認
- [ ] ロール保存・削除時のデータ整合性について運用観点でリスク許容可能か確認
