---
generated_at: 2026-02-11 19:10:00
metrics:
  claims_total: 20
  claims_with_evidence: 20
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：9-記事公開非公開.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：20 / 20、根拠なし：0
- 優先レビュー（高）
  1. なし - すべての主張に根拠あり

## 2) 参照した情報（Evidence一覧）

- E-01: `application/modules/admin/controllers/ArticlesController.php`
- E-02: `application/models/Articles.php`
- E-03: `application/models/Search.php`
- E-04: `database.sql`
- E-05: `docs/code-to-docs/機能一覧/機能一覧.csv`
- E-06: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | aarticles + aarticlepublish 権限チェック | E-01: 219行目 | ○ |
| C-02 | レイアウトとビューの無効化 | E-01: 221-222行目 | ○ |
| C-03 | confirmパラメータによる確認ダイアログ制御 | E-01: 227行目, 292-300行目 | ○ |
| C-04 | タイトルのNotEmptyバリデーション | E-01: 234-238行目 | ○ |
| C-05 | カテゴリのNotEmptyバリデーション | E-01: 239-243行目 | ○ |
| C-06 | ティーザーのNotEmptyバリデーション | E-01: 244-248行目 | ○ |
| C-07 | updateArticleStatus()の呼び出し | E-01: 259-260行目 | ○ |
| C-08 | status='published'の設定 | E-01: 261行目, E-02: 378行目 | ○ |
| C-09 | updateArticle()の呼び出し | E-01: 262-270行目 | ○ |
| C-10 | article_publishedにNOW()設定 | E-02: 379行目 | ○ |
| C-11 | 検索インデックスの自動更新 | E-02: 349-366行目 | ○ |
| C-12 | 権限エラー時のフォワード | E-01: 306行目 | ○ |
| C-13 | バリデーションエラー時のメッセージ表示 | E-01: 281-288行目 | ○ |
| C-14 | 完了画面のHTML出力 | E-01: 272-277行目 | ○ |
| C-15 | 確認ダイアログのHTML出力 | E-01: 294-300行目 | ○ |
| C-16 | article_statusのデフォルト値'draft' | E-04: 18行目 | ○ |
| C-17 | article_publishedのNULL許可 | E-04: 17行目 | ○ |
| C-18 | ステータス更新と記事更新が別UPDATE | E-02: 375-383行目, 314-369行目 | ○ |
| C-19 | 関連画面No.36（記事編集画面） | E-06: 74行目 | ○ |
| C-20 | Dojo Toolkitボタンコンポーネント | E-01: 275行目, 298-299行目 | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし

## 5) リスクフラグ（レビュー観点）
- 1: 中リスク - ステータス更新と記事更新が別トランザクション（整合性リスク）
- 0: 低リスク - 権限チェックと確認ダイアログが適切に実装

## 6) レビュアーチェックリスト（最小）
- [ ] トランザクション制御の追加を検討
- [ ] 非公開（下書きに戻す）機能の必要性を確認
- [ ] 予約公開機能の必要性を確認
