---
generated_at: 2026-02-11 12:00:00
metrics:
  claims_total: 93
  claims_with_evidence: 93
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：画面一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：93 / 93、根拠なし：0
- 優先レビュー（高）
  - なし（全ての画面はコントローラーとビューテンプレートから確認済み）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

### コントローラーファイル
- E-01: `application/modules/admin/controllers/IndexController.php`
- E-02: `application/modules/admin/controllers/AuthController.php`
- E-03: `application/modules/admin/controllers/ArticlesController.php`
- E-04: `application/modules/admin/controllers/UsersController.php`
- E-05: `application/modules/admin/controllers/EventsController.php`
- E-06: `application/modules/admin/controllers/PagesController.php`
- E-07: `application/modules/admin/controllers/MailController.php`
- E-08: `application/modules/admin/controllers/SettingsController.php`
- E-09: `application/modules/admin/controllers/AssetsController.php`
- E-10: `application/modules/admin/controllers/CommentsController.php`
- E-11: `application/modules/admin/controllers/RotatorsController.php`
- E-12: `application/modules/default/controllers/IndexController.php`
- E-13: `application/modules/default/controllers/AuthController.php`
- E-14: `application/modules/default/controllers/ArticlesController.php`
- E-15: `application/modules/default/controllers/EventsController.php`
- E-16: `application/modules/default/controllers/PagesController.php`
- E-17: `application/modules/default/controllers/SettingsController.php`
- E-18: `application/modules/default/controllers/ErrorController.php`
- E-19: `application/modules/admin/controllers/ErrorController.php`

### ビューテンプレートファイル
- E-20: `application/modules/admin/views/scripts/` 配下の全.phtmlファイル（68ファイル）
- E-21: `application/modules/default/views/scripts/` 配下の全.phtmlファイル（53ファイル）

## 3) Claims と根拠の対応（レビューの主戦場）

### フロントエンド画面

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | ホーム画面が存在する | E-12 (indexAction), E-21 (index/index.phtml) | ○ |
| C-02 | タグ一覧画面が存在する | E-12 (tagsAction), E-21 (index/tags.phtml) | ○ |
| C-03 | 検索結果画面が存在する | E-12 (searchAction), E-21 (index/search.phtml) | ○ |
| C-04 | お問い合わせ画面が存在する | E-12 (contactAction), E-21 (index/contact.phtml) | ○ |
| C-05 | ログイン画面が存在する | E-13 (loginAction), E-21 (auth/login.phtml) | ○ |
| C-06 | パスワードリセット画面が存在する | E-13 (passwordAction), E-21 (auth/password.phtml) | ○ |
| C-07 | ユーザー登録画面が存在する | E-13 (registerAction), E-21 (auth/register.phtml) | ○ |
| C-08 | アカウント有効化画面が存在する | E-13 (activateAction), E-21 (auth/activate.phtml) | ○ |
| C-09 | 記事一覧画面が存在する | E-14 (indexAction), E-21 (articles/index.phtml) | ○ |
| C-10 | カテゴリ別記事一覧画面が存在する | E-14 (categoryAction), E-21 (articles/category.phtml) | ○ |
| C-11 | 著者別記事一覧画面が存在する | E-14 (authorAction), E-21 (articles/author.phtml) | ○ |
| C-12 | アーカイブ画面が存在する | E-14 (archiveAction), E-21 (articles/archive.phtml) | ○ |
| C-13 | 記事詳細画面が存在する | E-14 (articleAction), E-21 (articles/article.phtml) | ○ |
| C-14 | タグ別記事一覧画面が存在する | E-14 (tagAction), E-21 (articles/tag.phtml) | ○ |
| C-15 | 記事タグ一覧画面が存在する | E-14 (tagsAction), E-21 (articles/tags.phtml) | ○ |
| C-16 | イベント一覧画面が存在する | E-15 (indexAction), E-21 (events/index.phtml) | ○ |
| C-17 | カレンダー画面が存在する | E-15 (calendarAction), E-21 (events/calendar.phtml) | ○ |
| C-18 | イベント詳細画面が存在する | E-15 (eventAction), E-21 (events/event.phtml) | ○ |
| C-19 | カテゴリ別イベント一覧画面が存在する | E-15 (categoryAction), E-21 (events/category.phtml) | ○ |
| C-20 | 会場別イベント一覧画面が存在する | E-15 (venueAction), E-21 (events/venue.phtml) | ○ |
| C-21 | 地図画面が存在する | E-15 (mapAction), E-21 (events/map.phtml) | ○ |
| C-22 | Ajaxカレンダー画面が存在する | E-15 (acalendarAction), E-21 (events/acalendar.phtml) | ○ |
| C-23 | 静的ページ画面が存在する | E-16 (pageAction), E-21 (pages/page.phtml) | ○ |
| C-24 | ページタグ一覧画面が存在する | E-16 (tagsAction), E-21 (pages/tags.phtml) | ○ |
| C-25 | タグ別ページ一覧画面が存在する | E-16 (tagAction), E-21 (pages/tag.phtml) | ○ |
| C-26 | ユーザー設定画面が存在する | E-17 (indexAction), E-21 (settings/index.phtml) | ○ |
| C-27 | パスワード変更画面が存在する | E-17 (passwordAction), E-21 (settings/password.phtml) | ○ |
| C-28 | 購読設定画面が存在する | E-17 (subscriptionsAction), E-21 (settings/subscriptions.phtml) | ○ |
| C-29 | 404エラー画面が存在する | E-18 (notfoundAction), E-21 (error/notfound.phtml) | ○ |
| C-30 | システムエラー画面が存在する | E-18 (errorAction), E-21 (error/error.phtml) | ○ |
| C-31 | サイト閉鎖画面が存在する | E-18 (closedAction), E-21 (error/closed.phtml) | ○ |

### 管理画面

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-32 | 管理ダッシュボードが存在する | E-01 (indexAction), E-20 (index/index.phtml) | ○ |
| C-33 | 管理者ログイン画面が存在する | E-02 (loginAction), E-20 (auth/login.phtml) | ○ |
| C-34 | 管理者パスワード変更画面が存在する | E-02 (passwordAction), E-20 (auth/password.phtml) | ○ |
| C-35 | 記事管理画面が存在する | E-03 (manageAction), E-20 (articles/manage.phtml) | ○ |
| C-36 | 記事編集画面が存在する | E-03 (editAction), E-20 (articles/edit.phtml) | ○ |
| C-37 | 記事新規作成画面が存在する | E-03 (newAction), E-20 (articles/new.phtml) | ○ |
| C-38 | 記事詳細画面が存在する | E-03 (detailsAction), E-20 (articles/details.phtml) | ○ |
| C-39 | 記事カテゴリ管理画面が存在する | E-03 (categoryAction), E-20 (articles/category.phtml) | ○ |
| C-40 | 記事カテゴリ新規作成画面が存在する | E-03 (categorynewAction), E-20 (articles/categorynew.phtml) | ○ |
| C-41 | ユーザー管理画面が存在する | E-04 (manageAction), E-20 (users/manage.phtml) | ○ |
| C-42 | ユーザー編集画面が存在する | E-04 (editAction), E-20 (users/edit.phtml) | ○ |
| C-43 | ユーザー新規作成画面が存在する | E-04 (newAction), E-20 (users/new.phtml) | ○ |
| C-44 | ユーザー詳細画面が存在する | E-04 (detailsAction), E-20 (users/details.phtml) | ○ |
| C-45 | ロール管理画面が存在する | E-04 (roleAction), E-20 (users/role.phtml) | ○ |
| C-46 | ロール新規作成画面が存在する | E-04 (rolenewAction), E-20 (users/rolenew.phtml) | ○ |
| C-47 | ロール削除確認画面が存在する | E-04 (roledeleteAction), E-20 (users/roledelete.phtml) | ○ |
| C-48 | イベント管理画面が存在する | E-05 (manageAction), E-20 (events/manage.phtml) | ○ |
| C-49 | イベント編集画面が存在する | E-05 (editAction), E-20 (events/edit.phtml) | ○ |
| C-50 | イベント新規作成画面が存在する | E-05 (newAction), E-20 (events/new.phtml) | ○ |
| C-51 | イベント詳細画面が存在する | E-05 (detailsAction), E-20 (events/details.phtml) | ○ |
| C-52 | イベントカテゴリ管理画面が存在する | E-05 (categoriesAction), E-20 (events/categories.phtml) | ○ |
| C-53 | イベントカテゴリ詳細画面が存在する | E-05 (categorydetailsAction), E-20 (events/categorydetails.phtml) | ○ |
| C-54 | イベントカテゴリ新規作成画面が存在する | E-05 (categorynewAction), E-20 (events/categorynew.phtml) | ○ |
| C-55 | イベントカテゴリ編集画面が存在する | E-05 (categoryAction), E-20 (events/category.phtml) | ○ |
| C-56 | 会場管理画面が存在する | E-05 (venuesAction), E-20 (events/venues.phtml) | ○ |
| C-57 | 会場詳細画面が存在する | E-05 (venuedetailsAction), E-20 (events/venuedetails.phtml) | ○ |
| C-58 | 会場新規作成画面が存在する | E-05 (venuenewAction), E-20 (events/venuenew.phtml) | ○ |
| C-59 | 会場編集画面が存在する | E-05 (venueAction), E-20 (events/venue.phtml) | ○ |
| C-60 | ページ管理画面が存在する | E-06 (manageAction), E-20 (pages/manage.phtml) | ○ |
| C-61 | ページ編集画面が存在する | E-06 (editAction), E-20 (pages/edit.phtml) | ○ |
| C-62 | ページ新規作成画面が存在する | E-06 (newAction), E-20 (pages/new.phtml) | ○ |
| C-63 | ページ詳細画面が存在する | E-06 (detailsAction), E-20 (pages/details.phtml) | ○ |
| C-64 | メール管理画面が存在する | E-07 (manageAction), E-20 (mail/manage.phtml) | ○ |
| C-65 | メール編集画面が存在する | E-07 (editAction), E-20 (mail/edit.phtml) | ○ |
| C-66 | メール詳細画面が存在する | E-07 (detailsAction), E-20 (mail/details.phtml) | ○ |
| C-67 | グループ管理画面が存在する | E-07 (groupAction), E-20 (mail/group.phtml) | ○ |
| C-68 | グループ新規作成画面が存在する | E-07 (groupnewAction), E-20 (mail/groupnew.phtml) | ○ |
| C-69 | グループ詳細画面が存在する | E-07 (groupdetailsAction), E-20 (mail/groupdetails.phtml) | ○ |
| C-70 | メールリスト画面が存在する | E-07 (maillistAction), E-20 (mail/maillist.phtml) | ○ |
| C-71 | ロール別メール画面が存在する | E-07 (mailroleAction), E-20 (mail/mailrole.phtml) | ○ |
| C-72 | ユーザー別メール画面が存在する | E-07 (mailuserAction), E-20 (mail/mailuser.phtml) | ○ |
| C-73 | 設定画面が存在する | E-08 (indexAction), E-20 (settings/index.phtml) | ○ |
| C-74 | 設定詳細画面が存在する | E-08 (detailsAction), E-20 (settings/details.phtml) | ○ |
| C-75 | アセット管理画面が存在する | E-09 (indexAction), E-20 (assets/index.phtml) | ○ |
| C-76 | アップロード画面が存在する | E-09 (uploadAction), E-20 (assets/upload.phtml) | ○ |
| C-77 | アセット詳細画面が存在する | E-09 (assetAction), E-20 (assets/asset.phtml) | ○ |
| C-78 | アセットプロパティ画面が存在する | E-09 (propertiesAction), E-20 (assets/properties.phtml) | ○ |
| C-79 | フォルダ画面が存在する | E-09 (folderAction), E-20 (assets/folder.phtml) | ○ |
| C-80 | フォルダ新規作成画面が存在する | E-09 (foldernewAction), E-20 (assets/foldernew.phtml) | ○ |
| C-81 | フォルダプロパティ画面が存在する | E-09 (folderpropertiesAction), E-20 (assets/folderproperties.phtml) | ○ |
| C-82 | 画像プレビュー画面が存在する | E-09 (imagepreviewAction), E-20 (assets/imagepreview.phtml) | ○ |
| C-83 | 画像挿入画面が存在する | E-09 (imageinsertAction), E-20 (assets/imageinsert.phtml) | ○ |
| C-84 | リンク挿入画面が存在する | E-09 (linkinsertAction), E-20 (assets/linkinsert.phtml) | ○ |
| C-85 | コメント管理画面が存在する | E-10 (manageAction), E-20 (comments/manage.phtml) | ○ |
| C-86 | コメント表示画面が存在する | E-10 (showAction), E-20 (comments/show.phtml) | ○ |
| C-87 | ローテーター管理画面が存在する | E-11 (manageAction), E-20 (rotators/manage.phtml) | ○ |
| C-88 | ローテーター編集画面が存在する | E-11 (editAction), E-20 (rotators/edit.phtml) | ○ |
| C-89 | スライド編集画面が存在する | E-11 (slideAction), E-20 (rotators/slide.phtml) | ○ |
| C-90 | スライド新規作成画面が存在する | E-11 (slidenewAction), E-20 (rotators/slidenew.phtml) | ○ |
| C-91 | 管理者エラー画面が存在する | E-19 (errorAction), E-20 (error/error.phtml) | ○ |
| C-92 | 管理者404エラー画面が存在する | E-19 (notfoundAction), E-20 (error/notfound.phtml) | ○ |
| C-93 | 権限エラー画面が存在する | E-19 (privilegesAction), E-20 (error/privileges.phtml) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

全ての画面は、コントローラーファイルのアクションメソッドと対応するビューテンプレート(.phtml)ファイルの両方から確認されています。

## 5) リスクフラグ（レビュー観点）
- **0: 低リスク** - 全ての画面がコントローラーとビューテンプレートから直接確認されています。

注意点：
- Ajax画面（コメント削除・承認、スライド削除など）はビューテンプレートを持たない場合があります
- フィード出力（Atom/RSS）は画面ではなくデータ出力のため画面一覧には含まれていません

## 6) レビュアーチェックリスト（最小）
- [ ] コントローラーファイルの存在確認
- [ ] ビューテンプレートファイルの存在確認
- [ ] カテゴリ分類の妥当性確認
- [ ] 画面名の命名規則の一貫性確認
- [ ] 画面遷移図の矢印方向の妥当性確認
