# 画面遷移図

## 概要

Legacy CMSの画面遷移図です。システムはフロントエンド（公開サイト）と管理画面（Admin）の2つのモジュールで構成されています。

## フロントエンド画面遷移図

```mermaid
flowchart TB
    subgraph Frontend["フロントエンド（公開サイト）"]
        subgraph Top["トップ"]
            Home["ホーム画面"]
            Tags["タグ一覧画面"]
            Search["検索結果画面"]
            Contact["お問い合わせ画面"]
        end

        subgraph Auth["認証"]
            Login["ログイン画面"]
            Password["パスワードリセット画面"]
            Register["ユーザー登録画面"]
            Activate["アカウント有効化画面"]
        end

        subgraph Articles["記事"]
            ArticleList["記事一覧画面"]
            ArticleCategory["カテゴリ別記事一覧"]
            ArticleAuthor["著者別記事一覧"]
            ArticleArchive["アーカイブ画面"]
            ArticleDetail["記事詳細画面"]
            ArticleTag["タグ別記事一覧"]
            ArticleTags["記事タグ一覧"]
        end

        subgraph Events["イベント"]
            EventList["イベント一覧画面"]
            EventCalendar["カレンダー画面"]
            EventDetail["イベント詳細画面"]
            EventCategory["カテゴリ別イベント"]
            EventVenue["会場別イベント"]
            EventMap["地図画面"]
        end

        subgraph Pages["ページ"]
            StaticPage["静的ページ画面"]
            PageTags["ページタグ一覧"]
            PageTag["タグ別ページ一覧"]
        end

        subgraph Settings["設定"]
            UserSettings["ユーザー設定画面"]
            PasswordChange["パスワード変更画面"]
            Subscriptions["購読設定画面"]
        end

        subgraph Error["エラー"]
            Error404["404エラー画面"]
            ErrorSystem["システムエラー画面"]
            ErrorClosed["サイト閉鎖画面"]
        end
    end

    %% トップからの遷移
    Home --> Search
    Home --> Tags
    Home --> Contact
    Home --> ArticleList
    Home --> EventList
    Home --> Login

    %% 認証フロー
    Login --> Home
    Login --> Password
    Login --> Register
    Register --> Activate
    Activate --> Login
    Password --> Login

    %% 記事遷移
    ArticleList --> ArticleDetail
    ArticleList --> ArticleCategory
    ArticleList --> ArticleAuthor
    ArticleList --> ArticleArchive
    ArticleList --> ArticleTags
    ArticleCategory --> ArticleDetail
    ArticleAuthor --> ArticleDetail
    ArticleArchive --> ArticleDetail
    ArticleTag --> ArticleDetail
    ArticleTags --> ArticleTag
    Tags --> ArticleTag

    %% イベント遷移
    EventList --> EventDetail
    EventList --> EventCalendar
    EventList --> EventCategory
    EventList --> EventVenue
    EventCalendar --> EventDetail
    EventCategory --> EventDetail
    EventVenue --> EventDetail
    EventDetail --> EventMap

    %% ページ遷移
    PageTags --> PageTag
    PageTag --> StaticPage

    %% 設定遷移（要ログイン）
    Login --> UserSettings
    UserSettings --> PasswordChange
    UserSettings --> Subscriptions
```

## 管理画面遷移図

```mermaid
flowchart TB
    subgraph Admin["管理画面"]
        subgraph AdminAuth["認証"]
            AdminLogin["管理者ログイン画面"]
            AdminPassword["管理者パスワード変更"]
        end

        subgraph Dashboard["ダッシュボード"]
            AdminDashboard["管理ダッシュボード"]
        end

        subgraph AdminArticles["記事管理"]
            ArticleManage["記事管理画面"]
            ArticleEdit["記事編集画面"]
            ArticleNew["記事新規作成画面"]
            ArticleDetails["記事詳細画面"]
            CategoryManage["カテゴリ管理画面"]
            CategoryNew["カテゴリ新規作成画面"]
        end

        subgraph AdminUsers["ユーザー管理"]
            UserManage["ユーザー管理画面"]
            UserEdit["ユーザー編集画面"]
            UserNew["ユーザー新規作成画面"]
            UserDetails["ユーザー詳細画面"]
            RoleManage["ロール管理画面"]
            RoleNew["ロール新規作成画面"]
            RoleDelete["ロール削除確認画面"]
        end

        subgraph AdminEvents["イベント管理"]
            EventManage["イベント管理画面"]
            EventEdit["イベント編集画面"]
            EventNew["イベント新規作成画面"]
            EventDetails["イベント詳細画面"]
            EventCategoryManage["カテゴリ管理画面"]
            EventCategoryNew["カテゴリ新規作成画面"]
            EventCategoryEdit["カテゴリ編集画面"]
            VenueManage["会場管理画面"]
            VenueNew["会場新規作成画面"]
            VenueEdit["会場編集画面"]
        end

        subgraph AdminPages["ページ管理"]
            PageManage["ページ管理画面"]
            PageEdit["ページ編集画面"]
            PageNew["ページ新規作成画面"]
            PageDetails["ページ詳細画面"]
        end

        subgraph AdminMail["メール管理"]
            MailManage["メール管理画面"]
            MailEdit["メール編集画面"]
            MailDetails["メール詳細画面"]
            GroupManage["グループ管理画面"]
            GroupNew["グループ新規作成画面"]
            GroupDetails["グループ詳細画面"]
        end

        subgraph AdminSettings["設定"]
            SettingsIndex["設定画面"]
            SettingsDetails["設定詳細画面"]
        end

        subgraph AdminAssets["アセット管理"]
            AssetIndex["アセット管理画面"]
            AssetUpload["アップロード画面"]
            AssetDetail["アセット詳細画面"]
            AssetProperties["プロパティ画面"]
            FolderView["フォルダ画面"]
            FolderNew["フォルダ新規作成画面"]
        end

        subgraph AdminComments["コメント管理"]
            CommentManage["コメント管理画面"]
            CommentShow["コメント表示画面"]
        end

        subgraph AdminRotators["ローテーター管理"]
            RotatorManage["ローテーター管理画面"]
            RotatorEdit["ローテーター編集画面"]
            SlideEdit["スライド編集画面"]
            SlideNew["スライド新規作成画面"]
        end

        subgraph AdminError["エラー"]
            AdminError404["404エラー画面"]
            AdminErrorSystem["システムエラー画面"]
            AdminErrorPrivileges["権限エラー画面"]
        end
    end

    %% 認証フロー
    AdminLogin --> AdminDashboard
    AdminLogin --> AdminPassword

    %% ダッシュボードからの遷移
    AdminDashboard --> ArticleManage
    AdminDashboard --> UserManage
    AdminDashboard --> EventManage
    AdminDashboard --> PageManage
    AdminDashboard --> MailManage
    AdminDashboard --> SettingsIndex
    AdminDashboard --> AssetIndex
    AdminDashboard --> CommentManage
    AdminDashboard --> RotatorManage

    %% 記事管理遷移
    ArticleManage --> ArticleNew
    ArticleManage --> ArticleEdit
    ArticleManage --> ArticleDetails
    ArticleManage --> CategoryManage
    ArticleEdit --> ArticleManage
    ArticleNew --> ArticleManage
    CategoryManage --> CategoryNew

    %% ユーザー管理遷移
    UserManage --> UserNew
    UserManage --> UserEdit
    UserManage --> UserDetails
    UserManage --> RoleManage
    UserEdit --> UserManage
    UserNew --> UserManage
    RoleManage --> RoleNew
    RoleManage --> RoleDelete

    %% イベント管理遷移
    EventManage --> EventNew
    EventManage --> EventEdit
    EventManage --> EventDetails
    EventManage --> EventCategoryManage
    EventManage --> VenueManage
    EventEdit --> EventManage
    EventNew --> EventManage
    EventCategoryManage --> EventCategoryNew
    EventCategoryManage --> EventCategoryEdit
    VenueManage --> VenueNew
    VenueManage --> VenueEdit

    %% ページ管理遷移
    PageManage --> PageNew
    PageManage --> PageEdit
    PageManage --> PageDetails
    PageEdit --> PageManage
    PageNew --> PageManage

    %% メール管理遷移
    MailManage --> MailEdit
    MailManage --> MailDetails
    MailManage --> GroupManage
    GroupManage --> GroupNew
    GroupManage --> GroupDetails

    %% 設定遷移
    SettingsIndex --> SettingsDetails

    %% アセット管理遷移
    AssetIndex --> AssetUpload
    AssetIndex --> FolderView
    AssetIndex --> FolderNew
    FolderView --> AssetDetail
    FolderView --> AssetUpload
    AssetDetail --> AssetProperties

    %% コメント管理遷移
    CommentManage --> CommentShow

    %% ローテーター管理遷移
    RotatorManage --> RotatorEdit
    RotatorEdit --> SlideNew
    RotatorEdit --> SlideEdit
```

## 画面遷移の凡例

| 記号 | 意味 |
|------|------|
| 矢印 (-->) | 画面遷移方向 |
| サブグラフ | 機能グループ |

## 補足事項

1. **認証制御**: 管理画面は全てログイン認証が必要です。フロントエンドの設定画面もログインが必要です。
2. **権限制御**: 管理画面ではACL（アクセス制御リスト）により、ロールに応じて利用可能な機能が制限されます。
3. **Ajax画面**: 一部の画面（コメント削除、承認など）はAjaxダイアログとして表示されます。
4. **フィード出力**: 記事にはAtom/RSSフィード出力機能があります（画面遷移図には含まれていません）。
