---
generated_at: "2026-02-11"
metrics:
  claims_total: 175
  claims_with_evidence: 168
  claims_without_evidence: 7
confidence_derived: "96.0%"
---

# 信頼性レポート: 画面機能マッピング.csv

## 1. サマリー

| 指標 | 値 |
|------|-----|
| 総マッピング数 | 175 |
| 根拠あり | 168 |
| 根拠なし | 7 |
| 信頼度 | 96.0% |

### 概要

本レポートは、`画面機能マッピング.csv`に記載された画面と機能の対応関係について、その根拠となるコード箇所を特定し、信頼性を評価したものです。

93画面 x 64機能の組み合わせから、実際にコード上で確認できる175件のマッピングを抽出しました。そのうち168件はコントローラーやビューテンプレートから明確な根拠を特定でき、7件は推測に基づくマッピングとなっています。

## 2. 根拠一覧

### 2.1 フロント画面のマッピング根拠

| 画面No | 画面名 | 機能No | 機能名 | 根拠ファイル | 根拠行/メソッド |
|--------|--------|--------|--------|--------------|-----------------|
| 1 | ホーム画面 | 5 | 記事一覧表示 | application/modules/default/controllers/IndexController.php | indexAction() - $articles->fetchLatest(5) |
| 2 | タグ一覧画面 | 49 | タグ一覧表示 | application/modules/default/controllers/IndexController.php | tagsAction() |
| 3 | 検索結果画面 | 60 | 検索インデックス更新 | application/modules/default/controllers/IndexController.php | searchAction() - Zend_Search_Lucene使用 |
| 4 | お問い合わせ画面 | 63 | 入力検証 | application/modules/default/controllers/IndexController.php | contactAction() - Zend_Filter_Input使用 |
| 5 | ログイン画面 | 1 | ログイン | application/modules/default/controllers/AuthController.php | loginAction() - Zend_Auth使用 |
| 6 | パスワードリセット画面 | 3 | パスワードリセット | application/modules/default/controllers/AuthController.php | passwordAction() |
| 7 | ユーザー登録画面 | 17 | ユーザー新規作成 | application/modules/default/controllers/AuthController.php | registerAction() |
| 9 | 記事一覧画面 | 5 | 記事一覧表示 | application/modules/default/controllers/ArticlesController.php | indexAction() |
| 10 | カテゴリ別記事一覧画面 | 5 | 記事一覧表示 | application/modules/default/controllers/ArticlesController.php | categoryAction() |
| 13 | 記事詳細画面 | 5 | 記事一覧表示 | application/modules/default/controllers/ArticlesController.php | articleAction() |
| 13 | 記事詳細画面 | 44 | コメント一覧表示 | application/modules/default/controllers/ArticlesController.php | articleAction() - コメント取得処理 |
| 16 | イベント一覧画面 | 21 | イベント一覧表示 | application/modules/default/controllers/EventsController.php | indexAction() |
| 17 | カレンダー画面 | 21 | イベント一覧表示 | application/modules/default/controllers/EventsController.php | calendarAction() |
| 23 | 静的ページ画面 | 11 | ページ一覧表示 | application/modules/default/controllers/PagesController.php | pageAction() |
| 26 | ユーザー設定画面 | 20 | プロフィール表示 | application/modules/default/controllers/SettingsController.php | indexAction() |
| 27 | パスワード変更画面 | 4 | パスワード変更 | application/modules/default/controllers/SettingsController.php | passwordAction() |

### 2.2 管理画面のマッピング根拠

| 画面No | 画面名 | 機能No | 機能名 | 根拠ファイル | 根拠行/メソッド |
|--------|--------|--------|--------|--------------|-----------------|
| 32 | 管理ダッシュボード | 61 | アクセス制御 | application/modules/admin/controllers/IndexController.php | preDispatch() - ACLチェック |
| 33 | 管理者ログイン画面 | 1 | ログイン | application/modules/admin/controllers/AuthController.php | loginAction() |
| 35 | 記事管理画面 | 5 | 記事一覧表示 | application/modules/admin/controllers/ArticlesController.php | manageAction() |
| 36 | 記事編集画面 | 7 | 記事編集 | application/modules/admin/controllers/ArticlesController.php | editAction() |
| 37 | 記事新規作成画面 | 6 | 記事新規作成 | application/modules/admin/controllers/ArticlesController.php | newAction() |
| 39 | 記事カテゴリ管理画面 | 10 | 記事カテゴリ管理 | application/modules/admin/controllers/ArticlesController.php | categoryAction() |
| 41 | ユーザー管理画面 | 16 | ユーザー一覧表示 | application/modules/admin/controllers/UsersController.php | manageAction() |
| 42 | ユーザー編集画面 | 18 | ユーザー編集 | application/modules/admin/controllers/UsersController.php | editAction() |
| 43 | ユーザー新規作成画面 | 17 | ユーザー新規作成 | application/modules/admin/controllers/UsersController.php | newAction() |
| 45 | ロール管理画面 | 61 | アクセス制御 | application/modules/admin/controllers/UsersController.php | roleAction() |
| 48 | イベント管理画面 | 21 | イベント一覧表示 | application/modules/admin/controllers/EventsController.php | manageAction() |
| 49 | イベント編集画面 | 23 | イベント編集 | application/modules/admin/controllers/EventsController.php | editAction() |
| 50 | イベント新規作成画面 | 22 | イベント新規作成 | application/modules/admin/controllers/EventsController.php | newAction() |
| 52 | イベントカテゴリ管理画面 | 26 | イベントカテゴリ管理 | application/modules/admin/controllers/EventsController.php | categoriesAction() |
| 56 | 会場管理画面 | 61 | アクセス制御 | application/modules/admin/controllers/EventsController.php | venuesAction() |
| 60 | ページ管理画面 | 11 | ページ一覧表示 | application/modules/admin/controllers/PagesController.php | manageAction() |
| 61 | ページ編集画面 | 13 | ページ編集 | application/modules/admin/controllers/PagesController.php | editAction() |
| 62 | ページ新規作成画面 | 12 | ページ新規作成 | application/modules/admin/controllers/PagesController.php | newAction() |
| 64 | メール管理画面 | 58 | メール一覧表示 | application/modules/admin/controllers/MailController.php | manageAction() |
| 65 | メール編集画面 | 59 | メール送信 | application/modules/admin/controllers/MailController.php | editAction() |
| 75 | アセット管理画面 | 27 | アセット一覧表示 | application/modules/admin/controllers/AssetsController.php | indexAction() |
| 76 | アップロード画面 | 28 | アセットアップロード | application/modules/admin/controllers/AssetsController.php | uploadAction() |
| 78 | アセットプロパティ画面 | 29 | アセット編集 | application/modules/admin/controllers/AssetsController.php | propertiesAction() |
| 85 | コメント管理画面 | 44 | コメント一覧表示 | application/modules/admin/controllers/CommentsController.php | manageAction() |
| 86 | コメント表示画面 | 45 | コメント表示 | application/modules/admin/controllers/CommentsController.php | showAction() |
| 87 | ローテーター管理画面 | 39 | ローテーター一覧表示 | application/modules/admin/controllers/RotatorsController.php | manageAction() |
| 88 | ローテーター編集画面 | 40 | ローテーター編集 | application/modules/admin/controllers/RotatorsController.php | editAction() |
| 89 | スライド編集画面 | 42 | スライド編集 | application/modules/admin/controllers/RotatorsController.php | slideAction() |
| 90 | スライド新規作成画面 | 41 | スライド新規作成 | application/modules/admin/controllers/RotatorsController.php | slidenewAction() |

### 2.3 共通機能のマッピング根拠

| 機能No | 機能名 | 使用箇所 | 根拠 |
|--------|--------|----------|------|
| 61 | アクセス制御 | 全管理画面 | application/modules/admin/controllers/IndexController.php - preDispatch()でACLチェック |
| 62 | ページネーション | 一覧画面全般 | Zend_Paginator使用（各コントローラーのfetchPaginator呼び出し） |
| 63 | 入力検証 | フォーム画面全般 | Zend_Filter_Input使用（各コントローラーのバリデーション処理） |
| 64 | Ajaxダイアログ | 編集画面全般 | Dojo Toolkit使用（アセット選択ダイアログ等） |
| 60 | 検索インデックス更新 | コンテンツ保存処理 | Application_Model_Article::save()等でLuceneインデックス更新 |

## 3. 主張と根拠のマッピング

### 3.1 高信頼度のマッピング（コード上で明確に確認可能）

- **認証機能（機能No.1-4）**: AuthControllerの各アクションで明確に実装
- **記事管理機能（機能No.5-10）**: ArticlesControllerの各アクションで明確に実装
- **ユーザー管理機能（機能No.16-20）**: UsersControllerの各アクションで明確に実装
- **イベント管理機能（機能No.21-26）**: EventsControllerの各アクションで明確に実装
- **ページ管理機能（機能No.11-15）**: PagesControllerの各アクションで明確に実装
- **アセット管理機能（機能No.27-31）**: AssetsControllerの各アクションで明確に実装
- **コメント管理機能（機能No.44-48）**: CommentsControllerの各アクションで明確に実装
- **ローテーター管理機能（機能No.39-43）**: RotatorsControllerの各アクションで明確に実装

### 3.2 中信頼度のマッピング（コード上で間接的に確認可能）

- **タグ管理機能（機能No.49-53）**: 各コンテンツタイプのコントローラー内でタグ関連処理として実装
- **添付ファイル管理機能（機能No.54-57）**: 各コンテンツタイプの詳細画面で添付ファイル表示処理として実装
- **メール管理機能（機能No.58-59）**: MailControllerおよびシステム通知処理で実装

### 3.3 低信頼度のマッピング（推測に基づく）

- **会場管理関連（画面No.56-59）**: EventsController内で会場管理として実装されているが、機能一覧に会場専用機能がないため、イベント一覧表示機能（No.21）および入力検証機能（No.63）にマッピング
- **グループ管理関連（画面No.67-69）**: MailController内で実装されているが、機能一覧にグループ専用機能がないため、メール送信機能（No.59）にマッピング

## 4. 情報不足箇所

### 4.1 機能一覧に存在しない機能

以下の機能はコード上で確認できるが、機能一覧.csvに記載がないため、関連する既存機能にマッピングしました：

| 未定義機能 | マッピング先 | 理由 |
|-----------|-------------|------|
| 会場管理（作成・編集・削除） | イベント一覧表示（No.21） | イベント管理の一部として扱う |
| メールグループ管理 | メール送信（No.59） | メール管理の一部として扱う |
| フォルダ管理（作成・編集） | アセット一覧表示（No.27） | アセット管理の一部として扱う |
| ロール管理（作成・編集・削除） | アクセス制御（No.61） | アクセス制御の一部として扱う |

### 4.2 画面一覧に存在しない画面

以下の機能に対応する専用画面が画面一覧.csvに存在しません：

| 機能No | 機能名 | 備考 |
|--------|--------|------|
| 32 | リソース一覧表示 | コントローラー/ビューが存在しない（未実装機能の可能性） |
| 33 | リソース新規作成 | 同上 |
| 34 | リソース編集 | 同上 |
| 35 | リソース削除 | 同上 |
| 36 | リソース公開/非公開 | 同上 |
| 37 | リソースカテゴリ管理 | 同上 |
| 38 | リソースブランド管理 | 同上 |

## 5. リスクフラグ

### 5.1 高リスク

| 項目 | 説明 | 推奨対応 |
|------|------|----------|
| リソース管理機能の未実装 | 機能一覧にあるリソース管理（機能No.32-38）に対応するコントローラー/ビューが存在しない | 機能一覧の見直し、または実装状況の確認 |

### 5.2 中リスク

| 項目 | 説明 | 推奨対応 |
|------|------|----------|
| 会場管理の独立機能化 | 会場管理が多くの画面で使用されているが、独立した機能として定義されていない | 機能一覧への会場管理機能の追加を検討 |
| メールグループ管理の独立機能化 | メールグループ管理が複数画面で使用されているが、独立した機能として定義されていない | 機能一覧へのグループ管理機能の追加を検討 |

### 5.3 低リスク

| 項目 | 説明 | 推奨対応 |
|------|------|----------|
| コメントタブ表示（No.48）の使用箇所不明 | 機能として定義されているが、具体的な使用画面が特定できない | JavaScriptでの動的実装の可能性を確認 |
| タグタブ表示（No.53）の使用箇所不明 | 同上 | 同上 |
| 添付ファイルタブ表示（No.57）の使用箇所不明 | 同上 | 同上 |

## 6. レビュアー向けチェックリスト

### 必須確認項目

- [ ] 主要画面（記事・イベント・ページ管理）のマッピングが正確か
- [ ] 認証関連の機能マッピングが正確か
- [ ] アクセス制御（ACL）が管理画面で適切にマッピングされているか
- [ ] 共通機能（ページネーション・入力検証・Ajaxダイアログ）のマッピングが妥当か

### 推奨確認項目

- [ ] リソース管理機能の実装状況を確認
- [ ] 会場管理を独立した機能として定義すべきか検討
- [ ] メールグループ管理を独立した機能として定義すべきか検討
- [ ] タブ表示系機能（No.48, 53, 57）の実装箇所を特定

### 補足事項

- 本マッピングはZend Framework 1.xのMVC構造に基づいて分析しています
- コントローラーのアクションメソッドと画面の対応関係を主な根拠としています
- ビューテンプレートでの処理は補助的な根拠として使用しています
- Ajax処理やJavaScriptでの動的処理は一部特定困難な箇所があります
