# 画面設計書 1-ホーム画面

## 概要

本ドキュメントは、Legacy CMSのフロントエンド公開サイトにおけるホーム画面の設計仕様を定義する。サイトのランディングページとして機能し、最新コンテンツへのアクセスポイントを提供する。

### 本画面の処理概要

**業務上の目的・背景**：ホーム画面は、サイト訪問者が最初にアクセスするランディングページとして機能する。サイトの概要を把握し、最新の記事コンテンツにすぐにアクセスできるようにすることで、ユーザーエンゲージメントを高め、サイト内の回遊を促進することを目的としている。CMSとして最新情報を効率的に発信し、ユーザーに価値あるコンテンツを提供するという業務課題を解決する。

**画面へのアクセス方法**：サイトのルートURL（/）にアクセスすることで表示される。また、サイト内の各ページからロゴやホームリンクをクリックしてアクセスすることも可能。

**主要な操作・処理内容**：
1. 最新記事5件の一覧表示（公開済み記事のみ、sticky記事優先、公開日時降順）
2. 画像ローテーター（HomePage）によるビジュアルコンテンツの表示
3. サイドバーの検索ボックスからの全文検索実行
4. 次回開催イベント3件の表示
5. ユーザー登録/ログイン案内の表示（認証状態に応じた切り替え）
6. タグボックスによる関連コンテンツへのナビゲーション

**画面遷移**：
- 遷移元：サイト内の全ページ（グローバルナビゲーション経由）、外部からの直接アクセス
- 遷移先：記事詳細画面、記事一覧画面、イベント一覧画面、検索結果画面、タグ一覧画面、ログイン画面、お問い合わせ画面

**権限による表示制御**：
- 未認証ユーザー：登録促進ボックス（registerbox）を表示
- 認証済みユーザー：ユーザー専用のウェルカムメッセージまたは設定リンクを表示

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 5 | 記事一覧表示 | 主機能 | 最新記事5件を取得して表示 |
| 62 | ページネーション | 補助機能 | 記事一覧のページ送り処理（本画面では使用しない） |

## 画面種別

一覧（ダッシュボード型トップページ）

## URL/ルーティング

- URL: `/` または `/index/index`
- コントローラー: `IndexController`
- アクション: `indexAction`
- モジュール: `default`

## 入出力項目

| 項目名 | 入力/出力 | データ型 | 必須 | 説明 |
|--------|----------|---------|------|------|
| articlesArray | 出力 | Array | - | 最新記事5件の配列 |
| authenticated | 出力 | Boolean | - | ユーザー認証状態 |
| video | 出力 | Array | - | YouTube動画情報（yt_key） |

## 表示項目

### 記事一覧（articlesArray）

| 項目名 | データ型 | 表示形式 | 説明 |
|--------|---------|---------|------|
| article_id | int | 非表示（リンク用） | 記事ID |
| article_title | string | テキスト | 記事タイトル |
| article_intro | text | HTML | 記事導入文 |
| article_content | text | リンク判定用 | 「Read More」リンクの表示判定 |
| article_comments | char(1) | リンク判定用 | コメントリンクの表示判定（Y/N） |
| article_published | datetime | 日付形式 | 公開日時 |
| user_alias | string | テキスト | 著者名（設定による表示制御） |
| acat_title | string | テキスト | カテゴリ名 |

### サイドバー

| 項目名 | 説明 |
|--------|------|
| 検索ボックス | サイト内検索フォーム |
| 登録/ログインボックス | 認証状態に応じた案内表示 |
| 次回イベント一覧 | 直近3件のイベント表示 |
| タグボックス | タグクラウド表示 |

## イベント仕様

### 1-記事タイトルクリック

記事タイトルをクリックすると、該当記事の詳細画面へ遷移する。

- 遷移先: `/articles/article/{article_id}/{article_title}/`
- 処理: リンククリックによるページ遷移

### 2-Read Moreクリック

「Read More」リンクをクリックすると、記事詳細画面の続き部分へ遷移する。

- 遷移先: `/articles/article/{article_id}/{article_title}/#more`
- 条件: article_contentがNULLでない場合のみ表示

### 3-Commentクリック

「Comment」リンクをクリックすると、記事詳細画面のコメントセクションへ遷移する。

- 遷移先: `/articles/article/{article_id}/{article_title}/#comment`
- 条件: article_commentsが'Y'の場合のみ表示

### 4-著者名クリック

著者名をクリックすると、該当著者の記事一覧画面へ遷移する。

- 遷移先: `/articles/author/{user_alias}/`
- 条件: articles.iniのshowauthorがtrueの場合のみ表示

### 5-カテゴリ名クリック

カテゴリ名をクリックすると、該当カテゴリの記事一覧画面へ遷移する。

- 遷移先: `/articles/category/{acat_title}/`

### 6-検索実行

検索ボックスにキーワードを入力して検索ボタンを押すと、検索結果画面へ遷移する。

- 遷移先: `/index/search?query={keyword}`

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 画面表示 | articles | SELECT | 最新記事5件を取得 |
| 画面表示 | articles_categories | SELECT | 記事カテゴリ情報を結合取得 |
| 画面表示 | users | SELECT | 著者情報を結合取得 |

### テーブル別更新項目詳細

#### articles

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | article_id, article_title, article_intro, article_content, article_comments, article_published, article_sticky | article_status = 'published' | 公開済み記事のみ |

取得クエリ条件:
- `article_status = 'published'`: 公開済み記事のみ
- `ORDER BY article_sticky DESC, article_published DESC`: sticky記事優先、公開日降順
- `LIMIT 5, 0`: 最大5件

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示条件 |
|-------------|------|---------------|---------|
| MSG-001 | 情報 | No articles have been posted yet | 記事が0件の場合 |

## 例外処理

| 例外条件 | 処理内容 |
|---------|---------|
| データベース接続エラー | システムエラー画面へ遷移 |
| サイトステータスがclosed | サイト閉鎖画面へ遷移 |

## 備考

- Atom/RSSフィードへのリンクがheadタグ内に自動生成される
- Dojoツールキットを使用したUIコンポーネント（RotatorContainer等）が使用されている
- 画像ローテーターは「HomePage」という名前で設定されている

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、画面で表示されるデータの構造を理解することが重要である。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | database.sql | `database.sql` | articlesテーブル（5-20行目）の構造を確認。article_id, article_title, article_intro等のカラム定義 |
| 1-2 | database.sql | `database.sql` | articles_categoriesテーブル（26-30行目）とのリレーション |
| 1-3 | database.sql | `database.sql` | usersテーブル（347-361行目）との著者情報リレーション |

**読解のコツ**: Zend Frameworkでは$registry->db->select()でクエリビルダーを使用する。join句でテーブル間の関係を追跡すること。

#### Step 2: エントリーポイントを理解する

処理の起点となるコントローラーアクションを特定する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | IndexController.php | `application/modules/default/controllers/IndexController.php` | indexAction()メソッド（30-50行目）が処理の起点 |

**主要処理フロー**:
1. **32行目**: setRefer()でセッションに現在のURLを保存（ログイン後のリダイレクト用）
2. **34行目**: リクエストパラメータをビューに渡す
3. **37-45行目**: データベースからarticles, articles_categories, usersを結合して取得
4. **48行目**: 取得結果をビュー変数articlesArrayに設定

#### Step 3: ベースコントローラーの処理を理解する

コントローラーの継承元で行われる前処理を確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | Default.php | `library/CMS/Controller/Action/Default.php` | preDispatch()（17-52行目）で認証チェック、ACL構築を実行 |

**主要処理フロー**:
- **26-29行目**: サイトステータスがclosedの場合、閉鎖画面へ転送
- **35-47行目**: 認証状態に応じてユーザー情報とACLをビューに設定

#### Step 4: ビューテンプレートを理解する

画面表示のロジックを追跡する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | index.phtml | `application/modules/default/views/scripts/index/index.phtml` | メインテンプレート。ローテーター、記事一覧、サイドバーの配置 |
| 4-2 | articlelist.phtml | `application/modules/default/views/scripts/_partials/articlelist.phtml` | 記事一覧の個別表示テンプレート |

**主要処理フロー**:
- **34行目**: RenderRotatorヘルパーでHomePageローテーターを表示
- **38-46行目**: articlesArrayの件数に応じて記事一覧またはメッセージを表示
- **40行目**: partialLoopで記事を繰り返し表示

### プログラム呼び出し階層図

```
HTTP Request (/)
    |
    +-- IndexController::preDispatch() [継承元: CMS_Controller_Action_Default]
    |       |
    |       +-- サイトステータス確認
    |       +-- 認証状態確認
    |       +-- ACL構築 (CMS_Acl_Factory)
    |
    +-- IndexController::indexAction()
            |
            +-- setRefer() - セッション保存
            +-- $registry->db->select() - SQLクエリ構築
            |       |
            |       +-- FROM articles
            |       +-- JOIN articles_categories
            |       +-- JOIN users
            |       +-- WHERE article_status = 'published'
            |       +-- ORDER BY sticky DESC, published DESC
            |       +-- LIMIT 5
            |
            +-- $registry->db->fetchall() - データ取得
            +-- ビュー変数設定 (articlesArray)
```

### データフロー図

```
[入力]               [処理]                    [出力]

HTTPリクエスト  ───▶ IndexController      ───▶ index.phtml
     (/)              ::indexAction()           |
                           |                    +──▶ articlelist.phtml
                           |                    |     (partialLoop)
                      SQL SELECT            +──▶ searchbox.phtml
                           |                    +──▶ registerbox.phtml
                           ▼                    +──▶ RenderRotator
                      articles                       (HomePage)
                      articles_categories
                      users
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| IndexController.php | `application/modules/default/controllers/IndexController.php` | ソース | ホーム画面のコントローラー |
| Default.php | `library/CMS/Controller/Action/Default.php` | ソース | フロントエンド共通ベースコントローラー |
| index.phtml | `application/modules/default/views/scripts/index/index.phtml` | テンプレート | ホーム画面のメインビュー |
| articlelist.phtml | `application/modules/default/views/scripts/_partials/articlelist.phtml` | テンプレート | 記事一覧の部分テンプレート |
| searchbox.phtml | `application/modules/default/views/scripts/_partials/searchbox.phtml` | テンプレート | 検索ボックス |
| registerbox.phtml | `application/modules/default/views/scripts/_partials/registerbox.phtml` | テンプレート | 登録案内ボックス |
| articles.ini | `application/configs/articles.ini` | 設定 | 記事表示設定（showauthor等） |
| database.sql | `database.sql` | スキーマ | データベース構造定義 |
