# 画面設計書 10-カテゴリ別記事一覧画面

## 概要

本ドキュメントは、Legacy CMSのフロントエンド公開サイトにおけるカテゴリ別記事一覧画面の設計仕様を定義する。指定されたカテゴリに属する公開済み記事をページネーション付きで一覧表示する。

### 本画面の処理概要

**業務上の目的・背景**：カテゴリ別記事一覧画面は、特定のカテゴリに分類された記事のみを絞り込んで表示する機能を提供する。ユーザーが興味のある分野の記事を効率的に探索でき、コンテンツのナビゲーション性を向上させる。記事のカテゴリ分類による情報整理という業務課題を解決する。

**画面へのアクセス方法**：記事一覧画面や記事詳細画面のカテゴリ名リンクからアクセス。URLは`/articles/category/{category_name}/`。

**主要な操作・処理内容**：
1. URLパラメータからカテゴリ名を取得
2. 該当カテゴリの公開済み記事を取得（公開日時が現在以前、status='published'）
3. sticky記事優先、公開日時降順でのソート
4. ページネーション表示（設定件数/ページ、ページ範囲5）
5. 各記事のタイトル、著者、公開日、導入文、カテゴリ、タグの表示
6. 記事詳細画面への遷移
7. Atom/RSSフィードへのリンク提供

**画面遷移**：
- 遷移元：記事一覧画面、記事詳細画面、グローバルナビゲーション
- 遷移先：記事詳細画面、著者別記事一覧画面、タグ別記事一覧画面

**権限による表示制御**：
- 本画面は認証状態に関わらず同一の表示内容
- 公開済み記事のみ表示

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 5 | 記事一覧表示 | 主機能 | カテゴリ別に公開中の記事を一覧表示 |
| 62 | ページネーション | 補助機能 | 記事一覧のページ送り処理 |

## 画面種別

一覧（ページネーション付き・フィルター付き）

## URL/ルーティング

- URL: `/articles/category/{category_name}/` または `/articles/category/{category_name}/page/{page}/`
- コントローラー: `ArticlesController`
- アクション: `categoryAction`
- モジュール: `default`
- レイアウト: `articles`
- URLパラメータ:
  - `variable`: カテゴリ名（URLエンコード済み）
  - `page`: ページ番号（オプション）

## 入出力項目

### 入力項目

| 項目名 | 入力/出力 | データ型 | 必須 | 説明 |
|--------|----------|---------|------|------|
| variable | URL | string | はい | カテゴリ名 |
| page | URL | int | いいえ | ページ番号（デフォルト:1） |

### 出力項目

| 項目名 | 入力/出力 | データ型 | 必須 | 説明 |
|--------|----------|---------|------|------|
| articlesArray | 出力 | Zend_Paginator | - | 記事一覧（ページネーション付き） |
| category | 出力 | string | - | カテゴリ名 |
| page | 出力 | int | - | 現在のページ番号 |
| params | 出力 | array | - | リクエストパラメータ |

## 表示項目

### カテゴリヘッダー

| 項目名 | データ型 | 表示形式 | 説明 |
|--------|---------|---------|------|
| Category: {category} | string | 見出しテキスト | カテゴリ名を表示 |

### 記事一覧（articlesArray）

| 項目名 | データ型 | 表示形式 | 説明 |
|--------|---------|---------|------|
| article_id | int | 非表示（リンク用） | 記事ID |
| article_title | string | リンク付きテキスト | 記事タイトル |
| article_intro | text | HTML | 記事導入文 |
| article_content | text | 判定用 | 「Read More」リンク表示判定 |
| article_comments | char(1) | 判定用 | コメントリンク表示判定 |
| article_published | datetime | 日付形式 | 公開日時 |
| user_alias | string | リンク付きテキスト | 著者名（設定による表示制御） |
| acat_title | string | リンク付きテキスト | カテゴリ名 |

### ページネーション

| 項目名 | 説明 |
|--------|------|
| 現在ページ | 現在のページ番号 |
| 前後ページリンク | 前/次ページへの遷移 |
| ページ番号リンク | 直接ページ指定 |

## イベント仕様

### 1-記事タイトルクリック

記事タイトルをクリックすると、該当記事の詳細画面へ遷移する。

- 遷移先: `/articles/article/{article_id}/{article_title}/`

### 2-Read Moreクリック

「Read More」リンクをクリックすると、記事詳細画面の続き部分へ遷移する。

- 遷移先: `/articles/article/{article_id}/{article_title}/#more`
- 条件: article_contentがNULLでない場合のみ表示

### 3-Commentクリック

「Comment」リンクをクリックすると、記事詳細画面のコメントセクションへ遷移する。

- 遷移先: `/articles/article/{article_id}/{article_title}/#comment`
- 条件: article_commentsが'Y'の場合のみ表示

### 4-著者名クリック

著者名をクリックすると、該当著者の記事一覧画面へ遷移する。

- 遷移先: `/articles/author/{user_alias}/`
- 条件: articles.iniのshowauthorがtrueの場合のみ表示

### 5-タグクリック

タグをクリックすると、該当タグの記事一覧画面へ遷移する。

- 遷移先: `/articles/tag/{tag_name}/`

### 6-ページネーション操作

ページ番号や前後ボタンをクリックすると、該当ページの記事一覧を表示する。

- 遷移先: `/articles/category/{category_name}/page/{page}/`

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 画面表示 | articles | SELECT | カテゴリに属する公開済み記事を取得 |
| 画面表示 | articles_categories | SELECT | カテゴリ情報を結合取得・フィルター条件 |
| 画面表示 | users | SELECT | 著者情報を結合取得 |

### テーブル別更新項目詳細

#### articles

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | 全カラム | article_published <= NOW() AND article_status = 'published' AND acat_title = {category} | カテゴリ条件付き |

**取得クエリ条件**:
- `article_published <= NOW()`: 予約投稿対応（公開日時が現在以前）
- `article_status = 'published'`: 公開済み記事のみ
- `acat_title = {category}`: 指定カテゴリに属する記事のみ
- `ORDER BY article_sticky DESC, article_published DESC`: sticky優先、公開日降順
- ページネーション: articles.iniのrows設定値/ページ

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示条件 |
|-------------|------|---------------|---------|
| MSG-001 | 情報 | This category doesn't have any associated articles | 該当カテゴリの記事が0件の場合 |

## 例外処理

| 例外条件 | 処理内容 |
|---------|---------|
| カテゴリパラメータ未指定 | 404エラー画面へフォワード |
| データベース接続エラー | システムエラー画面へ遷移 |
| 記事が存在しない場合 | 情報メッセージを表示（エラーにはならない） |

## 備考

- レイアウトは'articles'レイアウトを使用
- articles.iniのrows設定で1ページあたりの表示件数を制御
- Atom/RSSフィードへのリンクがheadタグ内に自動生成
- 著者名表示はarticles.iniのshowauthor設定に依存
- ページ範囲は5固定
- カテゴリ名はURLエンコード（urldecode）で処理
- 存在しないカテゴリを指定しても404にはならず、記事0件として表示

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、記事とカテゴリの関連データ構造を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | database.sql | `database.sql` | articlesテーブルのarticle_categoryカラム（外部キー） |
| 1-2 | database.sql | `database.sql` | articles_categoriesテーブル（acat_id, acat_title） |
| 1-3 | database.sql | `database.sql` | usersテーブルとの著者リレーション |

#### Step 2: エントリーポイントを理解する

処理の起点となるコントローラーアクションを特定する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | ArticlesController.php | `application/modules/default/controllers/ArticlesController.php` | init()メソッド（11-22行目）でレイアウト設定 |
| 2-2 | ArticlesController.php | `application/modules/default/controllers/ArticlesController.php` | categoryAction()メソッド（68-118行目） |

**主要処理フロー**:
1. **71行目**: setRefer()でセッションに現在URLを保存
2. **74行目**: リクエストパラメータをビューに設定
3. **75行目**: URLからカテゴリ名を取得（urldecode）
4. **78-83行目**: ページ番号取得（デフォルト1）
5. **85行目**: カテゴリ名存在チェック
6. **87行目**: カテゴリ名をビューに設定
7. **93-100行目**: SQLクエリ構築（articles JOIN categories JOIN users + カテゴリ条件）
8. **103-106行目**: Zend_Paginator設定
9. **109行目**: articlesArrayをビューに設定
10. **111-115行目**: カテゴリ未指定時は404へフォワード

#### Step 3: ビューテンプレートを理解する

画面表示のロジックを追跡する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | category.phtml | `application/modules/default/views/scripts/articles/category.phtml` | メインテンプレート。カテゴリ名表示と記事一覧 |
| 3-2 | articlelist.phtml | `application/modules/default/views/scripts/_partials/articlelist.phtml` | 記事個別表示テンプレート |

**主要処理フロー**:
- **18行目**: headTitleにカテゴリ名を含める
- **22-23行目**: Atom/RSSフィードリンクを設定
- **29行目**: カテゴリ名を見出しとして表示（escape処理）
- **35-45行目**: articlesArrayの件数に応じて記事一覧またはメッセージを表示
- **37行目**: partialLoopで記事を繰り返し表示
- **39行目**: paginationControlでページネーション表示
- **43行目**: 記事0件時のメッセージ表示

### プログラム呼び出し階層図

```
HTTP Request (/articles/category/{category_name}/)
    |
    +-- ArticlesController::init()
    |       |
    |       +-- articles.ini読み込み
    |       +-- レイアウト設定 ('articles')
    |
    +-- ArticlesController::preDispatch() [継承元: CMS_Controller_Action_Default]
    |       |
    |       +-- 認証状態確認
    |       +-- ACL構築
    |
    +-- ArticlesController::categoryAction()
            |
            +-- setRefer() - セッション保存
            +-- urldecode() - カテゴリ名デコード
            +-- ページ番号取得
            |
            +-- [カテゴリ名が存在]
            |       |
            |       +-- $registry->db->select() - SQLクエリ構築
            |       |       |
            |       |       +-- FROM articles
            |       |       +-- JOIN articles_categories
            |       |       +-- JOIN users
            |       |       +-- WHERE article_published <= NOW()
            |       |       +-- WHERE article_status = 'published'
            |       |       +-- WHERE acat_title = {category}
            |       |       +-- ORDER BY sticky DESC, published DESC
            |       |
            |       +-- Zend_Paginator::factory()
            |       |       |
            |       |       +-- setCurrentPageNumber()
            |       |       +-- setItemCountPerPage(articles.rows)
            |       |       +-- setPageRange(5)
            |       |
            |       +-- ビュー変数設定 (articlesArray, category)
            |
            +-- [カテゴリ名が未指定]
                    |
                    +-- レイアウト変更 ('main')
                    +-- _forward('notfound','error','default')
```

### データフロー図

```
[入力]               [処理]                    [出力]

HTTPリクエスト  ───▶ ArticlesController   ───▶ category.phtml
(/articles/          ::categoryAction()        |
 category/{name}/)        |                    +──▶ カテゴリ名表示
  |                  カテゴリ名デコード             (h2タグ)
  +-- category       SQL SELECT                +──▶ articlelist.phtml
  +-- page                |                         (partialLoop)
                          ▼                    +──▶ paginationControl
                     articles                       (ページネーション)
                     articles_categories
                     (WHERE acat_title)   ───▶ 記事0件:
                     users                      info.phtml表示
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| ArticlesController.php | `application/modules/default/controllers/ArticlesController.php` | ソース | 記事関連のコントローラー |
| category.phtml | `application/modules/default/views/scripts/articles/category.phtml` | テンプレート | カテゴリ別記事一覧画面のメインビュー |
| articlelist.phtml | `application/modules/default/views/scripts/_partials/articlelist.phtml` | テンプレート | 記事個別表示テンプレート |
| info.phtml | `application/modules/default/views/scripts/_partials/info.phtml` | テンプレート | 情報メッセージ表示テンプレート |
| default.phtml | `application/modules/default/views/scripts/_pagination/default.phtml` | テンプレート | ページネーションテンプレート |
| articles.ini | `application/configs/articles.ini` | 設定 | 記事表示設定（rows, showauthor等） |
| database.sql | `database.sql` | スキーマ | articles, articles_categories, usersテーブル定義 |
