# 画面設計書 11-著者別記事一覧画面

## 概要

本ドキュメントは、Legacy CMSの著者別記事一覧画面の設計を記載する。

### 本画面の処理概要

著者別記事一覧画面は、特定の著者（ユーザー）が執筆した記事を一覧形式で表示する画面である。サイト訪問者は、この画面を通じて特定のライターの記事をまとめて閲覧することができる。

**業務上の目的・背景**：
CMSサイトでは複数のライターが記事を投稿するケースが多い。読者が特定のライターのファンとなった場合や、特定のライターの専門分野の記事だけを読みたい場合に、そのライターの記事を効率的に探せる機能が必要となる。本画面はそのニーズに応え、ライター別に記事をフィルタリングして表示することで、ユーザーエクスペリエンスを向上させる。

**画面へのアクセス方法**：
- 記事詳細画面から著者名リンクをクリック
- URL直接入力: `/articles/author/{著者名}/`
- 記事一覧画面の各記事に表示される著者名リンクをクリック

**主要な操作・処理内容**：
1. 著者名パラメータを受け取り、該当著者の公開済み記事を取得
2. ページネーションを用いて記事一覧を表示
3. 各記事のタイトル、導入文、公開日、カテゴリ、タグを表示
4. 記事詳細画面への遷移リンクを提供

**画面遷移**：
- 遷移元: 記事詳細画面、記事一覧画面、カテゴリ別記事一覧画面
- 遷移先: 記事詳細画面、カテゴリ別記事一覧画面、タグ別記事一覧画面

**権限による表示制御**：
特になし。全ユーザー（匿名ユーザー含む）がアクセス可能。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 5 | 記事一覧表示 | 主機能 | 著者でフィルタした記事を表示 |
| 20 | プロフィール表示 | 補助機能 | 著者情報の取得・表示 |
| 62 | ページネーション | 補助機能 | 記事一覧のページ送り処理 |

## 画面種別

一覧

## URL/ルーティング

| パス | HTTPメソッド | アクション |
|------|--------------|------------|
| `/articles/author/{variable}/` | GET | authorAction |
| `/articles/author/{variable}/page/{page}/` | GET | authorAction（ページ指定） |

## 入出力項目

### 入力項目（URLパラメータ）

| 項目名 | パラメータ名 | 型 | 必須 | 説明 |
|--------|-------------|-----|------|------|
| 著者名 | variable | string | Yes | 著者のユーザーエイリアス（URLエンコード） |
| ページ番号 | page | integer | No | ページネーションのページ番号（デフォルト: 1） |

## 表示項目

### 記事一覧

| 項目名 | データソース | 説明 |
|--------|-------------|------|
| 著者名見出し | $this->author | 「Author: {著者名}」形式で表示 |
| 記事タイトル | article_title | 記事詳細画面へのリンク付き |
| 著者名 | user_alias | 設定により表示/非表示（著者別画面へのリンク付き） |
| 公開日 | article_published | ADateヘルパーでフォーマット |
| 導入文 | article_intro | HTML形式で表示 |
| 続きを読むリンク | - | article_contentがある場合のみ表示 |
| コメントリンク | - | article_commentsが'Y'の場合のみ表示 |
| コメント数 | - | CCountヘルパーで取得 |
| カテゴリ | acat_title | カテゴリ別記事一覧へのリンク付き |
| タグ一覧 | - | TListヘルパーで取得・表示 |

### ページネーション

| 項目名 | 説明 |
|--------|------|
| 現在ページ/総ページ | 「Page X of Y」形式 |
| 前へリンク | 前ページがある場合のみ活性化 |
| ページ番号リンク | ページ範囲内の番号を表示 |
| 次へリンク | 次ページがある場合のみ活性化 |

## イベント仕様

### 1-記事タイトルクリック

記事タイトルをクリックすると、該当記事の詳細画面に遷移する。

- 遷移先: `/articles/article/{article_id}/{article_title}/`

### 2-カテゴリリンククリック

カテゴリ名をクリックすると、該当カテゴリの記事一覧画面に遷移する。

- 遷移先: `/articles/category/{acat_title}/`

### 3-タグリンククリック

タグ名をクリックすると、該当タグの記事一覧画面に遷移する。

- 遷移先: `/articles/tag/{tag_name}/`

### 4-ページネーション操作

ページ番号や前へ/次へリンクをクリックすると、該当ページの記事一覧を表示する。

- 遷移先: `/articles/author/{variable}/page/{page}/`

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 画面表示 | articles | SELECT | 著者の公開済み記事を取得 |
| 画面表示 | articles_categories | SELECT | 記事カテゴリ情報を取得 |
| 画面表示 | users | SELECT | 著者情報を取得 |

### テーブル別更新項目詳細

#### articles（SELECT）

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | article_id | - | 記事ID |
| SELECT | article_title | - | 記事タイトル |
| SELECT | article_intro | - | 導入文 |
| SELECT | article_content | - | 本文 |
| SELECT | article_published | article_published <= NOW() | 公開日（現在日時以前） |
| SELECT | article_status | article_status = 'published' | 公開ステータス |
| SELECT | article_comments | - | コメント許可フラグ |
| SELECT | article_sticky | ORDER BY DESC | 固定記事フラグ |

#### articles_categories（SELECT）

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | acat_title | - | カテゴリ名 |

#### users（SELECT）

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | user_alias | user_alias = {著者名パラメータ} | 著者のエイリアス |

## メッセージ仕様

| メッセージID | 種別 | メッセージ | 表示条件 |
|-------------|------|----------|---------|
| MSG001 | 情報 | This author hasn't posted any articles | 該当著者の記事が0件の場合 |

## 例外処理

| 例外 | 処理 |
|------|------|
| 著者名パラメータ未指定 | 404エラー画面へフォワード |
| 該当著者が存在しない | 空の記事一覧を表示（MSG001を表示） |

## 備考

- 記事は固定記事（article_sticky）を優先し、公開日の降順でソートされる
- 著者名はURLエンコードされた状態でパラメータとして受け取り、urldecodeで復元する
- Atom/RSSフィードへのリンクがhead内に設定される

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、記事データの構造とDBスキーマを理解することが重要である。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | articles テーブル | DB Schema | article_id, article_title, article_intro, article_content, article_published, article_status, article_comments, article_sticky カラムの役割 |
| 1-2 | articles_categories テーブル | DB Schema | acat_id, acat_title の関連 |
| 1-3 | users テーブル | DB Schema | user_id, user_alias の関連 |

**読解のコツ**: Zend Framework 1.x系のDB操作はZend_Db_Selectを使用。JOINによるテーブル結合とWHERE句の条件指定に注目。

#### Step 2: エントリーポイントを理解する

処理の起点となるコントローラーアクションを特定する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | ArticlesController.php | `application/modules/default/controllers/ArticlesController.php` | authorActionメソッドがエントリーポイント |

**主要処理フロー**:
1. **123行目**: authorAction()メソッド開始
2. **126行目**: setRefer()でログイン後のリダイレクト先を設定
3. **130行目**: URLパラメータから著者名を取得（urldecodeで復元）
4. **133-138行目**: ページ番号の取得とデフォルト値設定
5. **140行目**: 著者名パラメータの存在チェック
6. **148-155行目**: SQLクエリ構築（articles, articles_categories, usersのJOIN）
7. **157-161行目**: Zend_Paginatorでページネーション設定
8. **164行目**: ビューに記事配列を渡す

#### Step 3: ビューテンプレートを理解する

表示処理を担当するビューファイルを読み解く。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | author.phtml | `application/modules/default/views/scripts/articles/author.phtml` | メインテンプレート、著者名の表示とpartialLoopの呼び出し |
| 3-2 | articlelist.phtml | `application/modules/default/views/scripts/_partials/articlelist.phtml` | 個別記事の表示テンプレート |
| 3-3 | default.phtml | `application/modules/default/views/scripts/_pagination/default.phtml` | ページネーション表示 |

**主要処理フロー**:
- **author.phtml 29行目**: 著者名見出しの表示
- **author.phtml 35-45行目**: 記事存在チェックと条件分岐
- **author.phtml 37行目**: partialLoopで各記事をarticlelist.phtmlで表示
- **author.phtml 39行目**: paginationControlでページネーション表示

#### Step 4: ビューヘルパーを理解する

ビューヘルパーの役割を確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | ADate.php | `library/CMS/View/Helper/ADate.php` | 日付フォーマット用ヘルパー |
| 4-2 | CCount.php | `library/CMS/View/Helper/CCount.php` | コメント数取得ヘルパー |
| 4-3 | TList.php | `library/CMS/View/Helper/TList.php` | タグ一覧表示ヘルパー |

### プログラム呼び出し階層図

```
authorAction() [ArticlesController.php:123]
    │
    ├─ setRefer() - ログインリファラー設定
    │
    ├─ Zend_Registry::getInstance() - レジストリ取得
    │
    ├─ $registry->db->select() - SQLクエリ構築
    │      ├─ from('articles')
    │      ├─ join('articles_categories')
    │      ├─ join('users')
    │      ├─ where('article_published <= NOW()')
    │      ├─ where('article_status = published')
    │      ├─ where('user_alias = ?')
    │      └─ order('article_sticky DESC, article_published DESC')
    │
    ├─ Zend_Paginator::factory($select) - ページネーター生成
    │
    └─ View rendering
           ├─ author.phtml
           │      ├─ partialLoop('_partials/articlelist.phtml')
           │      │      ├─ ADate() - 日付フォーマット
           │      │      ├─ CCount() - コメント数
           │      │      └─ TList() - タグ一覧
           │      └─ paginationControl()
           │             └─ _pagination/default.phtml
           └─ articles.phtml (layout)
```

### データフロー図

```
[入力]                    [処理]                           [出力]

URLパラメータ
  ├─ variable(著者名) ──▶ ArticlesController::authorAction()
  └─ page(ページ番号)           │
                              ▼
                    Zend_Db_Select (クエリ構築)
                              │
                              ▼
                    ┌─────────────────────┐
                    │     Database        │
                    │  ├─ articles        │
                    │  ├─ articles_categories │
                    │  └─ users           │
                    └─────────────────────┘
                              │
                              ▼
                    Zend_Paginator (ページ分割)
                              │
                              ▼
                    View (author.phtml)
                              │
                              ▼
                    ┌─────────────────────┐
                    │   HTML Response     │
                    │  ├─ 著者名見出し      │
                    │  ├─ 記事一覧         │
                    │  └─ ページネーション  │
                    └─────────────────────┘
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| ArticlesController.php | `application/modules/default/controllers/ArticlesController.php` | コントローラー | 記事関連アクションの制御 |
| author.phtml | `application/modules/default/views/scripts/articles/author.phtml` | ビュー | 著者別記事一覧画面のメインテンプレート |
| articlelist.phtml | `application/modules/default/views/scripts/_partials/articlelist.phtml` | パーシャル | 個別記事の表示テンプレート |
| default.phtml | `application/modules/default/views/scripts/_pagination/default.phtml` | パーシャル | ページネーションコンポーネント |
| info.phtml | `application/modules/default/views/scripts/_partials/info.phtml` | パーシャル | 情報メッセージ表示 |
| articles.phtml | `application/layouts/scripts/articles.phtml` | レイアウト | 記事セクション用レイアウト |
| articles.ini | `application/configs/articles.ini` | 設定 | 記事モジュールの設定ファイル |
| CMS_Controller_Action_Default | `library/CMS/Controller/Action/Default.php` | 基底クラス | デフォルトモジュール用コントローラー基底クラス |
