# 画面設計書 12-アーカイブ画面

## 概要

本ドキュメントは、Legacy CMSのアーカイブ画面の設計を記載する。

### 本画面の処理概要

アーカイブ画面は、記事を年月別に分類して一覧表示する画面である。サイト訪問者は、この画面を通じて過去の特定の時期に公開された記事を効率的に探すことができる。

**業務上の目的・背景**：
ブログやニュースサイトでは、過去の記事を時系列で探したいというニーズが存在する。特定のイベントや季節に関連した記事、または過去の特定時期の情報を振り返りたい場合に、年月別のアーカイブ機能は非常に有用である。本画面は、公開日に基づいて記事を整理し、時間軸でのコンテンツナビゲーションを提供する。

**画面へのアクセス方法**：
- サイドバーやフッターのアーカイブリンクからアクセス
- URL直接入力: `/articles/archive/{year}/{month}/` または `/articles/archive/{year}/`
- 記事一覧画面からのリンク

**主要な操作・処理内容**：
1. 年・月パラメータを受け取り、該当期間の公開済み記事を取得
2. ページネーションを用いて記事一覧を表示
3. 各記事のタイトル、導入文、公開日、カテゴリ、タグを表示
4. 記事詳細画面への遷移リンクを提供

**画面遷移**：
- 遷移元: 記事一覧画面、サイドバー、フッター
- 遷移先: 記事詳細画面、カテゴリ別記事一覧画面、タグ別記事一覧画面、著者別記事一覧画面

**権限による表示制御**：
特になし。全ユーザー（匿名ユーザー含む）がアクセス可能。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 5 | 記事一覧表示 | 主機能 | 年月別の記事アーカイブを表示 |
| 62 | ページネーション | 補助機能 | 記事一覧のページ送り処理 |

## 画面種別

一覧

## URL/ルーティング

| パス | HTTPメソッド | アクション |
|------|--------------|------------|
| `/articles/archive/{year}/` | GET | archiveAction（年指定） |
| `/articles/archive/{year}/{month}/` | GET | archiveAction（年月指定） |
| `/articles/archive/{year}/{month}/page/{page}/` | GET | archiveAction（年月指定・ページ指定） |

## 入出力項目

### 入力項目（URLパラメータ）

| 項目名 | パラメータ名 | 型 | 必須 | 説明 |
|--------|-------------|-----|------|------|
| 年 | year | integer | Yes | 4桁の西暦年 |
| 月 | month | integer | No | 1-12の月 |
| ページ番号 | page | integer | No | ページネーションのページ番号（デフォルト: 1） |

## 表示項目

### アーカイブ見出し

| 項目名 | データソース | 説明 |
|--------|-------------|------|
| アーカイブ見出し | $this->month, $this->year | 「Archive: {月名} {年}」形式で表示 |

### 記事一覧

| 項目名 | データソース | 説明 |
|--------|-------------|------|
| 記事タイトル | article_title | 記事詳細画面へのリンク付き |
| 著者名 | user_alias | 設定により表示/非表示（著者別画面へのリンク付き） |
| 公開日 | article_published | ADateヘルパーでフォーマット |
| 導入文 | article_intro | HTML形式で表示 |
| 続きを読むリンク | - | article_contentがある場合のみ表示 |
| コメントリンク | - | article_commentsが'Y'の場合のみ表示 |
| コメント数 | - | CCountヘルパーで取得 |
| カテゴリ | acat_title | カテゴリ別記事一覧へのリンク付き |
| タグ一覧 | - | TListヘルパーで取得・表示 |

### ページネーション

| 項目名 | 説明 |
|--------|------|
| 現在ページ/総ページ | 「Page X of Y」形式 |
| 前へリンク | 前ページがある場合のみ活性化 |
| ページ番号リンク | ページ範囲内の番号を表示 |
| 次へリンク | 次ページがある場合のみ活性化 |

## イベント仕様

### 1-記事タイトルクリック

記事タイトルをクリックすると、該当記事の詳細画面に遷移する。

- 遷移先: `/articles/article/{article_id}/{article_title}/`

### 2-著者名リンククリック

著者名をクリックすると、該当著者の記事一覧画面に遷移する。

- 遷移先: `/articles/author/{user_alias}/`
- 条件: articles設定でshowauthorがtrueの場合のみリンク表示

### 3-カテゴリリンククリック

カテゴリ名をクリックすると、該当カテゴリの記事一覧画面に遷移する。

- 遷移先: `/articles/category/{acat_title}/`

### 4-タグリンククリック

タグ名をクリックすると、該当タグの記事一覧画面に遷移する。

- 遷移先: `/articles/tag/{tag_name}/`

### 5-ページネーション操作

ページ番号や前へ/次へリンクをクリックすると、該当ページの記事一覧を表示する。

- 遷移先: `/articles/archive/{year}/{month}/page/{page}/`

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 画面表示 | articles | SELECT | 指定年月の公開済み記事を取得 |
| 画面表示 | articles_categories | SELECT | 記事カテゴリ情報を取得 |
| 画面表示 | users | SELECT | 著者情報を取得 |

### テーブル別更新項目詳細

#### articles（SELECT）

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | article_id | - | 記事ID |
| SELECT | article_title | - | 記事タイトル |
| SELECT | article_intro | - | 導入文 |
| SELECT | article_content | - | 本文 |
| SELECT | article_published | article_published <= NOW() | 公開日（現在日時以前） |
| SELECT | article_published | month(article_published) = {month} | 月の絞り込み |
| SELECT | article_published | year(article_published) = {year} | 年の絞り込み |
| SELECT | article_status | article_status = 'published' | 公開ステータス |
| SELECT | article_comments | - | コメント許可フラグ |
| SELECT | article_sticky | ORDER BY DESC | 固定記事フラグ |

#### articles_categories（SELECT）

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | acat_title | - | カテゴリ名 |

#### users（SELECT）

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | user_alias | - | 著者のエイリアス |

## メッセージ仕様

| メッセージID | 種別 | メッセージ | 表示条件 |
|-------------|------|----------|---------|
| MSG001 | 情報 | There are no articles from this period to display. | 該当期間の記事が0件の場合 |

## 例外処理

| 例外 | 処理 |
|------|------|
| 年パラメータ未指定 | 404エラー画面へフォワード |
| 年・月パラメータが不正な値 | getdate()による変換処理（暗黙的な正規化） |
| 該当期間の記事がない | 空の記事一覧を表示（MSG001を表示） |

## 備考

- 記事は固定記事（article_sticky）を優先し、公開日の降順でソートされる
- 年のみ指定の場合は、その年の全記事が対象となる
- 月名は英語表記（January, February等）でgetdate()関数から取得
- Atom/RSSフィードへのリンクがhead内に設定される

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、記事データの構造とDBスキーマを理解することが重要である。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | articles テーブル | DB Schema | article_published カラムの日時型、年月抽出に使用 |
| 1-2 | articles_categories テーブル | DB Schema | acat_id, acat_title の関連 |
| 1-3 | users テーブル | DB Schema | user_id, user_alias の関連 |

**読解のコツ**: MySQLのmonth()、year()関数を使用した日付フィルタリングに注目。

#### Step 2: エントリーポイントを理解する

処理の起点となるコントローラーアクションを特定する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | ArticlesController.php | `application/modules/default/controllers/ArticlesController.php` | archiveActionメソッドがエントリーポイント |

**主要処理フロー**:
1. **178行目**: archiveAction()メソッド開始
2. **181行目**: setRefer()でログイン後のリダイレクト先を設定
3. **185-186行目**: URLパラメータからyear, monthを取得
4. **189-194行目**: ページ番号の取得とデフォルト値設定
5. **196行目**: 年・月両方指定の場合の分岐
6. **199-200行目**: mktime, getdateで日付情報を構築
7. **210-218行目**: SQLクエリ構築（year, month条件追加）
8. **220-224行目**: Zend_Paginatorでページネーション設定
9. **229行目**: 年のみ指定の場合の分岐
10. **260-265行目**: パラメータ未指定時の404エラー処理

#### Step 3: ビューテンプレートを理解する

表示処理を担当するビューファイルを読み解く。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | archive.phtml | `application/modules/default/views/scripts/articles/archive.phtml` | メインテンプレート、年月見出しの表示 |
| 3-2 | articlelist.phtml | `application/modules/default/views/scripts/_partials/articlelist.phtml` | 個別記事の表示テンプレート |
| 3-3 | default.phtml | `application/modules/default/views/scripts/_pagination/default.phtml` | ページネーション表示 |

**主要処理フロー**:
- **archive.phtml 29行目**: 年月見出しの表示（Archive: {month} {year}）
- **archive.phtml 35-45行目**: 記事存在チェックと条件分岐
- **archive.phtml 37行目**: partialLoopで各記事をarticlelist.phtmlで表示
- **archive.phtml 39行目**: paginationControlでページネーション表示

### プログラム呼び出し階層図

```
archiveAction() [ArticlesController.php:178]
    │
    ├─ setRefer() - ログインリファラー設定
    │
    ├─ mktime() - UNIXタイムスタンプ生成
    │      └─ (12, 0, 0, $month, 1, $year)
    │
    ├─ getdate() - 日付配列取得
    │      └─ ['year'], ['month'] を抽出
    │
    ├─ Zend_Registry::getInstance() - レジストリ取得
    │
    ├─ $registry->db->select() - SQLクエリ構築
    │      ├─ from('articles')
    │      ├─ join('articles_categories')
    │      ├─ join('users')
    │      ├─ where('article_published <= NOW()')
    │      ├─ where('article_status = published')
    │      ├─ where('month(article_published) = ?') [年月指定時]
    │      ├─ where('year(article_published) = ?')
    │      └─ order('article_sticky DESC, article_published DESC')
    │
    ├─ Zend_Paginator::factory($select) - ページネーター生成
    │
    └─ View rendering
           ├─ archive.phtml
           │      ├─ partialLoop('_partials/articlelist.phtml')
           │      │      ├─ ADate() - 日付フォーマット
           │      │      ├─ CCount() - コメント数
           │      │      └─ TList() - タグ一覧
           │      └─ paginationControl()
           │             └─ _pagination/default.phtml
           └─ articles.phtml (layout)
```

### データフロー図

```
[入力]                    [処理]                           [出力]

URLパラメータ
  ├─ year(年) ─────────▶ ArticlesController::archiveAction()
  ├─ month(月)                  │
  └─ page(ページ番号)            │
                              ▼
                    mktime() / getdate()
                    (日付情報の変換)
                              │
                              ▼
                    Zend_Db_Select (クエリ構築)
                    month(), year() 関数使用
                              │
                              ▼
                    ┌─────────────────────┐
                    │     Database        │
                    │  ├─ articles        │
                    │  ├─ articles_categories │
                    │  └─ users           │
                    └─────────────────────┘
                              │
                              ▼
                    Zend_Paginator (ページ分割)
                              │
                              ▼
                    View (archive.phtml)
                              │
                              ▼
                    ┌─────────────────────┐
                    │   HTML Response     │
                    │  ├─ 年月見出し        │
                    │  ├─ 記事一覧         │
                    │  └─ ページネーション  │
                    └─────────────────────┘
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| ArticlesController.php | `application/modules/default/controllers/ArticlesController.php` | コントローラー | 記事関連アクションの制御 |
| archive.phtml | `application/modules/default/views/scripts/articles/archive.phtml` | ビュー | アーカイブ画面のメインテンプレート |
| articlelist.phtml | `application/modules/default/views/scripts/_partials/articlelist.phtml` | パーシャル | 個別記事の表示テンプレート |
| default.phtml | `application/modules/default/views/scripts/_pagination/default.phtml` | パーシャル | ページネーションコンポーネント |
| info.phtml | `application/modules/default/views/scripts/_partials/info.phtml` | パーシャル | 情報メッセージ表示 |
| articles.phtml | `application/layouts/scripts/articles.phtml` | レイアウト | 記事セクション用レイアウト |
| articles.ini | `application/configs/articles.ini` | 設定 | 記事モジュールの設定ファイル |
| CMS_Controller_Action_Default | `library/CMS/Controller/Action/Default.php` | 基底クラス | デフォルトモジュール用コントローラー基底クラス |
