# 画面設計書 15-記事タグ一覧画面

## 概要

本ドキュメントは、Legacy CMSの記事タグ一覧画面の設計を記載する。

### 本画面の処理概要

記事タグ一覧画面は、記事に付けられているすべてのタグをタグクラウド形式で表示する画面である。サイト訪問者は、この画面を通じて記事のタグ全体を俯瞰し、興味のあるトピックの記事にアクセスすることができる。

**業務上の目的・背景**：
タグクラウドは、サイト内のコンテンツの傾向を視覚的に把握できるインターフェースである。タグの使用頻度によってフォントサイズが変わることで、人気のトピックやサイトの特徴が一目でわかる。本画面は記事に特化したタグクラウドを提供し、記事コンテンツの探索を支援する。

**画面へのアクセス方法**：
- サイドバーやフッターのタグ一覧リンクからアクセス
- 記事一覧画面からのリンク
- URL直接入力: `/articles/tags/`

**主要な操作・処理内容**：
1. 記事に付けられた全タグを取得
2. タグクラウド形式で表示（使用頻度によりサイズ変化）
3. All/Blog/Pagesのタブナビゲーションを提供
4. 各タグからタグ別記事一覧画面への遷移

**画面遷移**：
- 遷移元: 記事一覧画面、サイドバー、フッター
- 遷移先: タグ別記事一覧画面、タグ一覧画面（全体）、ページタグ一覧画面

**権限による表示制御**：
特になし。全ユーザー（匿名ユーザー含む）がアクセス可能。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 49 | タグ一覧表示 | 主機能 | 記事に関連するタグを一覧表示 |

## 画面種別

一覧

## URL/ルーティング

| パス | HTTPメソッド | アクション |
|------|--------------|------------|
| `/articles/tags/` | GET | tagsAction |

## 入出力項目

### 入力項目

なし（パラメータ不要）

## 表示項目

### タブナビゲーション

| 項目名 | データソース | 説明 |
|--------|-------------|------|
| 見出し | - | 「Tags: Blog」固定表示 |
| Allタブ | TCount('ALL','ALL') | 全タグ一覧へのリンク、総タグ数を表示 |
| Blogタブ | ATagCount('ALL') | 現在のタブ（アクティブ）、記事タグ数を表示 |
| Pagesタブ | PTagCount('ALL') | ページタグ一覧へのリンク、ページタグ数を表示 |

### タグクラウド

| 項目名 | データソース | 説明 |
|--------|-------------|------|
| タグクラウド | ATagCloud | 記事タグをクラウド形式で表示、各タグはタグ別記事一覧へのリンク |

## イベント仕様

### 1-タグクリック

タグクラウド内のタグをクリックすると、該当タグの記事一覧画面に遷移する。

- 遷移先: `/articles/tag/{tag_name}/`

### 2-Allタブクリック

Allタブをクリックすると、全タグ一覧画面（トップ）に遷移する。

- 遷移先: `/tags/`

### 3-Pagesタブクリック

Pagesタブをクリックすると、ページタグ一覧画面に遷移する。

- 遷移先: `/pages/tags/`

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 画面表示 | tags | SELECT | 記事タグの一覧と使用頻度を取得 |

### テーブル別更新項目詳細

#### tags（SELECT - タグクラウド生成用）

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | tag_tag | - | タグ文字列 |
| SELECT | COUNT(*) | GROUP BY tag_tag | タグ使用頻度 |
| SELECT | tag_type | tag_type = 'A' | 記事タグのみ |

## メッセージ仕様

| メッセージID | 種別 | メッセージ | 表示条件 |
|-------------|------|----------|---------|
| - | - | - | 特になし（タグが0件の場合も空のクラウドを表示） |

## 例外処理

| 例外 | 処理 |
|------|------|
| タグが存在しない | 空のタグクラウドを表示 |

## 備考

- タグクラウドはATagCloudビューヘルパーで生成される
- タグのフォントサイズは使用頻度に比例して大きくなる
- サイドバーにタグ一覧が表示されるレイアウトの場合、showTagsプレースホルダーを'false'に設定して重複表示を防ぐ

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、タグデータの構造を理解することが重要である。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | tags テーブル | DB Schema | tag_tag（タグ文字列）, tag_type（種別: A=記事）, tag_slave（関連ID） |

**読解のコツ**: タグクラウド生成のため、同じtag_tagをGROUP BYしてCOUNTする。

#### Step 2: エントリーポイントを理解する

処理の起点となるコントローラーアクションを特定する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | ArticlesController.php | `application/modules/default/controllers/ArticlesController.php` | tagsActionメソッドがエントリーポイント |

**主要処理フロー**:
1. **374行目**: tagsAction()メソッド開始
2. **377行目**: setRefer()でログイン後のリダイレクト先を設定
3. （その他の処理はビューヘルパーに委譲）

#### Step 3: ビューテンプレートを理解する

表示処理を担当するビューファイルを読み解く。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | tags.phtml | `application/modules/default/views/scripts/articles/tags.phtml` | メインテンプレート、タブナビゲーション、タグクラウド呼び出し |

**主要処理フロー**:
- **tags.phtml 21行目**: showTagsプレースホルダーを'false'に設定
- **tags.phtml 28行目**: 見出し「Tags: Blog」の表示
- **tags.phtml 31-34行目**: All/Blog/Pagesタブナビゲーション
- **tags.phtml 41行目**: ATagCloudヘルパーでタグクラウド生成

#### Step 4: ビューヘルパーを理解する

タグクラウド生成とカウント取得のヘルパーを確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | ATagCloud.php | `library/CMS/View/Helper/ATagCloud.php` | 記事タグクラウド生成ロジック |
| 4-2 | TCount.php | `library/CMS/View/Helper/TCount.php` | 全タグカウント取得 |
| 4-3 | ATagCount.php | `library/CMS/View/Helper/ATagCount.php` | 記事タグカウント取得 |
| 4-4 | PTagCount.php | `library/CMS/View/Helper/PTagCount.php` | ページタグカウント取得 |

### プログラム呼び出し階層図

```
tagsAction() [ArticlesController.php:374]
    │
    ├─ setRefer() - ログインリファラー設定
    │
    └─ View rendering
           └─ tags.phtml
                  ├─ placeholder('showTags')->set('false')
                  │      └─ サイドバーのタグ表示を抑制
                  │
                  ├─ TCount('ALL','ALL') - 全タグ数
                  │
                  ├─ ATagCount('ALL') - 記事タグ数
                  │
                  ├─ PTagCount('ALL') - ページタグ数
                  │
                  └─ ATagCloud('articles','ALL') - タグクラウド生成
                         │
                         ├─ SELECT tag_tag, COUNT(*) FROM tags
                         │      WHERE tag_type = 'A'
                         │      GROUP BY tag_tag
                         │
                         └─ HTML生成（サイズ算出含む）
```

### データフロー図

```
[入力]                    [処理]                           [出力]

    なし ──────────────▶ ArticlesController::tagsAction()
                              │
                              ▼
                    View (tags.phtml)
                              │
          ┌───────────────────┼───────────────────┐
          ▼                   ▼                   ▼
    TCount()            ATagCount()          ATagCloud()
          │                   │                   │
          ▼                   ▼                   ▼
    ┌─────────────────────────────────────────────────┐
    │                   Database                       │
    │           tags テーブル (SELECT)                 │
    └─────────────────────────────────────────────────┘
          │                   │                   │
          ▼                   ▼                   ▼
    ┌──────────────────────────────────────────────┐
    │                HTML Response                  │
    │  ├─ タブナビゲーション（件数付き）               │
    │  └─ タグクラウド（リンク付き）                   │
    └──────────────────────────────────────────────┘
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| ArticlesController.php | `application/modules/default/controllers/ArticlesController.php` | コントローラー | 記事関連アクションの制御 |
| tags.phtml | `application/modules/default/views/scripts/articles/tags.phtml` | ビュー | 記事タグ一覧画面のメインテンプレート |
| articles.phtml | `application/layouts/scripts/articles.phtml` | レイアウト | 記事セクション用レイアウト |
| ATagCloud.php | `library/CMS/View/Helper/ATagCloud.php` | ヘルパー | 記事タグクラウド生成 |
| TCount.php | `library/CMS/View/Helper/TCount.php` | ヘルパー | 全タグカウント取得 |
| ATagCount.php | `library/CMS/View/Helper/ATagCount.php` | ヘルパー | 記事タグカウント取得 |
| PTagCount.php | `library/CMS/View/Helper/PTagCount.php` | ヘルパー | ページタグカウント取得 |
