# 画面設計書 16-イベント一覧画面

## 概要

本ドキュメントは、Legacy CMSのイベント一覧画面の設計を記載する。

### 本画面の処理概要

イベント一覧画面は、サイトに登録されている公開中のイベントを一覧形式と地図形式で表示する画面である。サイト訪問者は、この画面を通じて今後開催されるイベントを確認し、興味のあるイベントの詳細にアクセスすることができる。

**業務上の目的・背景**：
イベント管理はCMSの重要な機能の一つである。ユーザーが今後のイベントを効率的に探し、参加を検討できるようにする必要がある。地図表示により、イベントの開催場所を視覚的に把握できることで、地理的な条件での絞り込みが容易になる。本画面はイベントコンテンツのメインハブとして機能する。

**画面へのアクセス方法**：
- トップメニューやナビゲーションからEventsリンクをクリック
- ホーム画面からのリンク
- URL直接入力: `/events/`

**主要な操作・処理内容**：
1. 公開中かつ開催日が今日以降のイベントを取得
2. ローテーター（画像スライダー）の表示
3. Google Maps上に会場をマーカー表示
4. ページネーションを用いてイベント一覧を表示
5. 各イベントの詳細画面への遷移

**画面遷移**：
- 遷移元: ホーム画面、トップメニュー
- 遷移先: イベント詳細画面、カテゴリ別イベント一覧画面、会場別イベント一覧画面、カレンダー画面

**権限による表示制御**：
特になし。全ユーザー（匿名ユーザー含む）がアクセス可能。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 21 | イベント一覧表示 | 主機能 | 公開中のイベントを一覧表示 |
| 62 | ページネーション | 補助機能 | イベント一覧のページ送り処理 |

## 画面種別

一覧

## URL/ルーティング

| パス | HTTPメソッド | アクション |
|------|--------------|------------|
| `/events/` | GET | indexAction |
| `/events/page/{page}/` | GET | indexAction（ページ指定） |

## 入出力項目

### 入力項目（URLパラメータ）

| 項目名 | パラメータ名 | 型 | 必須 | 説明 |
|--------|-------------|-----|------|------|
| ページ番号 | page | integer | No | ページネーションのページ番号（デフォルト: 1） |

## 表示項目

### ヘッダーセクション

| 項目名 | データソース | 説明 |
|--------|-------------|------|
| タイトル | - | 「Events」固定表示 |
| ローテーター | RenderRotator('EventsIndex') | イベント用画像ローテーター |

### 地図セクション

| 項目名 | データソース | 説明 |
|--------|-------------|------|
| Google Map | - | 会場位置をマーカー表示（JavaScript有効時のみ） |

### イベント一覧

| 項目名 | データソース | 説明 |
|--------|-------------|------|
| イベント名 | event_title | イベント詳細画面へのリンク付き |
| カテゴリ | ecat_title | カテゴリ名を表示 |
| 会場名 | venue_title | venue_id != 1 の場合のみ表示 |
| 会場都市 | venue_city | venue_id != 1 の場合のみ表示 |
| 開催日時 | event_date, event_end | EDateヘルパーでフォーマット |

### ページネーション

| 項目名 | 説明 |
|--------|------|
| 現在ページ/総ページ | 「Page X of Y」形式 |
| 前へリンク | 前ページがある場合のみ活性化 |
| ページ番号リンク | ページ範囲内の番号を表示 |
| 次へリンク | 次ページがある場合のみ活性化 |

## イベント仕様

### 1-イベント行クリック

イベント行をクリックすると、該当イベントの詳細画面に遷移する。

- 遷移先: `/events/event/{event_id}/{event_title}/`
- 実装: onclick="goTo()"でJavaScript経由

### 2-イベントリンククリック

イベント名リンクをクリックすると、該当イベントの詳細画面に遷移する。

- 遷移先: `/events/event/{event_id}/{event_title}/`

### 3-地図マーカークリック

地図上のマーカーをクリックすると、会場情報のInfoBoxが表示される（JavaScript実装）。

### 4-ページネーション操作

ページ番号や前へ/次へリンクをクリックすると、該当ページのイベント一覧を表示する。

- 遷移先: `/events/page/{page}/`

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 画面表示 | events | SELECT | 公開中の今後のイベントを取得 |
| 画面表示 | events_venues | SELECT | 会場情報を取得 |
| 画面表示 | events_categories | SELECT | イベントカテゴリ情報を取得 |

### テーブル別更新項目詳細

#### events（SELECT）

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | event_id | - | イベントID |
| SELECT | event_title | - | イベント名 |
| SELECT | event_date | event_date >= NOW() | 開催日（今日以降） |
| SELECT | event_end | - | 終了日 |
| SELECT | event_status | event_status = 'published' | 公開ステータス |

#### events_venues（SELECT）

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | venue_id | - | 会場ID |
| SELECT | venue_title | - | 会場名 |
| SELECT | venue_city | - | 会場都市 |
| SELECT | venue_latitude | - | 緯度（地図表示用） |
| SELECT | venue_longitude | - | 経度（地図表示用） |

#### events_categories（SELECT）

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | ecat_title | - | カテゴリ名 |

## メッセージ仕様

| メッセージID | 種別 | メッセージ | 表示条件 |
|-------------|------|----------|---------|
| MSG001 | 情報 | No events to display at the moment | イベントが0件の場合 |

## 例外処理

| 例外 | 処理 |
|------|------|
| イベントが存在しない | 空の一覧を表示（MSG001を表示） |
| JavaScript無効 | 地図が表示されない（noscriptによる代替メッセージなし、CSSで非表示） |

## 備考

- イベントは開催日（event_date）の昇順でソートされる（近い日程が先頭）
- venue_id = 1 は「会場未設定」を示すため、会場情報は表示されない
- 地図機能はGoogle Maps APIとinfobox_packed.jsに依存
- ローテーターはRenderRotatorヘルパーで生成される

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、イベントデータの構造を理解することが重要である。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | events テーブル | DB Schema | event_id, event_title, event_date, event_end, event_status, event_venue の関連 |
| 1-2 | events_venues テーブル | DB Schema | venue_id, venue_title, venue_city, venue_latitude, venue_longitude |
| 1-3 | events_categories テーブル | DB Schema | ecat_id, ecat_title |

**読解のコツ**: events.event_venue が events_venues.venue_id と紐づく。venue_id = 1 は特殊値（会場未設定）。

#### Step 2: エントリーポイントを理解する

処理の起点となるコントローラーアクションを特定する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | EventsController.php | `application/modules/default/controllers/EventsController.php` | indexActionメソッドがエントリーポイント |

**主要処理フロー**:
1. **28行目**: indexAction()メソッド開始
2. **30行目**: setRefer()でログイン後のリダイレクト先を設定
3. **34-39行目**: ページ番号の取得とデフォルト値設定
4. **44-50行目**: SQLクエリ構築（events, events_venues, events_categoriesのJOIN）
5. **53-56行目**: Zend_Paginatorでページネーション設定
6. **59行目**: ビューにイベント配列を渡す

#### Step 3: ビューテンプレートを理解する

表示処理を担当するビューファイルを読み解く。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | index.phtml | `application/modules/default/views/scripts/events/index.phtml` | メインテンプレート |
| 3-2 | eventlist.phtml | `application/modules/default/views/scripts/_partials/eventlist.phtml` | 個別イベントの表示テンプレート |
| 3-3 | default.phtml | `application/modules/default/views/scripts/_pagination/default.phtml` | ページネーション表示 |

**主要処理フロー**:
- **index.phtml 33行目**: タイトル「Events」の表示
- **index.phtml 38行目**: RenderRotatorでローテーター表示
- **index.phtml 40行目**: 地図用div（#map）
- **index.phtml 45-61行目**: イベント存在チェックと条件分岐
- **index.phtml 49行目**: partialLoopでeventlist.phtmlを呼び出し
- **index.phtml 55行目**: paginationControlでページネーション表示

### プログラム呼び出し階層図

```
indexAction() [EventsController.php:28]
    │
    ├─ setRefer() - ログインリファラー設定
    │
    ├─ Zend_Registry::getInstance() - レジストリ取得
    │
    ├─ $registry->db->select() - SQLクエリ構築
    │      ├─ from('events')
    │      ├─ join('events_venues')
    │      ├─ join('events_categories')
    │      ├─ where('event_status = published')
    │      ├─ where('event_date >= NOW()')
    │      └─ order('event_date ASC')
    │
    ├─ Zend_Paginator::factory($select) - ページネーター生成
    │
    └─ View rendering
           ├─ index.phtml
           │      ├─ RenderRotator('EventsIndex') - ローテーター
           │      ├─ Google Maps (JavaScript)
           │      │      └─ eventsmap.js
           │      ├─ partialLoop('_partials/eventlist.phtml')
           │      │      └─ EDate() - 日付フォーマット
           │      └─ paginationControl()
           │             └─ _pagination/default.phtml
           └─ events.phtml (layout)
```

### データフロー図

```
[入力]                    [処理]                           [出力]

URLパラメータ
  └─ page(ページ番号) ──▶ EventsController::indexAction()
                              │
                              ▼
                    Zend_Db_Select (クエリ構築)
                    event_date >= NOW()
                              │
                              ▼
                    ┌─────────────────────┐
                    │     Database        │
                    │  ├─ events          │
                    │  ├─ events_venues   │
                    │  └─ events_categories │
                    └─────────────────────┘
                              │
                              ▼
                    Zend_Paginator (ページ分割)
                              │
                              ▼
                    View (index.phtml)
                              │
            ┌─────────────────┴─────────────────┐
            ▼                                   ▼
    ┌──────────────┐                   ┌──────────────┐
    │ ローテーター  │                   │ Google Map   │
    │ (画像スライダー)│                   │ (会場マーカー) │
    └──────────────┘                   └──────────────┘
                              │
                              ▼
                    ┌─────────────────────┐
                    │   HTML Response     │
                    │  ├─ イベント一覧     │
                    │  └─ ページネーション  │
                    └─────────────────────┘
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| EventsController.php | `application/modules/default/controllers/EventsController.php` | コントローラー | イベント関連アクションの制御 |
| index.phtml | `application/modules/default/views/scripts/events/index.phtml` | ビュー | イベント一覧画面のメインテンプレート |
| eventlist.phtml | `application/modules/default/views/scripts/_partials/eventlist.phtml` | パーシャル | 個別イベントの表示テンプレート |
| default.phtml | `application/modules/default/views/scripts/_pagination/default.phtml` | パーシャル | ページネーションコンポーネント |
| info.phtml | `application/modules/default/views/scripts/_partials/info.phtml` | パーシャル | 情報メッセージ表示 |
| events.phtml | `application/layouts/scripts/events.phtml` | レイアウト | イベントセクション用レイアウト |
| events.ini | `application/configs/events.ini` | 設定 | イベントモジュールの設定ファイル |
| eventsmap.js | `_scripts/default/eventsmap.js` | JavaScript | 地図表示用スクリプト |
| events.js | `_scripts/default/events.js` | JavaScript | イベント機能用スクリプト |
| infobox_packed.js | `_scripts/gmaps/infobox_packed.js` | JavaScript | Google Maps InfoBox拡張 |
| EDate.php | `library/CMS/View/Helper/EDate.php` | ヘルパー | イベント日付フォーマット |
| RenderRotator.php | `library/CMS/View/Helper/RenderRotator.php` | ヘルパー | ローテーター生成 |
