# 画面設計書 17-カレンダー画面

## 概要

本ドキュメントは、Legacy CMSのカレンダー画面の設計を記載する。

### 本画面の処理概要

カレンダー画面は、特定の日付または月に開催されるイベントを一覧形式で表示する画面である。サイト訪問者は、この画面を通じて日付を指定してイベントを検索することができる。

**業務上の目的・背景**：
イベント探索において、日付による検索は最も直感的なナビゲーション方法の一つである。「特定の日に何があるか」「今月のイベントは何か」といったニーズに対応する。本画面はカレンダーUIからの遷移先として機能し、時間軸でのイベント検索を実現する。

**画面へのアクセス方法**：
- サイドバーのカレンダーウィジェットから日付をクリック
- イベント一覧画面からカレンダーリンクをクリック
- URL直接入力: `/events/calendar/{year}/{month}/{day}/` または `/events/calendar/{year}/{month}/` または `/events/calendar/{year}/`

**主要な操作・処理内容**：
1. 年・月・日パラメータを受け取り、該当期間のイベントを取得
2. ページネーションを用いてイベント一覧を表示
3. 各イベントの詳細画面への遷移

**画面遷移**：
- 遷移元: サイドバーカレンダー、イベント一覧画面
- 遷移先: イベント詳細画面

**権限による表示制御**：
特になし。全ユーザー（匿名ユーザー含む）がアクセス可能。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 21 | イベント一覧表示 | 主機能 | 月別カレンダー形式でイベントを表示 |

## 画面種別

一覧

## URL/ルーティング

| パス | HTTPメソッド | アクション |
|------|--------------|------------|
| `/events/calendar/{year}/` | GET | calendarAction（年指定） |
| `/events/calendar/{year}/{month}/` | GET | calendarAction（年月指定） |
| `/events/calendar/{year}/{month}/{day}/` | GET | calendarAction（年月日指定） |
| `/events/calendar/{year}/{month}/{day}/page/{page}/` | GET | calendarAction（年月日・ページ指定） |

## 入出力項目

### 入力項目（URLパラメータ）

| 項目名 | パラメータ名 | 型 | 必須 | 説明 |
|--------|-------------|-----|------|------|
| 年 | year | integer | Yes | 4桁の西暦年 |
| 月 | month | integer | No | 1-12の月 |
| 日 | day | integer | No | 1-31の日 |
| ページ番号 | page | integer | No | ページネーションのページ番号（デフォルト: 1） |

## 表示項目

### カレンダー見出し

| 項目名 | データソース | 説明 |
|--------|-------------|------|
| カレンダー見出し | $this->day, $this->month, $this->year | 「Calendar: {日} {月名} {年}」形式で表示 |

### イベント一覧

| 項目名 | データソース | 説明 |
|--------|-------------|------|
| イベント名 | event_title | イベント詳細画面へのリンク付き |
| カテゴリ | ecat_title | カテゴリ名を表示 |
| 会場名 | venue_title | venue_id != 1 の場合のみ表示 |
| 会場都市 | venue_city | venue_id != 1 の場合のみ表示 |
| 開催日時 | event_date, event_end | EDateヘルパーでフォーマット |

### ページネーション

| 項目名 | 説明 |
|--------|------|
| 現在ページ/総ページ | 「Page X of Y」形式 |
| 前へリンク | 前ページがある場合のみ活性化 |
| ページ番号リンク | ページ範囲内の番号を表示 |
| 次へリンク | 次ページがある場合のみ活性化 |

## イベント仕様

### 1-イベント行クリック

イベント行をクリックすると、該当イベントの詳細画面に遷移する。

- 遷移先: `/events/event/{event_id}/{event_title}/`
- 実装: onclick="goTo()"でJavaScript経由

### 2-イベントリンククリック

イベント名リンクをクリックすると、該当イベントの詳細画面に遷移する。

- 遷移先: `/events/event/{event_id}/{event_title}/`

### 3-ページネーション操作

ページ番号や前へ/次へリンクをクリックすると、該当ページのイベント一覧を表示する。

- 遷移先: `/events/calendar/{year}/{month}/{day}/page/{page}/`

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 画面表示 | events | SELECT | 指定期間のイベントを取得 |
| 画面表示 | events_venues | SELECT | 会場情報を取得 |
| 画面表示 | events_categories | SELECT | イベントカテゴリ情報を取得 |

### テーブル別更新項目詳細

#### events（SELECT）

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | event_id | - | イベントID |
| SELECT | event_title | - | イベント名 |
| SELECT | event_date | dayofmonth(event_date) = {day} | 開催日（日指定時） |
| SELECT | event_date | month(event_date) = {month} | 開催日（月指定時） |
| SELECT | event_date | year(event_date) = {year} | 開催日（年指定時） |
| SELECT | event_end | - | 終了日 |
| SELECT | event_status | event_status = 'published' | 公開ステータス |

#### events_venues（SELECT）

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | venue_id | - | 会場ID |
| SELECT | venue_title | - | 会場名 |
| SELECT | venue_city | - | 会場都市 |

#### events_categories（SELECT）

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | ecat_title | - | カテゴリ名 |

## メッセージ仕様

| メッセージID | 種別 | メッセージ | 表示条件 |
|-------------|------|----------|---------|
| MSG001 | 情報 | No events to display at the moment | イベントが0件の場合 |

## 例外処理

| 例外 | 処理 |
|------|------|
| 年パラメータ未指定 | 404エラー画面へフォワード |
| 該当期間のイベントがない | 空の一覧を表示（MSG001を表示） |

## 備考

- イベントは開催日（event_date）の昇順でソートされる
- venue_id = 1 は「会場未設定」を示すため、会場情報は表示されない
- 月名はgetdate()関数で英語表記を取得
- 年のみ指定、年月指定、年月日指定の3パターンをサポート

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、イベントデータの構造を理解することが重要である。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | events テーブル | DB Schema | event_date カラムの日時型、年月日抽出に使用 |
| 1-2 | events_venues テーブル | DB Schema | venue_id, venue_title, venue_city |
| 1-3 | events_categories テーブル | DB Schema | ecat_id, ecat_title |

**読解のコツ**: MySQLのyear(), month(), dayofmonth()関数を使用した日付フィルタリングに注目。

#### Step 2: エントリーポイントを理解する

処理の起点となるコントローラーアクションを特定する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | EventsController.php | `application/modules/default/controllers/EventsController.php` | calendarActionメソッドがエントリーポイント |

**主要処理フロー**:
1. **65行目**: calendarAction()メソッド開始
2. **72-76行目**: URLパラメータからyear, month, dayを取得
3. **78-83行目**: ページ番号の取得とデフォルト値設定
4. **85行目**: 年月日全て指定の場合の分岐
5. **86-87行目**: mktime, getdateで日付情報を構築
6. **91-99行目**: SQLクエリ構築（year, month, dayofmonth条件追加）
7. **101-108行目**: Zend_Paginatorでページネーション設定
8. **109行目**: 年月指定の場合の分岐
9. **131行目**: 年のみ指定の場合の分岐
10. **151-154行目**: パラメータ未指定時の404エラー処理

#### Step 3: ビューテンプレートを理解する

表示処理を担当するビューファイルを読み解く。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | calendar.phtml | `application/modules/default/views/scripts/events/calendar.phtml` | メインテンプレート |
| 3-2 | eventlist.phtml | `application/modules/default/views/scripts/_partials/eventlist.phtml` | 個別イベントの表示テンプレート |
| 3-3 | default.phtml | `application/modules/default/views/scripts/_pagination/default.phtml` | ページネーション表示 |

**主要処理フロー**:
- **calendar.phtml 29行目**: カレンダー見出しの表示（Calendar: {day} {month} {year}）
- **calendar.phtml 33-49行目**: イベント存在チェックと条件分岐
- **calendar.phtml 37行目**: partialLoopでeventlist.phtmlを呼び出し
- **calendar.phtml 43行目**: paginationControlでページネーション表示

### プログラム呼び出し階層図

```
calendarAction() [EventsController.php:65]
    │
    ├─ setRefer() - ログインリファラー設定
    │
    ├─ 日付パラメータ取得
    │      ├─ getParam('year')
    │      ├─ getParam('month')
    │      └─ getParam('day')
    │
    ├─ mktime() / getdate() - 日付情報構築
    │
    ├─ Zend_Registry::getInstance() - レジストリ取得
    │
    ├─ $registry->db->select() - SQLクエリ構築
    │      ├─ from('events')
    │      ├─ join('events_venues')
    │      ├─ join('events_categories')
    │      ├─ where('event_status = published')
    │      ├─ where('year(event_date) = ?')
    │      ├─ where('month(event_date) = ?') [月指定時]
    │      ├─ where('dayofmonth(event_date) = ?') [日指定時]
    │      └─ order('event_date ASC')
    │
    ├─ Zend_Paginator::factory($select) - ページネーター生成
    │
    └─ View rendering
           ├─ calendar.phtml
           │      ├─ partialLoop('_partials/eventlist.phtml')
           │      │      └─ EDate() - 日付フォーマット
           │      └─ paginationControl()
           │             └─ _pagination/default.phtml
           └─ events.phtml (layout)
```

### データフロー図

```
[入力]                    [処理]                           [出力]

URLパラメータ
  ├─ year(年) ─────────▶ EventsController::calendarAction()
  ├─ month(月)                  │
  ├─ day(日)                    │
  └─ page(ページ番号)            │
                              ▼
                    mktime() / getdate()
                    (日付情報の変換)
                              │
                              ▼
                    Zend_Db_Select (クエリ構築)
                    year(), month(), dayofmonth() 関数使用
                              │
                              ▼
                    ┌─────────────────────┐
                    │     Database        │
                    │  ├─ events          │
                    │  ├─ events_venues   │
                    │  └─ events_categories │
                    └─────────────────────┘
                              │
                              ▼
                    Zend_Paginator (ページ分割)
                              │
                              ▼
                    View (calendar.phtml)
                              │
                              ▼
                    ┌─────────────────────┐
                    │   HTML Response     │
                    │  ├─ カレンダー見出し  │
                    │  ├─ イベント一覧     │
                    │  └─ ページネーション  │
                    └─────────────────────┘
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| EventsController.php | `application/modules/default/controllers/EventsController.php` | コントローラー | イベント関連アクションの制御 |
| calendar.phtml | `application/modules/default/views/scripts/events/calendar.phtml` | ビュー | カレンダー画面のメインテンプレート |
| eventlist.phtml | `application/modules/default/views/scripts/_partials/eventlist.phtml` | パーシャル | 個別イベントの表示テンプレート |
| default.phtml | `application/modules/default/views/scripts/_pagination/default.phtml` | パーシャル | ページネーションコンポーネント |
| info.phtml | `application/modules/default/views/scripts/_partials/info.phtml` | パーシャル | 情報メッセージ表示 |
| events.phtml | `application/layouts/scripts/events.phtml` | レイアウト | イベントセクション用レイアウト |
| events.ini | `application/configs/events.ini` | 設定 | イベントモジュールの設定ファイル |
| events.js | `_scripts/default/events.js` | JavaScript | イベント機能用スクリプト |
| EDate.php | `library/CMS/View/Helper/EDate.php` | ヘルパー | イベント日付フォーマット |
