# 画面設計書 18-イベント詳細画面

## 概要

本ドキュメントは、Legacy CMSのイベント詳細画面の設計を記載する。

### 本画面の処理概要

イベント詳細画面は、個別のイベントの全情報を表示し、コメント機能を提供する画面である。サイト訪問者は、この画面でイベントの詳細情報、会場情報、地図を確認し、コメントを投稿することができる。

**業務上の目的・背景**：
イベント管理において、イベントの詳細情報を正確に伝えることは参加者獲得の鍵となる。イベント名、日時、会場、説明だけでなく、会場の地図や連絡先情報を提供することで、参加者の利便性を高める。チケット購入リンクやイベント公式サイトへのリンクにより、コンバージョンを促進する。

**画面へのアクセス方法**：
- イベント一覧画面からイベントをクリック
- カテゴリ別・会場別イベント一覧からの遷移
- カレンダー画面からの遷移
- URL直接入力: `/events/event/{id}/{title}/`

**主要な操作・処理内容**：
1. イベントIDに基づいてイベントデータを取得・表示
2. 会場情報と地図の表示（会場設定時）
3. コメント一覧の表示（Ajax経由）
4. ログインユーザーによるコメント投稿
5. ソーシャルシェア機能（AddThis）の提供
6. チケット購入・イベント公式サイトへのリンク

**画面遷移**：
- 遷移元: イベント一覧画面、カテゴリ別イベント一覧、会場別イベント一覧、カレンダー画面
- 遷移先: カテゴリ別イベント一覧画面、会場別イベント一覧画面、外部サイト（チケット、公式サイト）、ログイン画面

**権限による表示制御**：
- コメント投稿: ログインユーザーかつgcommentnewロールを持つユーザーのみ
- コメント非投稿時: ログイン/登録への誘導メッセージ表示

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 21 | イベント一覧表示 | 主機能 | イベントの詳細内容を表示 |
| 49 | タグ一覧表示 | 補助機能 | イベントのタグを表示 |

## 画面種別

詳細

## URL/ルーティング

| パス | HTTPメソッド | アクション |
|------|--------------|------------|
| `/events/event/{id}/{title}/` | GET | eventAction（イベント表示） |
| `/events/event/{id}/{title}/` | POST | eventAction（コメント投稿） |

## 入出力項目

### 入力項目（URLパラメータ）

| 項目名 | パラメータ名 | 型 | 必須 | 説明 |
|--------|-------------|-----|------|------|
| イベントID | id | integer | Yes | イベントの一意識別子 |
| イベントタイトル | title | string | No | SEO用のURLフレンドリータイトル |

### 入力項目（POSTデータ - コメント投稿）

| 項目名 | パラメータ名 | 型 | 必須 | 説明 |
|--------|-------------|-----|------|------|
| コメント内容 | content | string | Yes | コメント本文（StripTags, StringTrimフィルタ適用） |

## 表示項目

### イベント情報

| 項目名 | データソース | 説明 |
|--------|-------------|------|
| イベント見出し | ecat_title, event_title, venue_title, venue_city | カテゴリ - イベント名, 会場名, 都市（会場設定時） |
| 開催日時 | event_date, event_end | EDateヘルパーでフォーマット |
| イベント説明 | event_description | HTML形式で表示 |
| コメントリンク | - | event_commentsが'Y'の場合のみ表示 |
| イベント公式サイト | event_url | 外部リンク（設定時のみ） |
| チケット購入リンク | event_tickets | 外部リンク（設定時のみ） |
| ソーシャルシェア | - | AddThisウィジェット |
| コメント数 | - | CCountヘルパーで取得 |
| カテゴリ | ecat_title | カテゴリ別イベント一覧へのリンク付き |

### 会場情報（venue_id != 1 の場合）

| 項目名 | データソース | 説明 |
|--------|-------------|------|
| 会場説明 | venue_description | HTML形式（設定時のみ） |
| Google Map | venue_latitude, venue_longitude | 会場位置を地図表示 |
| 会場名 | venue_title | 表形式で表示 |
| 住所 | venue_address | 表形式で表示 |
| 都市 | venue_city | 表形式で表示 |
| 国 | venue_country | 表形式で表示 |
| 電話番号 | venue_phone | 表形式（設定時のみ） |
| メールアドレス | venue_email | メールリンク形式（設定時のみ） |
| 会場公式サイト | venue_url | 外部リンク（設定時のみ） |

### コメントセクション

| 項目名 | データソース | 説明 |
|--------|-------------|------|
| コメント一覧 | Ajax読み込み | dijit.layout.ContentPaneで非同期取得 |
| コメントフォーム | - | event_commentsが'Y'の場合のみ表示 |

## イベント仕様

### 1-カテゴリリンククリック

カテゴリ名をクリックすると、該当カテゴリのイベント一覧画面に遷移する。

- 遷移先: `/events/category/{ecat_title}/`

### 2-イベント公式サイトリンククリック

イベント公式サイトリンクをクリックすると、外部サイトに遷移する。

- 遷移先: event_url（外部リンク、新しいタブで開く）
- 条件: event_urlが設定されている場合のみ表示

### 3-チケット購入リンククリック

チケット購入リンクをクリックすると、外部サイトに遷移する。

- 遷移先: event_tickets（外部リンク、新しいタブで開く）
- 条件: event_ticketsが設定されている場合のみ表示

### 4-コメント投稿ボタン押下

フォームからコメントを投稿する。

- 前提条件: ユーザーがログイン済み、gcommentnewロールを持っている
- 処理: POSTデータのバリデーション後、commentsテーブルにINSERT
- 成功時: コメントが登録され、ページがリロードされる
- 失敗時: エラーメッセージを表示

### 5-コメント一覧読み込み

ページ読み込み時にAjaxでコメント一覧を取得する。

- 取得先: `/comments/comments/type/E/slave/{event_id}/`
- 表示: dijit.layout.ContentPane内に表示

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 画面表示 | events | SELECT | イベントデータを取得 |
| 画面表示 | events_venues | SELECT | 会場情報を取得 |
| 画面表示 | events_categories | SELECT | カテゴリ情報を取得 |
| コメント投稿 | comments | INSERT | 新規コメントを登録 |

### テーブル別更新項目詳細

#### events（SELECT）

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | event_id | WHERE event_id = {id} | イベントID |
| SELECT | event_title | - | イベント名 |
| SELECT | event_date | - | 開催日 |
| SELECT | event_end | - | 終了日 |
| SELECT | event_description | - | イベント説明 |
| SELECT | event_url | - | 公式サイトURL |
| SELECT | event_tickets | - | チケット購入URL |
| SELECT | event_status | event_status = 'published' | 公開ステータス |
| SELECT | event_comments | - | コメント許可フラグ |
| SELECT | event_moderate | - | コメント承認制フラグ |

#### events_venues（SELECT）

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | venue_id | - | 会場ID |
| SELECT | venue_title | - | 会場名 |
| SELECT | venue_address | - | 住所 |
| SELECT | venue_city | - | 都市 |
| SELECT | venue_country | - | 国 |
| SELECT | venue_phone | - | 電話番号 |
| SELECT | venue_email | - | メールアドレス |
| SELECT | venue_url | - | 会場公式サイト |
| SELECT | venue_description | - | 会場説明 |
| SELECT | venue_latitude | - | 緯度 |
| SELECT | venue_longitude | - | 経度 |

#### events_categories（SELECT）

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | ecat_title | - | カテゴリ名 |

#### comments（INSERT）

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| INSERT | comment_type | 'E' | コメント種別（イベント） |
| INSERT | comment_slave | {event_id} | 関連イベントID |
| INSERT | comment_approved | 'Y' or 'N' | 承認ステータス |
| INSERT | comment_content | POSTデータ | コメント本文 |
| INSERT | comment_user | ログインユーザーID | 投稿者ID |
| INSERT | comment_date | NOW() | 投稿日時 |

## メッセージ仕様

| メッセージID | 種別 | メッセージ | 表示条件 |
|-------------|------|----------|---------|
| MSG001 | エラー | You did not enter a comment | コメント内容が空の場合 |
| MSG002 | 情報 | Comment moderation is enabled | event_moderateが'Y'の場合 |
| MSG003 | 情報 | Please login or register to post a comment | 未ログインユーザーの場合 |
| MSG004 | 情報 | You don't have permission to post a comment | 権限がない場合 |
| MSG005 | 情報 | You must have JavaScript enabled to view comments. | JavaScript無効時 |
| MSG006 | 情報 | This map requires JavaScript. Your browser either doesn't support JavaScript or you have it disabled. | 地図表示でJavaScript無効時 |

## 例外処理

| 例外 | 処理 |
|------|------|
| イベントID未指定 | 404エラー画面へフォワード |
| 該当イベントが存在しない | 404エラー画面へフォワード |
| イベントが非公開ステータス | 404エラー画面へフォワード |
| コメントバリデーション失敗 | エラーメッセージを表示し、入力内容を保持 |

## 備考

- venue_id = 1 は「会場未設定」を示すため、会場情報と地図は表示されない
- コメント一覧はAjaxで非同期読み込みされるため、JavaScript無効時は閲覧不可のメッセージが表示される
- 地図表示にはGoogle Maps APIとeventsvenue.jsに依存
- AddThisによるソーシャルシェア機能は外部スクリプトに依存

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、イベントデータと会場データの構造を理解することが重要である。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | events テーブル | DB Schema | event_venue（会場FK）, event_comments, event_moderate の役割 |
| 1-2 | events_venues テーブル | DB Schema | 会場の全属性（住所、緯度経度など） |
| 1-3 | comments テーブル | DB Schema | comment_type = 'E' でイベントコメントを識別 |

**読解のコツ**: venue_id = 1 が特殊値（会場未設定）であることに注目。

#### Step 2: エントリーポイントを理解する

処理の起点となるコントローラーアクションを特定する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | EventsController.php | `application/modules/default/controllers/EventsController.php` | eventActionメソッドがエントリーポイント |

**主要処理フロー**:
1. **160行目**: eventAction()メソッド開始
2. **165行目**: setRefer()でログイン後のリダイレクト先を設定
3. **167行目**: URLパラメータからイベントIDを取得
4. **169行目**: イベントID存在チェック
5. **171-177行目**: SQLクエリ構築（events, events_venues, events_categoriesのJOIN）
6. **180-182行目**: イベント存在チェックとビューへの受け渡し
7. **186行目**: POSTリクエストチェック（コメント投稿処理）
8. **188-236行目**: コメント投稿処理（バリデーション、DB INSERT）

#### Step 3: ビューテンプレートを理解する

表示処理を担当するビューファイルを読み解く。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | event.phtml | `application/modules/default/views/scripts/events/event.phtml` | メインテンプレート |
| 3-2 | commentform.phtml | `application/modules/default/views/scripts/_partials/commentform.phtml` | コメント投稿フォーム |

**主要処理フロー**:
- **event.phtml 9-37行目**: 会場有無によるJavaScript変数設定（地図用）
- **event.phtml 52行目**: イベント見出し表示
- **event.phtml 59行目**: 開催日時表示（EDateヘルパー）
- **event.phtml 61行目**: イベント説明表示
- **event.phtml 67-72行目**: 外部リンク（公式サイト、チケット）
- **event.phtml 86行目**: カテゴリリンク
- **event.phtml 93-140行目**: 会場情報と地図（venue_id != 1 時）
- **event.phtml 150行目**: Ajax経由のコメント一覧読み込み
- **event.phtml 158-165行目**: コメントフォーム

### プログラム呼び出し階層図

```
eventAction() [EventsController.php:160]
    │
    ├─ setRefer() - ログインリファラー設定
    │
    ├─ Zend_Registry::getInstance() - レジストリ取得
    │
    ├─ $registry->db->select() - SQLクエリ構築
    │      ├─ from('events')
    │      ├─ join('events_venues')
    │      ├─ join('events_categories')
    │      ├─ where('event_status = published')
    │      ├─ where('event_id = ?')
    │      └─ limit(1,0)
    │
    ├─ [POST時] Zend_Filter_Input - コメントバリデーション
    │      ├─ filters: StringTrim, StripTags
    │      └─ validators: NotEmpty
    │
    ├─ [POST成功時] $registry->db->insert('comments', $data)
    │
    └─ View rendering
           ├─ event.phtml
           │      ├─ EDate() - 日付フォーマット
           │      ├─ CCount() - コメント数
           │      ├─ Google Map (JavaScript)
           │      │      └─ eventsvenue.js
           │      ├─ dijit.layout.ContentPane (Ajax)
           │      │      └─ /comments/comments/type/E/slave/{id}/
           │      └─ partial('_partials/commentform.phtml')
           │             └─ RenderMessages() - エラーメッセージ
           └─ events.phtml (layout)
```

### データフロー図

```
[入力]                    [処理]                           [出力]

URLパラメータ
  └─ id(イベントID) ───▶ EventsController::eventAction()
                              │
                              ▼
                    Zend_Db_Select (クエリ構築)
                              │
                              ▼
                    ┌─────────────────────┐
                    │     Database        │
                    │  ├─ events          │
                    │  ├─ events_venues   │
                    │  └─ events_categories │
                    └─────────────────────┘
                              │
                              ▼
                    View (event.phtml)
                              │
            ┌─────────────────┴─────────────────┐
            ▼                                   ▼
    ┌──────────────┐                   ┌──────────────┐
    │ イベント情報  │                   │ 会場情報     │
    │ ├─ タイトル  │                   │ ├─ 詳細      │
    │ ├─ 日時     │                   │ ├─ 地図      │
    │ └─ 説明     │                   │ └─ 連絡先    │
    └──────────────┘                   └──────────────┘
                              │
                              ▼
                    ┌──────────────────────┐
                    │     コメント        │
                    │  ├─ Ajax読み込み    │
                    │  └─ 投稿フォーム    │
                    └──────────────────────┘
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| EventsController.php | `application/modules/default/controllers/EventsController.php` | コントローラー | イベント関連アクションの制御 |
| event.phtml | `application/modules/default/views/scripts/events/event.phtml` | ビュー | イベント詳細画面のメインテンプレート |
| commentform.phtml | `application/modules/default/views/scripts/_partials/commentform.phtml` | パーシャル | コメント投稿フォーム |
| events.phtml | `application/layouts/scripts/events.phtml` | レイアウト | イベントセクション用レイアウト |
| events.ini | `application/configs/events.ini` | 設定 | イベントモジュールの設定ファイル |
| eventsvenue.js | `_scripts/default/eventsvenue.js` | JavaScript | 単一会場地図表示用スクリプト |
| events.js | `_scripts/default/events.js` | JavaScript | イベント機能用スクリプト |
| EDate.php | `library/CMS/View/Helper/EDate.php` | ヘルパー | イベント日付フォーマット |
| CCount.php | `library/CMS/View/Helper/CCount.php` | ヘルパー | コメント数取得 |
| RenderMessages.php | `library/CMS/View/Helper/RenderMessages.php` | ヘルパー | エラーメッセージ表示 |
