# 画面設計書 19-カテゴリ別イベント一覧画面

## 概要

本ドキュメントは、Legacy CMSのカテゴリ別イベント一覧画面の設計を記載する。

### 本画面の処理概要

カテゴリ別イベント一覧画面は、特定のカテゴリに属するイベントを一覧形式で表示する画面である。サイト訪問者は、この画面を通じて興味のあるイベントカテゴリ（音楽、スポーツ、文化など）のイベントをまとめて閲覧することができる。

**業務上の目的・背景**：
イベントをカテゴリ別に分類することで、訪問者は自分の興味に合ったイベントを効率的に探すことができる。カテゴリ説明文の表示により、そのカテゴリの特徴や対象イベントについての情報を提供し、ユーザーの理解を助ける。

**画面へのアクセス方法**：
- イベント詳細画面からカテゴリリンクをクリック
- サイドバーのカテゴリ一覧からクリック
- URL直接入力: `/events/category/{category}/`

**主要な操作・処理内容**：
1. カテゴリ名パラメータを受け取り、該当カテゴリの情報と今後のイベントを取得
2. カテゴリ説明文の表示（最初のページのみ）
3. ページネーションを用いてイベント一覧を表示
4. 各イベントの詳細画面への遷移

**画面遷移**：
- 遷移元: イベント詳細画面、サイドバー、イベント一覧画面
- 遷移先: イベント詳細画面

**権限による表示制御**：
特になし。全ユーザー（匿名ユーザー含む）がアクセス可能。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 21 | イベント一覧表示 | 主機能 | カテゴリでフィルタしたイベントを表示 |
| 26 | イベントカテゴリ管理 | 補助機能 | カテゴリ情報の取得 |
| 62 | ページネーション | 補助機能 | イベント一覧のページ送り処理 |

## 画面種別

一覧

## URL/ルーティング

| パス | HTTPメソッド | アクション |
|------|--------------|------------|
| `/events/category/{category}/` | GET | categoryAction |
| `/events/category/{category}/page/{page}/` | GET | categoryAction（ページ指定） |

## 入出力項目

### 入力項目（URLパラメータ）

| 項目名 | パラメータ名 | 型 | 必須 | 説明 |
|--------|-------------|-----|------|------|
| カテゴリ名 | category | string | Yes | カテゴリタイトル（URLエンコード） |
| ページ番号 | page | integer | No | ページネーションのページ番号（デフォルト: 1） |

## 表示項目

### カテゴリ情報

| 項目名 | データソース | 説明 |
|--------|-------------|------|
| カテゴリ見出し | ecat_title | 「Category: {カテゴリ名}」形式で表示 |
| カテゴリ説明 | ecat_content | HTML形式（1ページ目かつ設定時のみ表示） |

### イベント一覧

| 項目名 | データソース | 説明 |
|--------|-------------|------|
| イベント名 | event_title | イベント詳細画面へのリンク付き |
| カテゴリ | ecat_title | カテゴリ名を表示 |
| 会場名 | venue_title | venue_id != 1 の場合のみ表示 |
| 会場都市 | venue_city | venue_id != 1 の場合のみ表示 |
| 開催日時 | event_date, event_end | EDateヘルパーでフォーマット |

### ページネーション

| 項目名 | 説明 |
|--------|------|
| 現在ページ/総ページ | 「Page X of Y」形式 |
| 前へリンク | 前ページがある場合のみ活性化 |
| ページ番号リンク | ページ範囲内の番号を表示 |
| 次へリンク | 次ページがある場合のみ活性化 |

## イベント仕様

### 1-イベント行クリック

イベント行をクリックすると、該当イベントの詳細画面に遷移する。

- 遷移先: `/events/event/{event_id}/{event_title}/`
- 実装: onclick="goTo()"でJavaScript経由

### 2-イベントリンククリック

イベント名リンクをクリックすると、該当イベントの詳細画面に遷移する。

- 遷移先: `/events/event/{event_id}/{event_title}/`

### 3-ページネーション操作

ページ番号や前へ/次へリンクをクリックすると、該当ページのイベント一覧を表示する。

- 遷移先: `/events/category/{category}/page/{page}/`

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 画面表示 | events_categories | SELECT | カテゴリ情報を取得 |
| 画面表示 | events | SELECT | カテゴリに属する今後のイベントを取得 |
| 画面表示 | events_venues | SELECT | 会場情報を取得 |

### テーブル別更新項目詳細

#### events_categories（SELECT）

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | ecat_id | - | カテゴリID |
| SELECT | ecat_title | ecat_title = {category} | カテゴリ名 |
| SELECT | ecat_content | - | カテゴリ説明 |

#### events（SELECT）

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | event_id | - | イベントID |
| SELECT | event_title | - | イベント名 |
| SELECT | event_date | event_date >= NOW() | 開催日（今日以降） |
| SELECT | event_end | - | 終了日 |
| SELECT | event_status | event_status = 'published' | 公開ステータス |
| SELECT | event_category | event_category = {ecat_id} | カテゴリによる絞り込み |

#### events_venues（SELECT）

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | venue_id | - | 会場ID |
| SELECT | venue_title | - | 会場名 |
| SELECT | venue_city | - | 会場都市 |

## メッセージ仕様

| メッセージID | 種別 | メッセージ | 表示条件 |
|-------------|------|----------|---------|
| MSG001 | 情報 | No events to display at the moment | イベントが0件の場合 |

## 例外処理

| 例外 | 処理 |
|------|------|
| カテゴリパラメータ未指定 | 404エラー画面へフォワード |
| 該当カテゴリが存在しない | 404エラー画面へフォワード |
| 該当カテゴリのイベントがない | 空の一覧を表示（MSG001を表示） |

## 備考

- イベントは開催日（event_date）の昇順でソートされる（近い日程が先頭）
- venue_id = 1 は「会場未設定」を示すため、会場情報は表示されない
- カテゴリ説明文は1ページ目のみ表示され、2ページ目以降は非表示
- カテゴリ名はURLエンコードされた状態でパラメータとして受け取り、urldecodeで復元する

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、イベントカテゴリとイベントの関連構造を理解することが重要である。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | events_categories テーブル | DB Schema | ecat_id, ecat_title, ecat_content の役割 |
| 1-2 | events テーブル | DB Schema | event_category（FK）との紐付け |
| 1-3 | events_venues テーブル | DB Schema | venue_id, venue_title, venue_city |

**読解のコツ**: events.event_category が events_categories.ecat_id と紐づく。

#### Step 2: エントリーポイントを理解する

処理の起点となるコントローラーアクションを特定する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | EventsController.php | `application/modules/default/controllers/EventsController.php` | categoryActionメソッドがエントリーポイント |

**主要処理フロー**:
1. **259行目**: categoryAction()メソッド開始
2. **264行目**: setRefer()でログイン後のリダイレクト先を設定
3. **266行目**: URLパラメータからカテゴリ名を取得（urldecodeで復元）
4. **268-273行目**: ページ番号の取得とデフォルト値設定
5. **275行目**: カテゴリ名存在チェック
6. **278-281行目**: カテゴリ情報取得クエリ
7. **284行目**: カテゴリ取得結果チェック
8. **289行目**: ビューにカテゴリ情報を渡す
9. **291行目**: カテゴリIDを取得
10. **293-300行目**: イベント取得クエリ（カテゴリIDで絞り込み）
11. **302-306行目**: Zend_Paginatorでページネーション設定

#### Step 3: ビューテンプレートを理解する

表示処理を担当するビューファイルを読み解く。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | category.phtml | `application/modules/default/views/scripts/events/category.phtml` | メインテンプレート |
| 3-2 | eventlist.phtml | `application/modules/default/views/scripts/_partials/eventlist.phtml` | 個別イベントの表示テンプレート |
| 3-3 | default.phtml | `application/modules/default/views/scripts/_pagination/default.phtml` | ページネーション表示 |

**主要処理フロー**:
- **category.phtml 29行目**: カテゴリ見出しの表示
- **category.phtml 32-40行目**: 1ページ目かつカテゴリ説明がある場合の表示
- **category.phtml 41-57行目**: イベント存在チェックと条件分岐
- **category.phtml 45行目**: partialLoopでeventlist.phtmlを呼び出し
- **category.phtml 51行目**: paginationControlでページネーション表示

### プログラム呼び出し階層図

```
categoryAction() [EventsController.php:259]
    │
    ├─ setRefer() - ログインリファラー設定
    │
    ├─ urldecode() - カテゴリ名デコード
    │
    ├─ Zend_Registry::getInstance() - レジストリ取得
    │
    ├─ [カテゴリ取得] $registry->db->select()
    │      ├─ from('events_categories')
    │      ├─ where('ecat_title = ?')
    │      └─ limit(1,0)
    │
    ├─ [イベント取得] $registry->db->select()
    │      ├─ from('events')
    │      ├─ join('events_venues')
    │      ├─ join('events_categories')
    │      ├─ where('event_status = published')
    │      ├─ where('event_date >= NOW()')
    │      ├─ where('event_category = ?')
    │      └─ order('event_date ASC')
    │
    ├─ Zend_Paginator::factory($select) - ページネーター生成
    │
    └─ View rendering
           ├─ category.phtml
           │      ├─ カテゴリ説明（1ページ目のみ）
           │      ├─ partialLoop('_partials/eventlist.phtml')
           │      │      └─ EDate() - 日付フォーマット
           │      └─ paginationControl()
           │             └─ _pagination/default.phtml
           └─ events.phtml (layout)
```

### データフロー図

```
[入力]                    [処理]                           [出力]

URLパラメータ
  ├─ category(カテゴリ名) ─▶ EventsController::categoryAction()
  └─ page(ページ番号)            │
                              ▼
                    urldecode() - カテゴリ名復元
                              │
            ┌─────────────────┴─────────────────┐
            ▼                                   ▼
    [カテゴリ情報取得]                    [イベント一覧取得]
    events_categories                    events + venues
            │                                   │
            └─────────────────┬─────────────────┘
                              │
                              ▼
                    Zend_Paginator (ページ分割)
                              │
                              ▼
                    View (category.phtml)
                              │
                              ▼
                    ┌─────────────────────┐
                    │   HTML Response     │
                    │  ├─ カテゴリ見出し   │
                    │  ├─ カテゴリ説明（1p）│
                    │  ├─ イベント一覧     │
                    │  └─ ページネーション  │
                    └─────────────────────┘
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| EventsController.php | `application/modules/default/controllers/EventsController.php` | コントローラー | イベント関連アクションの制御 |
| category.phtml | `application/modules/default/views/scripts/events/category.phtml` | ビュー | カテゴリ別イベント一覧画面のメインテンプレート |
| eventlist.phtml | `application/modules/default/views/scripts/_partials/eventlist.phtml` | パーシャル | 個別イベントの表示テンプレート |
| default.phtml | `application/modules/default/views/scripts/_pagination/default.phtml` | パーシャル | ページネーションコンポーネント |
| info.phtml | `application/modules/default/views/scripts/_partials/info.phtml` | パーシャル | 情報メッセージ表示 |
| events.phtml | `application/layouts/scripts/events.phtml` | レイアウト | イベントセクション用レイアウト |
| events.ini | `application/configs/events.ini` | 設定 | イベントモジュールの設定ファイル |
| events.js | `_scripts/default/events.js` | JavaScript | イベント機能用スクリプト |
| EDate.php | `library/CMS/View/Helper/EDate.php` | ヘルパー | イベント日付フォーマット |
