# 画面設計書 2-タグ一覧画面

## 概要

本ドキュメントは、Legacy CMSのフロントエンド公開サイトにおけるタグ一覧画面の設計仕様を定義する。サイト内で使用されている全タグをクラウド形式で表示し、関連コンテンツへのナビゲーションを提供する。

### 本画面の処理概要

**業務上の目的・背景**：タグ一覧画面は、サイト内のコンテンツを横断的に閲覧するためのナビゲーション機能を提供する。ユーザーは興味のあるトピックのタグを選択することで、関連する記事やページに効率的にアクセスできる。これにより、コンテンツの発見性を高め、サイト内の回遊率向上を実現する。タグはコンテンツの分類・検索という業務課題を解決する重要な機能である。

**画面へのアクセス方法**：ホーム画面のタグリンク、またはナビゲーションメニューからアクセス。URLは`/index/tags`または`/tags/`。

**主要な操作・処理内容**：
1. サイト全体のタグをタグクラウド形式で表示（全タグ表示モード）
2. タブ切り替えによるカテゴリ別タグ表示（All / Blog / Pages）
3. 各タグの使用頻度に応じたフォントサイズの可変表示
4. タグクリックによる関連コンテンツ一覧への遷移
5. サイドバー検索ボックスからの全文検索
6. サイドバーローテーターによるビジュアルコンテンツ表示

**画面遷移**：
- 遷移元：ホーム画面、記事詳細画面、ページ詳細画面、グローバルナビゲーション
- 遷移先：タグ別記事一覧画面、タグ別ページ一覧画面、記事タグ一覧画面、ページタグ一覧画面、検索結果画面

**権限による表示制御**：
- 本画面は認証状態に関わらず同一の表示内容
- タグの表示は公開済みコンテンツに紐づくもののみ

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 49 | タグ一覧表示 | 主機能 | サイト内の全タグを一覧表示 |

## 画面種別

一覧（タグクラウド型）

## URL/ルーティング

- URL: `/tags/` または `/index/tags`
- コントローラー: `IndexController`
- アクション: `tagsAction`
- モジュール: `default`

## 入出力項目

| 項目名 | 入力/出力 | データ型 | 必須 | 説明 |
|--------|----------|---------|------|------|
| - | - | - | - | 本画面は入力項目なし |

## 表示項目

### タグクラウド

| 項目名 | データ型 | 表示形式 | 説明 |
|--------|---------|---------|------|
| tag_tag | string | リンク付きテキスト | タグ名 |
| count | int | フォントサイズ変動 | タグ使用回数（表示には反映されるが直接表示しない） |

### タブメニュー

| 項目名 | 説明 |
|--------|------|
| All | 全タグ表示（記事+ページ）- 本画面でアクティブ |
| Blog | 記事タグのみ（/articles/tags/へ遷移） |
| Pages | ページタグのみ（/pages/tags/へ遷移） |

### サイドバー

| 項目名 | 説明 |
|--------|------|
| 検索ボックス | サイト内検索フォーム |
| ローテーター | SideBarローテーター表示 |

## イベント仕様

### 1-タグクリック

タグクラウド内のタグをクリックすると、該当タグに関連するコンテンツ一覧へ遷移する。

- 遷移先: `/articles/tag/{tag_name}/`（記事の場合）
- 処理: TCloudヘルパーが生成するリンク経由

### 2-Blogタブクリック

「Blog」タブをクリックすると、記事専用のタグ一覧画面へ遷移する。

- 遷移先: `/articles/tags/`
- 処理: リンククリックによるページ遷移

### 3-Pagesタブクリック

「Pages」タブをクリックすると、ページ専用のタグ一覧画面へ遷移する。

- 遷移先: `/pages/tags/`
- 処理: リンククリックによるページ遷移

### 4-検索実行

検索ボックスにキーワードを入力して検索ボタンを押すと、検索結果画面へ遷移する。

- 遷移先: `/index/search?query={keyword}`

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 画面表示 | tags | SELECT | 全タグを集計取得（TCloudヘルパー経由） |

### テーブル別更新項目詳細

#### tags

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | tag_tag, COUNT(*) | tag_type IN ('A', 'P') | 記事・ページ両方のタグを集計 |

**備考**: TCount, ATagCount, PTagCountヘルパーでタグ件数を取得

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示条件 |
|-------------|------|---------------|---------|
| - | - | - | 特定のメッセージ表示なし |

## 例外処理

| 例外条件 | 処理内容 |
|---------|---------|
| データベース接続エラー | システムエラー画面へ遷移 |
| タグが存在しない場合 | 空のタグクラウドを表示（エラーにはならない） |

## 備考

- タグクラウドはTCloudビューヘルパーで生成される
- タグの件数表示にはTCount（全体）、ATagCount（記事）、PTagCount（ページ）ヘルパーを使用
- SideBarローテーターが右サイドバーに表示される

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、タグデータの構造を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | database.sql | `database.sql` | tagsテーブル（335-341行目）の構造。tag_type, tag_tag, tag_slaveカラム |

**読解のコツ**: tag_typeは'A'（Article）または'P'（Page）を示し、tag_slaveは関連コンテンツのIDを参照する。

#### Step 2: エントリーポイントを理解する

処理の起点となるコントローラーアクションを特定する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | IndexController.php | `application/modules/default/controllers/IndexController.php` | tagsAction()メソッド（55-58行目） |

**主要処理フロー**:
1. **57行目**: setRefer()でセッションに現在URLを保存
2. ビューテンプレートへ処理を委譲（データ取得はビューヘルパーで実行）

#### Step 3: ビューテンプレートを理解する

画面表示のロジックを追跡する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | tags.phtml | `application/modules/default/views/scripts/index/tags.phtml` | メインテンプレート。タブメニューとタグクラウドの配置 |

**主要処理フロー**:
- **32行目**: TCount('ALL','ALL')で全タグ件数を表示
- **33行目**: ATagCount('ALL')で記事タグ件数を表示
- **34行目**: PTagCount('ALL')でページタグ件数を表示
- **41行目**: TCloud('ALL','articles','ALL')でタグクラウドを生成

### プログラム呼び出し階層図

```
HTTP Request (/tags/)
    |
    +-- IndexController::preDispatch() [継承元: CMS_Controller_Action_Default]
    |       |
    |       +-- 認証状態確認
    |       +-- ACL構築
    |
    +-- IndexController::tagsAction()
            |
            +-- setRefer() - セッション保存
            +-- ビューレンダリング
                    |
                    +-- TCount() ヘルパー - 全タグ件数
                    +-- ATagCount() ヘルパー - 記事タグ件数
                    +-- PTagCount() ヘルパー - ページタグ件数
                    +-- TCloud() ヘルパー - タグクラウド生成
                    +-- RenderRotator() ヘルパー - ローテーター
```

### データフロー図

```
[入力]               [処理]                    [出力]

HTTPリクエスト  ───▶ IndexController      ───▶ tags.phtml
   (/tags/)           ::tagsAction()            |
                           |                    +──▶ TCloud()
                           |                    |     (タグクラウド生成)
                      ビューヘルパー            +──▶ TCount()
                           |                    |     (件数表示)
                           ▼                    +──▶ searchbox.phtml
                        tags                    +──▶ RenderRotator
                       テーブル                      (SideBar)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| IndexController.php | `application/modules/default/controllers/IndexController.php` | ソース | タグ一覧画面のコントローラー |
| tags.phtml | `application/modules/default/views/scripts/index/tags.phtml` | テンプレート | タグ一覧画面のメインビュー |
| searchbox.phtml | `application/modules/default/views/scripts/_partials/searchbox.phtml` | テンプレート | 検索ボックス |
| database.sql | `database.sql` | スキーマ | tagsテーブル定義 |
