# 画面設計書 20-会場別イベント一覧画面

## 概要

本ドキュメントは、Legacy CMSの会場別イベント一覧画面の設計を記載する。

### 本画面の処理概要

会場別イベント一覧画面は、特定の会場で開催される今後のイベントを一覧形式で表示する画面である。サイト訪問者は、この画面を通じて特定の会場で開催予定のイベントをまとめて確認でき、会場の詳細情報（住所、連絡先、地図）も同時に閲覧することができる。

**業務上の目的・背景**：
イベント会場ごとにイベントをまとめて表示することで、訪問者は特定の会場へ行く際に参加できるイベントを効率的に探すことができる。会場情報（地図、住所、連絡先）も表示されるため、来場計画を立てやすくなる。

**画面へのアクセス方法**：
- イベント詳細画面から会場リンクをクリック
- イベント一覧画面から会場リンクをクリック
- URL直接入力: `/events/venue/{id}/`

**主要な操作・処理内容**：
1. 会場IDパラメータを受け取り、該当会場の情報を取得
2. 会場に紐づく今後のイベント一覧を取得
3. 会場詳細情報（住所、電話、メール、URL）と地図の表示（1ページ目のみ）
4. ページネーションを用いてイベント一覧を表示
5. 各イベントの詳細画面への遷移

**画面遷移**：
- 遷移元: イベント詳細画面、イベント一覧画面
- 遷移先: イベント詳細画面、会場ウェブサイト（外部リンク）

**権限による表示制御**：
特になし。全ユーザー（匿名ユーザー含む）がアクセス可能。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 21 | イベント一覧表示 | 主機能 | 会場でフィルタしたイベントを表示 |
| 27 | イベント会場管理 | 補助機能 | 会場情報の取得 |
| 62 | ページネーション | 補助機能 | イベント一覧のページ送り処理 |

## 画面種別

一覧

## URL/ルーティング

| パス | HTTPメソッド | アクション |
|------|--------------|------------|
| `/events/venue/{id}/` | GET | venueAction |
| `/events/venue/{id}/page/{page}/` | GET | venueAction（ページ指定） |

## 入出力項目

### 入力項目（URLパラメータ）

| 項目名 | パラメータ名 | 型 | 必須 | 説明 |
|--------|-------------|-----|------|------|
| 会場ID | id | integer | Yes | events_venuesテーブルのvenue_id |
| ページ番号 | page | integer | No | ページネーションのページ番号（デフォルト: 1） |

## 表示項目

### 会場情報（1ページ目のみ表示）

| 項目名 | データソース | 説明 |
|--------|-------------|------|
| 会場見出し | venue_title | 「Venue: {会場名}」形式で表示 |
| 会場説明 | venue_description | HTML形式（1ページ目かつ設定時のみ表示） |
| 地図 | venue_latitude, venue_longitude | Google Mapsで会場位置を表示 |
| 会場名 | venue_title | 連絡先情報内に表示 |
| 住所 | venue_address | 会場の住所 |
| 市区町村 | venue_city | 会場の市区町村 |
| 国 | venue_country | 会場の国 |
| 電話番号 | venue_phone | 設定時のみ表示 |
| メールアドレス | venue_email | 設定時のみ、mailto:リンク付きで表示 |
| 会場URL | venue_url | 設定時のみ、外部リンクとして表示 |

### イベント一覧

| 項目名 | データソース | 説明 |
|--------|-------------|------|
| イベント名 | event_title | イベント詳細画面へのリンク付き |
| カテゴリ | ecat_title | カテゴリ名を表示 |
| 会場名 | venue_title | venue_id != 1 の場合のみ表示 |
| 会場都市 | venue_city | venue_id != 1 の場合のみ表示 |
| 開催日時 | event_date, event_end | EDateヘルパーでフォーマット |

### ページネーション

| 項目名 | 説明 |
|--------|------|
| 現在ページ/総ページ | 「Page X of Y」形式 |
| 前へリンク | 前ページがある場合のみ活性化 |
| ページ番号リンク | ページ範囲内の番号を表示 |
| 次へリンク | 次ページがある場合のみ活性化 |

## イベント仕様

### 1-イベント行クリック

イベント行をクリックすると、該当イベントの詳細画面に遷移する。

- 遷移先: `/events/event/{event_id}/{event_title}/`
- 実装: onclick="goTo()"でJavaScript経由

### 2-イベントリンククリック

イベント名リンクをクリックすると、該当イベントの詳細画面に遷移する。

- 遷移先: `/events/event/{event_id}/{event_title}/`

### 3-ページネーション操作

ページ番号や前へ/次へリンクをクリックすると、該当ページのイベント一覧を表示する。

- 遷移先: `/events/venue/{id}/page/{page}/`

### 4-会場URLクリック

会場URLリンクをクリックすると、会場の公式ウェブサイトを新しいタブで開く。

- 対象: target="_blank"属性
- 条件: venue_urlが設定されている場合のみ表示

### 5-会場メールリンククリック

メールアドレスリンクをクリックすると、メールクライアントが起動する。

- 遷移先: mailto:{venue_email}
- 条件: venue_emailが設定されている場合のみ表示

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 画面表示 | events_venues | SELECT | 会場情報を取得 |
| 画面表示 | events | SELECT | 会場に紐づく今後のイベントを取得 |
| 画面表示 | events_categories | SELECT | カテゴリ情報を取得 |

### テーブル別更新項目詳細

#### events_venues（SELECT）

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | venue_id | venue_id = {id} | 会場ID |
| SELECT | venue_title | - | 会場名 |
| SELECT | venue_description | - | 会場説明 |
| SELECT | venue_address | - | 住所 |
| SELECT | venue_city | - | 市区町村 |
| SELECT | venue_country | - | 国 |
| SELECT | venue_phone | - | 電話番号 |
| SELECT | venue_email | - | メールアドレス |
| SELECT | venue_url | - | 会場URL |
| SELECT | venue_latitude | - | 緯度（地図表示用） |
| SELECT | venue_longitude | - | 経度（地図表示用） |

#### events（SELECT）

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | event_id | - | イベントID |
| SELECT | event_title | - | イベント名 |
| SELECT | event_date | event_date >= NOW() | 開催日（今日以降） |
| SELECT | event_end | - | 終了日 |
| SELECT | event_status | event_status = 'published' | 公開ステータス |
| SELECT | event_venue | event_venue = {id} | 会場IDによる絞り込み |

#### events_categories（SELECT）

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | ecat_id | - | カテゴリID |
| SELECT | ecat_title | - | カテゴリ名 |

## メッセージ仕様

| メッセージID | 種別 | メッセージ | 表示条件 |
|-------------|------|----------|---------|
| MSG001 | 情報 | No events to display at the moment | イベントが0件の場合 |
| MSG002 | 情報 | This map requires JavaScript. Your browser either doesn't support JavaScript or you have it disabled. | JavaScript無効時 |

## 例外処理

| 例外 | 処理 |
|------|------|
| 会場IDパラメータ未指定 | 404エラー画面へフォワード |
| 該当会場が存在しない | 404エラー画面へフォワード |
| venue_id = 1（デフォルト会場） | 404エラー画面へフォワード |
| 該当会場のイベントがない | 空の一覧を表示（MSG001を表示） |

## 備考

- イベントは開催日（event_date）の昇順でソートされる（近い日程が先頭）
- venue_id = 1 は「会場未設定」を示す特別な値であり、この会場IDでのアクセスは404エラーとなる
- 会場説明文、地図、連絡先情報は1ページ目のみ表示され、2ページ目以降は非表示
- 地図表示にはGoogle Maps JavaScript APIを使用し、venue_latitude/venue_longitudeから位置を特定
- 会場の電話番号、メールアドレス、URLは設定されている場合のみ表示される

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、会場とイベントの関連構造を理解することが重要である。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | events_venues テーブル | DB Schema | venue_id, venue_title, venue_latitude, venue_longitude の役割 |
| 1-2 | events テーブル | DB Schema | event_venue（FK）との紐付け |
| 1-3 | events_categories テーブル | DB Schema | ecat_id, ecat_title |

**読解のコツ**: events.event_venue が events_venues.venue_id と紐づく。venue_id = 1 は特別な値（会場未設定）。

#### Step 2: エントリーポイントを理解する

処理の起点となるコントローラーアクションを特定する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | EventsController.php | `application/modules/default/controllers/EventsController.php` | venueActionメソッドがエントリーポイント |

**主要処理フロー**:
1. **327行目**: venueAction()メソッド開始
2. **333行目**: setRefer()でログイン後のリダイレクト先を設定
3. **335行目**: URLパラメータから会場IDを取得
4. **337-342行目**: ページ番号の取得とデフォルト値設定
5. **344行目**: 会場ID存在チェック
6. **347-350行目**: 会場情報取得クエリ
7. **355行目**: 会場存在チェックとvenue_id != 1の検証
8. **358行目**: ビューに会場情報を渡す
9. **360-367行目**: イベント取得クエリ（会場IDで絞り込み）
10. **370-373行目**: Zend_Paginatorでページネーション設定
11. **378-387行目**: エラー時の404フォワード処理

#### Step 3: ビューテンプレートを理解する

表示処理を担当するビューファイルを読み解く。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | venue.phtml | `application/modules/default/views/scripts/events/venue.phtml` | メインテンプレート |
| 3-2 | eventlist.phtml | `application/modules/default/views/scripts/_partials/eventlist.phtml` | 個別イベントの表示テンプレート |
| 3-3 | default.phtml | `application/modules/default/views/scripts/_pagination/default.phtml` | ページネーション表示 |

**主要処理フロー**:
- **venue.phtml 20-22行目**: 地図用JavaScript変数（vlat, vlng, vtitle）の設定
- **venue.phtml 37行目**: 会場見出しの表示
- **venue.phtml 40-84行目**: 1ページ目のみの会場詳細表示
- **venue.phtml 48-52行目**: 地図表示エリアとnoscript対応
- **venue.phtml 54-80行目**: 会場連絡先情報テーブル
- **venue.phtml 62-79行目**: 電話、メール、URLの条件付き表示
- **venue.phtml 89行目**: partialLoopでeventlist.phtmlを呼び出し
- **venue.phtml 95行目**: paginationControlでページネーション表示

### プログラム呼び出し階層図

```
venueAction() [EventsController.php:327]
    │
    ├─ setRefer() - ログインリファラー設定
    │
    ├─ getParam('id') - 会場ID取得
    │
    ├─ Zend_Registry::getInstance() - レジストリ取得
    │
    ├─ [会場取得] $registry->db->select()
    │      ├─ from('events_venues')
    │      ├─ where('venue_id = ?')
    │      └─ limit(1,0)
    │
    ├─ [会場存在 & venue_id != 1 チェック]
    │      │
    │      ├─ [TRUE] イベント取得処理
    │      │      ├─ from('events')
    │      │      ├─ join('events_venues')
    │      │      ├─ join('events_categories')
    │      │      ├─ where('event_status = published')
    │      │      ├─ where('event_date >= NOW()')
    │      │      ├─ where('event_venue = ?')
    │      │      └─ order('event_date ASC')
    │      │
    │      └─ [FALSE] _forward('notfound')
    │
    ├─ Zend_Paginator::factory($eselect) - ページネーター生成
    │
    └─ View rendering
           ├─ venue.phtml
           │      ├─ Google Maps 変数設定 (vlat, vlng, vtitle)
           │      ├─ 会場詳細（1ページ目のみ）
           │      │      ├─ 地図表示
           │      │      └─ 連絡先テーブル
           │      ├─ partialLoop('_partials/eventlist.phtml')
           │      │      └─ EDate() - 日付フォーマット
           │      └─ paginationControl()
           │             └─ _pagination/default.phtml
           └─ events.phtml (layout)
```

### データフロー図

```
[入力]                    [処理]                           [出力]

URLパラメータ
  ├─ id(会場ID) ─────────▶ EventsController::venueAction()
  └─ page(ページ番号)            │
                              ▼
                    [会場存在チェック]
                              │
            ┌────────────────┴────────────────┐
            │                                  │
      [存在 & id!=1]                    [不存在 or id=1]
            │                                  │
            ▼                                  ▼
    ┌───────────────────────┐          404 Error Forward
    │                       │
    ▼                       ▼
[会場情報取得]        [イベント一覧取得]
events_venues         events + venues + categories
    │                       │
    └───────────┬───────────┘
                │
                ▼
      Zend_Paginator (ページ分割)
                │
                ▼
      View (venue.phtml)
                │
                ▼
      ┌─────────────────────┐
      │   HTML Response     │
      │  ├─ 会場見出し       │
      │  ├─ 会場詳細（1p）   │
      │  │  ├─ 説明文       │
      │  │  ├─ 地図         │
      │  │  └─ 連絡先       │
      │  ├─ イベント一覧     │
      │  └─ ページネーション  │
      └─────────────────────┘
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| EventsController.php | `application/modules/default/controllers/EventsController.php` | コントローラー | イベント関連アクションの制御 |
| venue.phtml | `application/modules/default/views/scripts/events/venue.phtml` | ビュー | 会場別イベント一覧画面のメインテンプレート |
| eventlist.phtml | `application/modules/default/views/scripts/_partials/eventlist.phtml` | パーシャル | 個別イベントの表示テンプレート |
| default.phtml | `application/modules/default/views/scripts/_pagination/default.phtml` | パーシャル | ページネーションコンポーネント |
| info.phtml | `application/modules/default/views/scripts/_partials/info.phtml` | パーシャル | 情報メッセージ表示 |
| events.phtml | `application/layouts/scripts/events.phtml` | レイアウト | イベントセクション用レイアウト |
| events.ini | `application/configs/events.ini` | 設定 | イベントモジュールの設定ファイル |
| events.js | `_scripts/default/events.js` | JavaScript | イベント機能用スクリプト |
| eventsvenue.js | `_scripts/default/eventsvenue.js` | JavaScript | 会場地図表示用スクリプト |
| EDate.php | `library/CMS/View/Helper/EDate.php` | ヘルパー | イベント日付フォーマット |
