# 画面設計書 21-地図画面

## 概要

本ドキュメントは、Legacy CMSのフロントエンド画面である「地図画面」の設計仕様を定義するものである。イベント会場の地理的位置をGoogle Maps上で可視化する機能を提供する。

### 本画面の処理概要

**業務上の目的・背景**：本画面は、サイト利用者がイベント会場の場所を視覚的に把握できるようにすることを目的としている。テキストベースの住所情報だけでは場所の把握が困難な場合に、地図上にマーカーを表示することで会場へのアクセスを容易にする。イベント参加を検討しているユーザーにとって、会場の位置関係や周辺環境を確認できる重要な機能である。

**画面へのアクセス方法**：イベント一覧画面やイベント詳細画面からリンクをクリックすることでアクセスする。URLパス `/events/map/` に直接アクセスすることも可能である。

**主要な操作・処理内容**：
1. 画面表示時にGoogle Maps APIを読み込み、地図を初期化する
2. Ajax通信で `/events/mapdata/` からイベント会場データを取得する
3. 取得した会場データをもとに地図上にマーカーを配置する
4. マーカーをクリックすると会場名、住所、イベント情報がInfoBoxで表示される
5. 地図のズーム、パン操作で会場の詳細な位置を確認できる

**画面遷移**：
- 遷移元：イベント一覧画面、イベント詳細画面、会場別イベント一覧画面
- 遷移先：なし（地図画面は最終表示画面）

**権限による表示制御**：本画面は公開画面であり、認証なしでアクセス可能。権限による表示制御は行わない。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 21 | イベント一覧表示 | 補助機能 | 会場の地図情報を表示 |

## 画面種別

詳細（会場位置の地図表示）

## URL/ルーティング

| メソッド | URL | アクション |
|---------|-----|-----------|
| GET | /events/map/ | EventsController::mapAction |
| GET | /events/mapdata/ | EventsController::mapdataAction |

## 入出力項目

### 入力項目

本画面に入力項目はない。

### 出力項目（地図表示用データ）

| 項目名 | データ型 | 説明 |
|--------|---------|------|
| 会場名 | String | マーカーのタイトルとInfoBoxに表示 |
| 緯度 | Float | マーカー配置位置（lat） |
| 経度 | Float | マーカー配置位置（lng） |
| 住所 | String | InfoBoxに表示する住所情報 |
| イベント情報 | String | 会場で開催されるイベントのHTML |

## 表示項目

| 項目名 | 表示形式 | 説明 |
|--------|---------|------|
| ページタイトル | h2見出し | "Gig Map" |
| 地図 | Google Maps | イベント会場をマーカーで表示（高さ480px） |
| マーカー | 画像アイコン | mapmarker.pngを使用 |
| InfoBox | ポップアップ | 会場名、住所、イベント一覧を表示 |

## イベント仕様

### 1-地図初期表示

画面ロード時にGoogle Maps APIが読み込まれ、`GLoad()` 関数が呼び出される。

**処理フロー**：
1. `google.setOnLoadCallback(GLoad)` により初期化関数が呼び出される
2. 初期表示は緯度経度(0,0)、ズームレベル2のハイブリッドマップ
3. Ajax通信で `/events/mapdata/` へGETリクエスト送信
4. XMLレスポンスから会場情報を抽出
5. 各会場位置にマーカーを配置
6. 全マーカーが収まるよう地図の表示範囲を自動調整（fitBounds）

### 2-マーカークリック

マーカーをクリックするとInfoBoxが表示される。

**処理フロー**：
1. 既存のInfoBoxがあれば閉じる
2. 新しいInfoBoxを生成し表示
3. InfoBoxには会場名、住所、関連イベント一覧が含まれる

### 3-InfoBox閉じる

InfoBox右上の×ボタンをクリックすると閉じる。

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 地図データ取得 | events_venues | SELECT | 会場情報を取得（venue_id != 1） |

### テーブル別更新項目詳細

#### events_venues

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | venue_id | 全カラム取得 | デフォルト会場(id=1)は除外 |
| SELECT | venue_name | - | マーカーのtitle属性に使用 |
| SELECT | venue_lat | - | 緯度 |
| SELECT | venue_lng | - | 経度 |
| SELECT | venue_address | - | InfoBoxに表示 |

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示条件 |
|-------------|------|--------------|---------|
| MSG-MAP-001 | 情報 | This map requires JavaScript. Your browser either does not support JavaScript, or you have JavaScript turned off. | JavaScript無効時 |
| MSG-MAP-002 | 情報 | No Events To Display / There are currently no events to display. We are adding new events all the time so please check back soon. | 会場データが0件の場合 |

## 例外処理

| 例外条件 | 処理内容 |
|---------|---------|
| JavaScript無効 | noscript的なメッセージを表示（h6タグ内のテキスト） |
| 会場データなし | "No Events To Display"メッセージをInfoBoxで表示 |
| Google Maps API読み込み失敗 | 地図コンテナが空のまま表示 |

## 備考

- 地図はGoogle Maps JavaScript API v3を使用
- InfoBoxライブラリを使用したカスタムポップアップ
- jQueryはGoogleのCDNから1.4.1をロード
- マーカーアイコンは `/_styles/default/images/mapmarker.png` を使用
- InfoBoxの背景画像は `/_styles/default/images/tipbox.gif` を使用

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

イベント会場データがどのような形式で保持・転送されるかを理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | events_venues テーブル | DBスキーマ | venue_id, venue_name, venue_lat, venue_lng, venue_address カラムの構造を把握 |

**読解のコツ**: mapdataActionのSELECTクエリからテーブル構造を推測できる。

#### Step 2: エントリーポイントを理解する

画面アクセス時の処理起点を特定する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | EventsController.php | `application/modules/default/controllers/EventsController.php` | mapAction（394-400行）がエントリーポイント |

**主要処理フロー**:
1. **394行**: `mapAction()` メソッド開始
2. **396行**: `setRefer()` でリファラー設定
3. **398行**: リクエストパラメータをビューに渡す

#### Step 3: ビューテンプレートを理解する

HTMLとJavaScript読み込みの構成を把握する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | map.phtml | `application/modules/default/views/scripts/events/map.phtml` | Dojoウィジェット、Google Maps API、カスタムJSの読み込み順序 |

**主要処理フロー**:
- **9-18行**: Dojoモジュールのrequire定義
- **23-27行**: CSS・JSファイルの読み込み（eventsmap.js含む）
- **37-39行**: 地図コンテナdivの定義（id="map"）

#### Step 4: クライアントサイド地図処理を理解する

Google Maps APIを使った地図描画とAjax通信を把握する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | eventsmap.js | `public/_scripts/default/eventsmap.js` | GLoad関数による地図初期化、createMarker関数によるマーカー生成 |

**主要処理フロー**:
- **14-65行**: `GLoad()` 関数 - 地図初期化とAjaxデータ取得
- **27行**: `/events/mapdata/` へのAjaxリクエスト
- **67-100行**: `createMarker()` 関数 - マーカーとInfoBox生成

#### Step 5: 地図データ提供APIを理解する

Ajax通信で取得するデータの生成元を把握する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 5-1 | EventsController.php | `application/modules/default/controllers/EventsController.php` | mapdataAction（417-433行）でXMLデータを生成 |

**主要処理フロー**:
- **419行**: レイアウト無効化（Ajax用）
- **427-429行**: events_venuesテーブルからvenue_id!=1のレコードを取得
- **432行**: ビューにvenuesArray渡す

### プログラム呼び出し階層図

```
[ブラウザ] /events/map/
    │
    ├─ EventsController::mapAction()
    │      └─ setRefer()
    │      └─ map.phtml レンダリング
    │              └─ Google Maps API ロード
    │              └─ eventsmap.js ロード
    │
    └─ [Ajax] /events/mapdata/
           └─ EventsController::mapdataAction()
                  └─ events_venues SELECT
                  └─ mapdata.phtml レンダリング（XML出力）
```

### データフロー図

```
[入力]               [処理]                    [出力]

ブラウザアクセス ───▶ mapAction() ───▶ map.phtml（HTML）
       │
       │ Google Maps API読み込み完了
       ▼
GLoad()実行 ───▶ Ajax GET /events/mapdata/ ───▶ mapdataAction()
       │                                              │
       │                                              ▼
       │                                    events_venues SELECT
       │                                              │
       ◀────────── XML レスポンス ◀──────────────────┘
       │
       ▼
createMarker() ───▶ Google Maps上にマーカー配置
       │
       ▼
InfoBox表示（クリック時）
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| EventsController.php | `application/modules/default/controllers/EventsController.php` | コントローラ | mapAction, mapdataAction処理 |
| map.phtml | `application/modules/default/views/scripts/events/map.phtml` | ビュー | 地図画面HTML出力 |
| mapdata.phtml | `application/modules/default/views/scripts/events/mapdata.phtml` | ビュー | 会場データXML出力 |
| eventsmap.js | `public/_scripts/default/eventsmap.js` | JavaScript | Google Maps操作、Ajax通信 |
| events.js | `public/_scripts/default/events.js` | JavaScript | イベント共通処理 |
| common.js | `public/_scripts/default/common.js` | JavaScript | サイト共通処理 |
| screen.css | `public/_styles/default/screen.css` | CSS | スタイルシート |
| mapmarker.png | `public/_styles/default/images/mapmarker.png` | 画像 | マーカーアイコン |
| tipbox.gif | `public/_styles/default/images/tipbox.gif` | 画像 | InfoBox背景 |
