# 画面設計書 22-Ajaxカレンダー画面

## 概要

本ドキュメントは、Legacy CMSのフロントエンド画面である「Ajaxカレンダー画面」の設計仕様を定義するものである。イベントカレンダーの月送り操作時に、Ajax通信で部分的にカレンダーHTMLを更新するための画面である。

### 本画面の処理概要

**業務上の目的・背景**：本画面は、カレンダー画面での月送り（前月・翌月）操作時にページ全体をリロードせずにカレンダー部分のみを更新するためのAjaxレスポンス用画面である。ユーザーエクスペリエンスを向上させ、スムーズなカレンダーナビゲーションを実現する。通常の画面としては直接アクセスされず、カレンダー画面からのAjax呼び出しで使用される。

**画面へのアクセス方法**：カレンダー画面の「Previous」「Next」ボタンをクリックした際に、JavaScript関数`calGo()`がAjax通信でこの画面を呼び出す。直接URLアクセスも可能だが、レイアウトなしのHTMLフラグメントが返される。

**主要な操作・処理内容**：
1. リクエストパラメータから月（month）と年（year）を取得
2. ECalendarビューヘルパーを呼び出してカレンダーHTMLを生成
3. 指定月のイベント情報をデータベースから取得
4. イベントがある日付はリンク付きで表示
5. レイアウトなしのHTMLフラグメントを返す

**画面遷移**：
- 遷移元：カレンダー画面（Ajax呼び出し）
- 遷移先：なし（HTMLフラグメントをカレンダー画面に挿入）

**権限による表示制御**：本画面は公開画面であり、認証なしでアクセス可能。権限による表示制御は行わない。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 21 | イベント一覧表示 | API連携 | Ajax経由でカレンダーデータを取得 |

## 画面種別

部分画面（Ajax用HTMLフラグメント）

## URL/ルーティング

| メソッド | URL | アクション |
|---------|-----|-----------|
| GET | /events/acalendar/?month={month}&year={year} | EventsController::acalendarAction |

## 入出力項目

### 入力項目（リクエストパラメータ）

| 項目名 | パラメータ名 | データ型 | 必須 | 説明 |
|--------|-------------|---------|------|------|
| 月 | month | Integer | はい | 表示対象月（1-12） |
| 年 | year | Integer | はい | 表示対象年（YYYY形式） |

### 出力項目

| 項目名 | データ型 | 説明 |
|--------|---------|------|
| カレンダーHTML | String | ECalendarヘルパーで生成されたHTMLフラグメント |

## 表示項目

| 項目名 | 表示形式 | 説明 |
|--------|---------|------|
| 月見出し | h3タグ | "January 2026"形式で月名と年を表示 |
| カレンダーテーブル | tableタグ | 7列（日〜土）のカレンダー形式 |
| イベントあり日付 | リンク | イベントがある日はリンク付きで表示 |
| イベント情報ツールチップ | Dijit.Tooltip | イベントあり日付にマウスオーバーでイベント詳細表示 |
| リスト表示リンク | aタグ | "View as list" リンク |
| 前月リンク | aタグ | "Previous" - 前月へ移動 |
| 翌月リンク | aタグ | "Next" - 翌月へ移動 |

## イベント仕様

### 1-カレンダー表示

指定された月・年のカレンダーHTMLを生成して返す。

**処理フロー**：
1. リクエストパラメータからmonth, yearを取得
2. ECalendarビューヘルパーのgenerateCalendar()メソッドを呼び出し
3. 月初日の曜日を計算してカレンダーグリッドを生成
4. 各日付についてイベント有無をDBから確認
5. イベントがある日はリンクとツールチップを追加
6. HTMLフラグメントを出力

### 2-イベントあり日付のツールチップ

イベントがある日付にはDojo Tooltipが設定される。

**表示内容**：
- イベント日時（ECDate形式）
- イベントタイトル（太字）

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| カレンダー生成 | events | SELECT | 指定月の公開イベントを取得 |

### テーブル別更新項目詳細

#### events

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | event_id | 全カラム取得 | - |
| SELECT | event_title | - | ツールチップに表示 |
| SELECT | event_date | - | 日付照合、表示用 |
| SELECT | event_status | = 'published' | 公開済みイベントのみ |
| WHERE | month(event_date) | = 指定月 | 月で絞り込み |
| WHERE | dayofmonth(event_date) | = 各日 | 日で絞り込み |
| WHERE | year(event_date) | = 指定年 | 年で絞り込み |

## メッセージ仕様

本画面にはエラーメッセージ等の表示仕様はない。

## 例外処理

| 例外条件 | 処理内容 |
|---------|---------|
| month/yearパラメータなし | 現在の月・年を使用してカレンダー表示 |
| 不正なmonth/year値 | getdate()関数が自動補正 |

## 備考

- レイアウトは無効化され、HTMLフラグメントのみが出力される
- ECalendarビューヘルパー内でDBアクセスが行われる
- カレンダーはDojoウィジェット（dijit.Tooltip）に依存
- 前月・翌月リンクはJavaScript関数calGo()を呼び出す

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

カレンダー表示に必要なイベントデータの構造を把握する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | events テーブル | DBスキーマ | event_id, event_title, event_date, event_status カラム |

**読解のコツ**: ECalendar.phpのSELECTクエリからテーブル構造を推測する。

#### Step 2: エントリーポイントを理解する

Ajax呼び出し時の処理起点を特定する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | EventsController.php | `application/modules/default/controllers/EventsController.php` | acalendarAction（405-412行） |

**主要処理フロー**:
1. **407行**: `$this->_helper->layout->disableLayout()` でレイアウト無効化
2. **409行**: `$this->_request->getParam('month')` で月パラメータ取得
3. **410行**: `$this->_request->getParam('year')` で年パラメータ取得

#### Step 3: ビューテンプレートを理解する

HTMLフラグメント出力の構成を把握する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | acalendar.phtml | `application/modules/default/views/scripts/events/acalendar.phtml` | ECalendarヘルパー呼び出し |

**主要処理フロー**:
- **9行**: `$this->ECalendar($this->month,$this->year)` でカレンダー生成

#### Step 4: ビューヘルパーを理解する

カレンダーHTML生成ロジックを把握する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | ECalendar.php | `application/modules/default/views/helpers/ECalendar.php` | generateCalendar()メソッド |

**主要処理フロー**:
- **21-100行**: `generateCalendar()` 関数
- **23-27行**: month/year未設定時は現在日時を使用
- **28-44行**: 前月・翌月の計算
- **52-93行**: カレンダーテーブル生成ループ
- **65-76行**: 各日のイベント存在チェック（DBアクセス）
- **78-88行**: イベントあり日のリンクとツールチップ生成
- **94-99行**: リスト表示リンクと月送りボタン

### プログラム呼び出し階層図

```
[カレンダー画面] calGo()関数
    │
    └─ Ajax GET /events/acalendar/?month=X&year=Y
           │
           └─ EventsController::acalendarAction()
                  │
                  ├─ disableLayout()
                  │
                  └─ acalendar.phtml レンダリング
                         │
                         └─ ECalendar ヘルパー
                                │
                                └─ generateCalendar()
                                       │
                                       └─ events SELECT（各日ごと）
```

### データフロー図

```
[入力]               [処理]                    [出力]

month, year    ───▶ acalendarAction()
パラメータ            │
                     ▼
              ECalendar::generateCalendar()
                     │
                     ├─ 月初日の曜日計算
                     │
                     ├─ 6週×7日ループ ───▶ events SELECT
                     │                      （日ごとのイベント確認）
                     ▼
              カレンダーHTMLテーブル ───▶ HTMLフラグメント出力
                     │
                     ▼
              [カレンダー画面に挿入]
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| EventsController.php | `application/modules/default/controllers/EventsController.php` | コントローラ | acalendarAction処理 |
| acalendar.phtml | `application/modules/default/views/scripts/events/acalendar.phtml` | ビュー | カレンダーHTMLフラグメント出力 |
| ECalendar.php | `application/modules/default/views/helpers/ECalendar.php` | ビューヘルパー | カレンダーHTML生成ロジック |
| calendar.phtml | `application/modules/default/views/scripts/events/calendar.phtml` | ビュー | 呼び出し元カレンダー画面 |
| events.js | `public/_scripts/default/events.js` | JavaScript | calGo()関数定義 |
