# 画面設計書 23-静的ページ画面

## 概要

本ドキュメントは、Legacy CMSのフロントエンド画面である「静的ページ画面」の設計仕様を定義するものである。CMSで管理される静的コンテンツページを表示する機能を提供する。

### 本画面の処理概要

**業務上の目的・背景**：本画面は、管理画面から登録・編集された静的コンテンツ（会社情報、サービス案内、お知らせなど）を一般ユーザーに公開するための画面である。記事やイベントとは異なり、更新頻度が低く、サイトの基本情報を提供するページに使用される。URLスラッグによるアクセスにより、SEOに配慮したパーマリンクを実現している。

**画面へのアクセス方法**：ナビゲーションメニューやサイト内リンクからアクセスする。URLパスは `/page/{slug}/` 形式で、スラッグは管理画面で設定された一意の識別子である。

**主要な操作・処理内容**：
1. URLからページスラッグを取得する
2. データベースからスラッグに一致する公開済みページを検索する
3. ページタイトル、コンテンツ、最終更新日を表示する
4. ページに関連付けられたタグを表示する
5. ページが見つからない場合は404エラーへ転送する

**画面遷移**：
- 遷移元：ホーム画面、ナビゲーションメニュー、タグ別ページ一覧画面、サイト内リンク
- 遷移先：タグ別ページ一覧画面（タグクリック時）

**権限による表示制御**：本画面は公開画面であり、認証なしでアクセス可能。ただし、page_status='published'のページのみ表示される。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 11 | ページ一覧表示 | 主機能 | 静的ページの内容を表示 |
| 44 | コメント一覧表示 | 補助機能 | ページに紐づくコメントを表示 |
| 49 | タグ一覧表示 | 補助機能 | ページのタグを表示 |

## 画面種別

詳細（静的ページコンテンツ表示）

## URL/ルーティング

| メソッド | URL | アクション |
|---------|-----|-----------|
| GET | /page/{slug}/ | PagesController::pageAction |

## 入出力項目

### 入力項目（URLパラメータ）

| 項目名 | パラメータ名 | データ型 | 必須 | 説明 |
|--------|-------------|---------|------|------|
| スラッグ | slug | String | はい | ページ識別用の一意文字列 |

### 出力項目

| 項目名 | データ型 | 説明 |
|--------|---------|------|
| ページタイトル | String | ページの見出し |
| ページコンテンツ | HTML | ページ本文（HTMLとして出力） |
| 最終更新日 | Date | ページの最終編集日時 |
| タグ一覧 | Array | ページに関連付けられたタグ |

## 表示項目

| 項目名 | 表示形式 | 説明 |
|--------|---------|------|
| ページタイトル | h2見出し | `$this->pageArray['page_title']` をエスケープ表示 |
| ページコンテンツ | div内HTML | `$this->pageArray['page_content']` をそのまま出力 |
| 最終更新日 | テキスト | "Last updated: " + ADate形式の日付 |
| タグ一覧 | リンクリスト | TListヘルパーで生成されたタグリンク |

## イベント仕様

### 1-ページ表示

URLのスラッグに基づいてページコンテンツを取得・表示する。

**処理フロー**：
1. `$this->_request->getParam('slug')` でスラッグ取得
2. pagesテーブルからpage_status='published'かつpage_slug一致のレコードを検索
3. レコードが存在すればビューに渡して表示
4. レコードが存在しなければ404エラーへフォワード

### 2-タグクリック

ページに表示されたタグをクリックするとタグ別ページ一覧に遷移する。

**遷移先URL**: `/pages/tag/{tag}/`

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| ページ表示 | pages | SELECT | スラッグでページ情報を取得 |
| タグ表示 | tags | SELECT | ページIDでタグ一覧を取得（TListヘルパー） |

### テーブル別更新項目詳細

#### pages

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | page_id | 全カラム取得 | - |
| SELECT | page_title | - | 画面タイトル、h2見出しに表示 |
| SELECT | page_content | - | ページ本文HTML |
| SELECT | page_edit | - | 最終更新日表示用 |
| SELECT | page_section | - | プレースホルダーに設定 |
| SELECT | page_slug | = URL指定値 | 検索条件 |
| SELECT | page_status | = 'published' | 公開ページのみ |

#### tags

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | tag_tag | - | タグ名表示用 |
| SELECT | tag_slave | = page_id | ページIDで検索 |
| SELECT | tag_type | = 'P' | ページ用タグ |

## メッセージ仕様

本画面に固有のメッセージ表示はない。

## 例外処理

| 例外条件 | 処理内容 |
|---------|---------|
| ページが見つからない | ErrorController::notfoundActionへフォワード、404エラー表示 |
| スラッグ未指定 | 同上（空スラッグでは該当ページなしと判定） |

## 備考

- ページコンテンツはHTMLとしてそのまま出力されるため、管理画面でのXSS対策が必要
- ページセクション（page_section）はレイアウトのナビゲーション表示制御に使用
- Dojoウィジェット（RotatorContainer）がロードされるが、コンテンツ内での使用は任意

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

ページデータがどのような形式で保持されるかを理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | pages テーブル | DBスキーマ | page_id, page_title, page_content, page_slug, page_status, page_edit カラム |
| 1-2 | tags テーブル | DBスキーマ | tag_tag, tag_slave, tag_type カラム |

**読解のコツ**: PagesController.phpのSELECTクエリからテーブル構造を推測する。

#### Step 2: エントリーポイントを理解する

画面アクセス時の処理起点を特定する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | PagesController.php | `application/modules/default/controllers/PagesController.php` | pageAction（28-59行） |

**主要処理フロー**:
1. **30行**: `setRefer()` でリファラー設定
2. **34行**: `$this->_request->getParam('slug')` でスラッグ取得
3. **40-44行**: pagesテーブルから公開済みページを検索
4. **47-51行**: ページ存在時はビューに渡す
5. **53-57行**: ページ非存在時は404エラーへフォワード

#### Step 3: ビューテンプレートを理解する

HTML出力の構成を把握する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | page.phtml | `application/modules/default/views/scripts/pages/page.phtml` | ページコンテンツ表示、タグ一覧表示 |

**主要処理フロー**:
- **9-14行**: Dojoモジュールのrequire定義
- **17行**: ページタイトルをhead titleに設定
- **25行**: h2見出しでページタイトル表示（エスケープ済み）
- **32行**: ページコンテンツをHTMLとして出力
- **34行**: 最終更新日をADateヘルパーでフォーマット表示
- **41行**: TListヘルパーでタグ一覧表示

#### Step 4: タグ表示ヘルパーを理解する

タグ一覧の生成ロジックを把握する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | TList.php | `application/modules/default/views/helpers/TList.php` | タグ一覧HTML生成（存在する場合） |

### プログラム呼び出し階層図

```
[ブラウザ] /page/{slug}/
    │
    └─ PagesController::pageAction()
           │
           ├─ setRefer()
           │
           ├─ pages SELECT (slug, status='published')
           │
           ├─ ページ存在？
           │      │
           │      ├─ Yes: page.phtml レンダリング
           │      │         │
           │      │         ├─ ADate ヘルパー（日付フォーマット）
           │      │         │
           │      │         └─ TList ヘルパー（タグ一覧）
           │      │                  └─ tags SELECT
           │      │
           │      └─ No: ErrorController::notfoundAction へフォワード
           │
           └─ レスポンス返却
```

### データフロー図

```
[入力]               [処理]                    [出力]

/page/{slug}/ ───▶ pageAction()
                      │
                      ├─ slug取得
                      │
                      ▼
               pages SELECT ───▶ pageArray
                      │
                      ▼
               page.phtml レンダリング
                      │
                      ├─ page_title ───▶ <h2>タイトル</h2>
                      │
                      ├─ page_content ───▶ <div>本文HTML</div>
                      │
                      ├─ page_edit ───▶ "Last updated: 日付"
                      │
                      └─ TList() ───▶ <div>タグリンク...</div>
                             │
                             ▼
                      tags SELECT
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| PagesController.php | `application/modules/default/controllers/PagesController.php` | コントローラ | pageAction処理 |
| page.phtml | `application/modules/default/views/scripts/pages/page.phtml` | ビュー | ページコンテンツ表示 |
| pages.ini | `application/configs/pages.ini` | 設定 | ページモジュール設定 |
| TList.php | `application/modules/default/views/helpers/TList.php` | ビューヘルパー | タグ一覧表示 |
| ADate.php | `application/modules/default/views/helpers/ADate.php` | ビューヘルパー | 日付フォーマット |
| pages レイアウト | `application/modules/default/layouts/scripts/pages.phtml` | レイアウト | ページ用レイアウト |
| common.js | `public/_scripts/default/common.js` | JavaScript | サイト共通処理 |
| screen.css | `public/_styles/default/screen.css` | CSS | スタイルシート |
