# 画面設計書 24-ページタグ一覧画面

## 概要

本ドキュメントは、Legacy CMSのフロントエンド画面である「ページタグ一覧画面」の設計仕様を定義するものである。静的ページに関連付けられた全てのタグをタグクラウド形式で表示する機能を提供する。

### 本画面の処理概要

**業務上の目的・背景**：本画面は、サイト内の静的ページを分類・整理するためのタグを一覧表示し、ユーザーが興味のあるトピックを見つけやすくすることを目的としている。タグクラウド形式で表示することで、使用頻度の高いタグを視覚的に把握できる。ブログ記事用タグと静的ページ用タグを切り替えるタブ機能により、コンテンツ種別ごとのナビゲーションを提供する。

**画面へのアクセス方法**：ナビゲーションメニューの「Pages」セクションや、サイト全体のタグ一覧画面からタブで切り替えてアクセスする。URLパスは `/pages/tags/` である。

**主要な操作・処理内容**：
1. ページに関連付けられたタグをタグクラウド形式で表示する
2. 各タグのカウント（使用回数）を取得して表示サイズを調整する
3. All/Blog/Pagesのタブで表示対象を切り替える
4. タグをクリックするとタグ別ページ一覧へ遷移する

**画面遷移**：
- 遷移元：サイトタグ一覧画面、ブログタグ一覧画面（タブ切替）、ナビゲーションメニュー
- 遷移先：タグ別ページ一覧画面（タグクリック時）、サイトタグ一覧画面（Allタブ）、ブログタグ一覧画面（Blogタブ）

**権限による表示制御**：本画面は公開画面であり、認証なしでアクセス可能。権限による表示制御は行わない。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 49 | タグ一覧表示 | 主機能 | ページに関連するタグを一覧表示 |

## 画面種別

一覧（タグクラウド形式）

## URL/ルーティング

| メソッド | URL | アクション |
|---------|-----|-----------|
| GET | /pages/tags/ | PagesController::tagsAction |

## 入出力項目

### 入力項目

本画面に入力項目はない。

### 出力項目

| 項目名 | データ型 | 説明 |
|--------|---------|------|
| タグ名 | String | 各タグの名称 |
| タグカウント（ALL） | Integer | 全コンテンツにおける当該タグの使用回数 |
| タグカウント（Blog） | Integer | ブログ記事における当該タグの使用回数 |
| タグカウント（Pages） | Integer | 静的ページにおける当該タグの使用回数 |

## 表示項目

| 項目名 | 表示形式 | 説明 |
|--------|---------|------|
| ページタイトル | h2見出し | "Tags: Pages" |
| タブ：All | リンク | 全タグ一覧への遷移（件数付き） |
| タブ：Blog | リンク | ブログタグ一覧への遷移（件数付き） |
| タブ：Pages | アクティブ状態 | 現在表示中（件数付き） |
| タグクラウド | div内 | PTagCloudヘルパーで生成されたタグ群 |

## イベント仕様

### 1-タグクラウド表示

ページに関連するタグをクラウド形式で表示する。

**処理フロー**：
1. PagesController::tagsAction でビューをレンダリング
2. tags.phtmlでPTagCloudヘルパーを呼び出し
3. 使用頻度に応じたサイズでタグを表示

### 2-タブ切替

All/Blog/Pagesタブをクリックして表示を切り替える。

| タブ | 遷移先URL | 説明 |
|-----|----------|------|
| All | /tags/ | 全コンテンツのタグ一覧 |
| Blog | /articles/tags/ | ブログ記事のタグ一覧 |
| Pages | - | 現在の画面（アクティブ） |

### 3-タグクリック

タグクラウド内のタグをクリックするとタグ別ページ一覧へ遷移する。

**遷移先URL**: `/pages/tag/{tag}/`

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| タグクラウド表示 | tags | SELECT | ページ用タグを取得 |
| タブ件数表示 | tags | SELECT | カテゴリ別タグ件数を取得 |

### テーブル別更新項目詳細

#### tags

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | tag_tag | - | タグ名表示用 |
| SELECT | tag_type | = 'P' | ページ用タグ（PTagCloud） |
| SELECT | tag_type | = 'ALL' | 全タグ件数カウント（TCount） |
| COUNT | * | GROUP BY tag_tag | 使用頻度計算 |

## メッセージ仕様

本画面に固有のメッセージ表示はない。

## 例外処理

| 例外条件 | 処理内容 |
|---------|---------|
| タグが0件 | 空のタグクラウドエリアが表示される |

## 備考

- タグクラウドはPTagCloudヘルパーで生成
- タグ件数表示はTCount, ATagCount, PTagCountヘルパーを使用
- Dojoウィジェット（RotatorContainer）がロードされる
- showTagsプレースホルダーを'false'に設定（サイドバーのタグ表示を抑制）

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

タグデータがどのような形式で保持されるかを理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | tags テーブル | DBスキーマ | tag_tag, tag_slave, tag_type カラム |

**読解のコツ**: tag_typeで'A'(Article), 'P'(Page), 'E'(Event)などを区別している。

#### Step 2: エントリーポイントを理解する

画面アクセス時の処理起点を特定する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | PagesController.php | `application/modules/default/controllers/PagesController.php` | tagsAction（64-67行） |

**主要処理フロー**:
1. **66行**: `setRefer()` でリファラー設定
2. tagsアクションは特にDB操作なし（ヘルパーに委譲）

#### Step 3: ビューテンプレートを理解する

HTML出力の構成を把握する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | tags.phtml | `application/modules/default/views/scripts/pages/tags.phtml` | タブ生成、タグクラウド呼び出し |

**主要処理フロー**:
- **9-14行**: Dojoモジュールのrequire定義
- **17行**: ページタイトル設定
- **20行**: showTagsプレースホルダーを'false'に設定
- **27行**: h2見出し "Tags: Pages"
- **31行**: Allタブ（TCountヘルパーで件数取得）
- **32行**: Blogタブ（ATagCountヘルパーで件数取得）
- **33行**: Pagesタブ（アクティブ、PTagCountヘルパーで件数取得）
- **40行**: PTagCloudヘルパーでタグクラウド生成

#### Step 4: タグ関連ヘルパーを理解する

タグ表示ロジックを把握する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | PTagCloud.php | `application/modules/default/views/helpers/PTagCloud.php` | ページ用タグクラウド生成 |
| 4-2 | PTagCount.php | `application/modules/default/views/helpers/PTagCount.php` | ページ用タグ件数取得 |
| 4-3 | TCount.php | `application/modules/default/views/helpers/TCount.php` | 全タグ件数取得 |
| 4-4 | ATagCount.php | `application/modules/default/views/helpers/ATagCount.php` | 記事用タグ件数取得 |

### プログラム呼び出し階層図

```
[ブラウザ] /pages/tags/
    │
    └─ PagesController::tagsAction()
           │
           ├─ setRefer()
           │
           └─ tags.phtml レンダリング
                  │
                  ├─ TCount('ALL','ALL') ───▶ tags SELECT (全件)
                  │
                  ├─ ATagCount('ALL') ───▶ tags SELECT (type='A')
                  │
                  ├─ PTagCount('ALL') ───▶ tags SELECT (type='P')
                  │
                  └─ PTagCloud('pages','ALL') ───▶ tags SELECT & クラウド生成
```

### データフロー図

```
[入力]               [処理]                    [出力]

/pages/tags/ ───▶ tagsAction()
                      │
                      ▼
               tags.phtml レンダリング
                      │
                      ├─ TCount() ───▶ 全タグ件数
                      │
                      ├─ ATagCount() ───▶ 記事タグ件数
                      │
                      ├─ PTagCount() ───▶ ページタグ件数
                      │
                      └─ PTagCloud() ───▶ タグクラウドHTML
                             │
                             ▼
                      tags SELECT ───▶ タグ一覧+使用頻度
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| PagesController.php | `application/modules/default/controllers/PagesController.php` | コントローラ | tagsAction処理 |
| tags.phtml | `application/modules/default/views/scripts/pages/tags.phtml` | ビュー | タグクラウド表示 |
| PTagCloud.php | `application/modules/default/views/helpers/PTagCloud.php` | ビューヘルパー | ページ用タグクラウド生成 |
| PTagCount.php | `application/modules/default/views/helpers/PTagCount.php` | ビューヘルパー | ページ用タグ件数 |
| TCount.php | `application/modules/default/views/helpers/TCount.php` | ビューヘルパー | 全タグ件数 |
| ATagCount.php | `application/modules/default/views/helpers/ATagCount.php` | ビューヘルパー | 記事用タグ件数 |
| common.js | `public/_scripts/default/common.js` | JavaScript | サイト共通処理 |
| screen.css | `public/_styles/default/screen.css` | CSS | スタイルシート |
