# 画面設計書 25-タグ別ページ一覧画面

## 概要

本ドキュメントは、Legacy CMSのフロントエンド画面である「タグ別ページ一覧画面」の設計仕様を定義するものである。指定されたタグに関連付けられた静的ページを一覧表示する機能を提供する。

### 本画面の処理概要

**業務上の目的・背景**：本画面は、特定のタグに関連するページを集約して表示し、ユーザーが関心のあるトピックに関連するコンテンツを効率的に見つけられるようにすることを目的としている。タグクラウドやタグ一覧からの遷移先として、ユーザーのナビゲーションを支援する重要な画面である。

**画面へのアクセス方法**：ページタグ一覧画面やページ詳細画面のタグリンクをクリックしてアクセスする。URLパスは `/pages/tag/{tag}/` 形式で、tagはURLエンコードされたタグ名である。

**主要な操作・処理内容**：
1. URLからタグ名を取得してデコードする
2. タグに関連付けられた公開済みページを検索する
3. ページ一覧をページネーション付きで表示する
4. Blog/Pagesタブでブログ記事との切り替えが可能
5. 各ページタイトルをクリックすると静的ページ画面へ遷移する

**画面遷移**：
- 遷移元：ページタグ一覧画面、静的ページ画面、サイトタグ一覧画面
- 遷移先：静的ページ画面（ページタイトルクリック時）、タグ別記事一覧画面（Blogタブ）

**権限による表示制御**：本画面は公開画面であり、認証なしでアクセス可能。page_status='published'のページのみ表示される。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 11 | ページ一覧表示 | 主機能 | タグでフィルタしたページを表示 |
| 49 | タグ一覧表示 | 補助機能 | タグ情報の取得 |

## 画面種別

一覧（ページネーション付き）

## URL/ルーティング

| メソッド | URL | アクション |
|---------|-----|-----------|
| GET | /pages/tag/{tag}/ | PagesController::tagAction |
| GET | /pages/tag/{tag}/page/{page}/ | PagesController::tagAction（ページ番号付き） |

## 入出力項目

### 入力項目（URLパラメータ）

| 項目名 | パラメータ名 | データ型 | 必須 | 説明 |
|--------|-------------|---------|------|------|
| タグ名 | tag | String | はい | URLエンコードされたタグ名 |
| ページ番号 | page | Integer | いいえ | ページネーションのページ番号（デフォルト: 1） |

### 出力項目

| 項目名 | データ型 | 説明 |
|--------|---------|------|
| タグ名 | String | 表示中のタグ名 |
| ページ一覧 | Array | タグに関連するページのリスト |
| ブログ記事件数 | Integer | 同じタグのブログ記事数 |
| ページ件数 | Integer | 同じタグのページ数 |

## 表示項目

| 項目名 | 表示形式 | 説明 |
|--------|---------|------|
| ページタイトル | h2見出し | "Tag: {タグ名}" |
| タブ：Blog | リンク | タグ別記事一覧への遷移（件数付き） |
| タブ：Pages | アクティブ状態 | 現在表示中（件数付き） |
| ページ一覧 | 繰り返しブロック | 各ページのタイトルとタグを表示 |
| ページタイトル | h3リンク | ページ詳細へのリンク |
| タグ一覧 | div内 | 各ページに関連するタグ |
| ページネーション | ナビゲーション | ページ送り用リンク |
| 0件メッセージ | 情報 | "This tag has no associated pages" |

## イベント仕様

### 1-ページ一覧表示

指定タグに関連するページ一覧をページネーション付きで表示する。

**処理フロー**：
1. `$this->_request->getParam('tag')` でURLエンコードされたタグ名取得
2. `urldecode()` でタグ名をデコード
3. `$this->_getParam('page')` でページ番号取得（デフォルト: 1）
4. tags + pages テーブルをJOINしてタグ一致・公開済みページを検索
5. Zend_Paginatorで結果をページネーション
6. 結果をビューに渡して表示

### 2-タブ切替

Blog/Pagesタブをクリックして表示を切り替える。

| タブ | 遷移先URL | 説明 |
|-----|----------|------|
| Blog | /articles/tag/{tag}/ | 同タグのブログ記事一覧 |
| Pages | - | 現在の画面（アクティブ） |

### 3-ページタイトルクリック

ページタイトルをクリックすると静的ページ画面へ遷移する。

**遷移先URL**: `/page/{slug}/`

### 4-タグクリック

ページ内のタグをクリックすると該当タグのページ一覧へ遷移する。

**遷移先URL**: `/pages/tag/{tag}/`

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| ページ一覧表示 | tags, pages | SELECT JOIN | タグ一致の公開ページを取得 |
| タグ件数表示 | tags | SELECT | カテゴリ別タグ件数を取得 |

### テーブル別更新項目詳細

#### tags (t)

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | tag_tag | = URL指定タグ名 | 検索条件 |
| SELECT | tag_type | = 'P' | ページ用タグ |
| SELECT | tag_slave | - | ページIDとのJOIN用 |

#### pages (p)

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | page_id | = t.tag_slave | JOIN条件 |
| SELECT | page_title | - | 一覧表示用 |
| SELECT | page_slug | - | リンク生成用 |
| SELECT | page_status | = 'published' | 公開ページのみ |
| ORDER BY | page_title | ASC | タイトル順ソート |

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示条件 |
|-------------|------|--------------|---------|
| MSG-TAG-001 | 情報 | This tag has no associated pages | 該当ページが0件の場合 |

## 例外処理

| 例外条件 | 処理内容 |
|---------|---------|
| 該当ページなし | "This tag has no associated pages" メッセージを表示 |
| 無効なタグ名 | 空の一覧が表示される |

## 備考

- タグ名はURLエンコードされているため、コントローラ側でデコードが必要
- ページネーションの1ページあたり件数はpages.iniのrows設定に依存
- Dojoウィジェット（RotatorContainer）がロードされる

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

ページとタグの関連データ構造を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | tags テーブル | DBスキーマ | tag_tag, tag_slave, tag_type カラム |
| 1-2 | pages テーブル | DBスキーマ | page_id, page_title, page_slug, page_status カラム |

**読解のコツ**: tags.tag_slave = pages.page_id でJOINしている。

#### Step 2: エントリーポイントを理解する

画面アクセス時の処理起点を特定する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | PagesController.php | `application/modules/default/controllers/PagesController.php` | tagAction（72-107行） |

**主要処理フロー**:
1. **74行**: `setRefer()` でリファラー設定
2. **78-83行**: ページ番号取得（デフォルト1）
3. **85-86行**: タグ名取得とデコード
4. **91-97行**: tags + pages をJOINしてSELECT
5. **99-103行**: Zend_Paginatorでページネーション設定
6. **106行**: 結果をビューに渡す

#### Step 3: ビューテンプレートを理解する

HTML出力の構成を把握する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | tag.phtml | `application/modules/default/views/scripts/pages/tag.phtml` | ページ一覧表示、ページネーション |

**主要処理フロー**:
- **17行**: ページタイトル設定（タグ名含む）
- **26行**: h2見出し "Tag: {タグ名}"
- **30行**: Blogタブ（ATagCountヘルパーで件数取得）
- **31行**: Pagesタブ（アクティブ、PTagCountヘルパーで件数取得）
- **36-50行**: ページ一覧ループ（pagesArrayが0件超の場合）
- **41行**: ページタイトルリンク生成
- **43行**: TListヘルパーで各ページのタグ表示
- **52行**: ページネーションコントロール
- **56行**: 0件時のメッセージ表示

### プログラム呼び出し階層図

```
[ブラウザ] /pages/tag/{tag}/
    │
    └─ PagesController::tagAction()
           │
           ├─ setRefer()
           │
           ├─ urldecode(tag)
           │
           ├─ tags + pages JOIN SELECT
           │
           ├─ Zend_Paginator 設定
           │
           └─ tag.phtml レンダリング
                  │
                  ├─ ATagCount() ───▶ 記事タグ件数
                  │
                  ├─ PTagCount() ───▶ ページタグ件数
                  │
                  ├─ foreach pagesArray ───▶ ページ一覧表示
                  │      │
                  │      └─ TList() ───▶ 各ページのタグ
                  │
                  └─ paginationControl() ───▶ ページネーション
```

### データフロー図

```
[入力]               [処理]                    [出力]

/pages/tag/{tag}/ ───▶ tagAction()
                         │
                         ├─ urldecode(tag)
                         │
                         ▼
                  tags + pages SELECT
                         │
                         ▼
                  Zend_Paginator
                         │
                         ▼
                  tag.phtml レンダリング
                         │
                         ├─ h2 "Tag: タグ名"
                         │
                         ├─ タブ（Blog件数 / Pages件数）
                         │
                         ├─ foreach ───▶ ページタイトル+タグ
                         │
                         └─ ページネーション
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| PagesController.php | `application/modules/default/controllers/PagesController.php` | コントローラ | tagAction処理 |
| tag.phtml | `application/modules/default/views/scripts/pages/tag.phtml` | ビュー | ページ一覧表示 |
| pages.ini | `application/configs/pages.ini` | 設定 | ページネーション件数(rows) |
| TList.php | `application/modules/default/views/helpers/TList.php` | ビューヘルパー | タグ一覧表示 |
| ATagCount.php | `application/modules/default/views/helpers/ATagCount.php` | ビューヘルパー | 記事タグ件数 |
| PTagCount.php | `application/modules/default/views/helpers/PTagCount.php` | ビューヘルパー | ページタグ件数 |
| default.phtml | `application/modules/default/views/scripts/_pagination/default.phtml` | 部分テンプレート | ページネーションUI |
| info.phtml | `application/modules/default/views/scripts/_partials/info.phtml` | 部分テンプレート | 情報メッセージ表示 |
