# 画面設計書 26-ユーザー設定画面

## 概要

本ドキュメントは、Legacy CMSのフロントエンド画面である「ユーザー設定画面」の設計仕様を定義するものである。ログインユーザーのプロフィール情報を表示・編集する機能を提供する。

### 本画面の処理概要

**業務上の目的・背景**：本画面は、サイトに登録したユーザーが自身のプロフィール情報（連絡先、居住地域、メール設定など）を確認・変更できるようにすることを目的としている。ユーザーエクスペリエンスを向上させ、パーソナライズされたサービスを提供するための基盤となる画面である。

**画面へのアクセス方法**：ログイン後、ナビゲーションメニューの「Settings」リンクからアクセスする。URLパスは `/settings/` である。未ログイン状態でアクセスするとログイン画面へリダイレクトされる。

**主要な操作・処理内容**：
1. ログイン認証状態を確認する
2. ユーザー情報とプロフィールをデータベースから取得する
3. プロフィール情報（国、市区町村、メール形式など）を表示・編集可能にする
4. 保存ボタンでプロフィール更新を実行する
5. Profile/Password/Subscriptionsタブで設定画面を切り替える

**画面遷移**：
- 遷移元：ログイン画面（ログイン成功後）、ナビゲーションメニュー、各設定サブ画面
- 遷移先：パスワード変更画面（Passwordタブ）、購読設定画面（Subscriptionsタブ）、ログイン画面（未認証時）

**権限による表示制御**：ログイン認証が必須。未認証の場合はログイン画面へフォワードされる。エイリアス、名、姓、メールアドレスは読み取り専用で変更不可。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 20 | プロフィール表示 | 主機能 | ログインユーザーの設定情報を表示 |
| 18 | ユーザー編集 | 補助機能 | プロフィール情報の編集 |

## 画面種別

編集（プロフィール設定フォーム）

## URL/ルーティング

| メソッド | URL | アクション |
|---------|-----|-----------|
| GET | /settings/ | SettingsController::indexAction |
| POST | /settings/ | SettingsController::indexAction（フォーム送信） |

## 入出力項目

### 入力項目（フォーム）

| 項目名 | フィールド名 | データ型 | 必須 | バリデーション | 備考 |
|--------|-------------|---------|------|---------------|------|
| エイリアス | alias | String | - | - | 読み取り専用 |
| 名 | first | String | - | - | 読み取り専用 |
| 姓 | last | String | - | - | 読み取り専用 |
| メールアドレス | email | String | - | - | 読み取り専用 |
| 国 | country | String | はい | アルファベット、ハイフン、アポストロフィ、括弧、スペースのみ | プルダウン選択 |
| 市区町村 | city | String | いいえ | アルファベット、ハイフン、アポストロフィ、括弧、スペースのみ | 任意入力 |
| メール形式 | format | String | いいえ | 'text' or 'html' | ラジオボタン |

### 出力項目

| 項目名 | データ型 | 説明 |
|--------|---------|------|
| ユーザー情報 | Array | users + users_profiles JOIN結果 |
| 更新成功メッセージ | String | "Profile Updated" |
| バリデーションエラー | Array | 入力検証エラーメッセージ |

## 表示項目

| 項目名 | 表示形式 | 説明 |
|--------|---------|------|
| ページタイトル | h2見出し | "Account Settings: Profile" |
| タブ：Profile | アクティブ状態 | 現在表示中 |
| タブ：Password | リンク | パスワード変更画面への遷移 |
| タブ：Subscriptions | リンク | 購読設定画面への遷移 |
| 更新成功メッセージ | 情報ボックス | "Profile Updated" |
| Identityフィールドセット | fieldset | エイリアス、名、姓（読み取り専用） |
| Contact Detailsフィールドセット | fieldset | メールアドレス（読み取り専用） |
| Locationフィールドセット | fieldset | 国（プルダウン）、市区町村 |
| Mail Optionsフィールドセット | fieldset | メール形式（ラジオボタン） |
| 保存ボタン | button | フォーム送信 |
| 検索ボックス | 部分テンプレート | サイト内検索 |
| サイドバーローテーター | 部分テンプレート | 広告・バナー表示 |

## イベント仕様

### 1-画面初期表示

ログインユーザーのプロフィール情報を取得して表示する。

**処理フロー**：
1. `Zend_Auth::getInstance()->hasIdentity()` で認証確認
2. 未認証の場合は `AuthController::loginAction` へフォワード
3. users + users_profiles をJOINしてユーザー情報取得
4. プロフィール項目をフォームにセット

### 2-プロフィール更新（フォーム送信）

入力内容をバリデーションしてデータベースを更新する。

**処理フロー**：
1. POSTリクエストを受信
2. Zend_Filter_Inputでバリデーション実行
3. バリデーション成功時：
   - usersテーブルのuser_mailformatを更新
   - users_profilesテーブルのupro_country, upro_city, upro_phoneを更新
   - "Profile Updated"メッセージを表示
4. バリデーション失敗時：
   - エラーメッセージを表示
   - 入力値を再表示

### 3-タブ切替

Profile/Password/Subscriptionsタブをクリックして画面を切り替える。

| タブ | 遷移先URL | 説明 |
|-----|----------|------|
| Profile | - | 現在の画面（アクティブ） |
| Password | /settings/password/ | パスワード変更画面 |
| Subscriptions | /settings/subscriptions/ | 購読設定画面 |

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 画面表示 | users, users_profiles | SELECT JOIN | ユーザー情報取得 |
| プロフィール更新 | users | UPDATE | メール形式更新 |
| プロフィール更新 | users_profiles | UPDATE | 住所情報更新 |

### テーブル別更新項目詳細

#### users (u)

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | user_id | = ログインユーザーID | - |
| SELECT | user_alias | - | 表示用（読み取り専用） |
| SELECT | user_email | - | 表示用（読み取り専用） |
| SELECT | user_mailformat | - | 現在のメール形式 |
| UPDATE | user_mailformat | フォーム入力値(format) | 'text' or 'html' |

#### users_profiles (p)

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | upro_userid | = u.user_id | JOIN条件 |
| SELECT | upro_first | - | 表示用（読み取り専用） |
| SELECT | upro_last | - | 表示用（読み取り専用） |
| SELECT | upro_country | - | 現在の国 |
| SELECT | upro_city | - | 現在の市区町村 |
| UPDATE | upro_country | フォーム入力値(country) | 国コード |
| UPDATE | upro_city | フォーム入力値(city) | 任意入力 |
| UPDATE | upro_phone | フォーム入力値(phone) | 電話番号 |
| UPDATE | upro_date | NOW() | 更新日時 |

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示条件 |
|-------------|------|--------------|---------|
| MSG-SET-001 | 成功 | Profile Updated | プロフィール更新成功時 |
| MSG-SET-002 | エラー | Missing Country - you did not enter a country | 国が未選択 |
| MSG-SET-003 | エラー | Invalid Country - you did not enter a valid country | 国が不正形式 |
| MSG-SET-004 | エラー | Invalid City - you did not enter a valid city | 市区町村が不正形式 |

## 例外処理

| 例外条件 | 処理内容 |
|---------|---------|
| 未認証アクセス | AuthController::loginActionへフォワード |
| バリデーションエラー | エラーメッセージ表示、入力値保持 |

## 備考

- エイリアス、名、姓、メールアドレスはセキュリティ上の理由から読み取り専用
- 国選択はcountriesOptionsヘルパーで生成されるプルダウン
- Dojoウィジェット（ValidationTextBox, FilteringSelect, RadioButton）を使用
- サイドバーに検索ボックスとローテーター広告を表示

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

ユーザーとプロフィールのデータ構造を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | users テーブル | DBスキーマ | user_id, user_alias, user_email, user_mailformat カラム |
| 1-2 | users_profiles テーブル | DBスキーマ | upro_userid, upro_first, upro_last, upro_country, upro_city カラム |

**読解のコツ**: users.user_id = users_profiles.upro_userid でJOINしている。

#### Step 2: エントリーポイントを理解する

画面アクセス時の処理起点を特定する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | SettingsController.php | `application/modules/default/controllers/SettingsController.php` | indexAction（38-171行） |

**主要処理フロー**:
1. **40行**: `setRefer()` でリファラー設定
2. **42行**: `Zend_Auth::getInstance()->hasIdentity()` で認証確認
3. **50-54行**: users + users_profiles をJOINしてSELECT
4. **60行**: userArrayをビューに渡す
5. **62-149行**: POSTリクエスト時のバリデーションと更新処理
6. **165-168行**: 未認証時のログイン画面フォワード

#### Step 3: ビューテンプレートを理解する

HTML出力の構成を把握する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | index.phtml | `application/modules/default/views/scripts/settings/index.phtml` | フォーム構成、バリデーションメッセージ表示 |

**主要処理フロー**:
- **9-17行**: Dojoモジュールのrequire定義
- **29行**: h2見出し "Account Settings: Profile"
- **32-35行**: タブナビゲーション
- **39-41行**: 更新成功メッセージ表示
- **43行**: RenderMessagesヘルパーでエラー表示
- **47-168行**: フォーム（Identity, Contact Details, Location, Mail Options）
- **176-182行**: サイドバー（検索ボックス、ローテーター）

### プログラム呼び出し階層図

```
[ブラウザ] /settings/
    │
    └─ SettingsController::indexAction()
           │
           ├─ Zend_Auth::hasIdentity() 確認
           │      │
           │      └─ 未認証 → AuthController::loginAction へフォワード
           │
           ├─ users + users_profiles SELECT
           │
           ├─ POST? ──Yes──▶ Zend_Filter_Input バリデーション
           │                        │
           │                        ├─ 成功 → users UPDATE
           │                        │         users_profiles UPDATE
           │                        │
           │                        └─ 失敗 → エラーメッセージ設定
           │
           └─ index.phtml レンダリング
                  │
                  ├─ countriesOptions() ───▶ 国リスト生成
                  │
                  ├─ searchbox.phtml ───▶ 検索ボックス
                  │
                  └─ RenderRotator() ───▶ サイドバー広告
```

### データフロー図

```
[入力]               [処理]                    [出力]

/settings/ GET ───▶ indexAction()
                       │
                       ├─ 認証確認
                       │
                       ▼
                users + profiles SELECT
                       │
                       ▼
                index.phtml ───▶ プロフィールフォーム表示

/settings/ POST ───▶ indexAction()
                       │
                       ├─ バリデーション
                       │
                       ├─ 成功? ──Yes──▶ users UPDATE
                       │                  profiles UPDATE
                       │                  "Profile Updated" 表示
                       │
                       └─ No ──▶ エラーメッセージ表示
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| SettingsController.php | `application/modules/default/controllers/SettingsController.php` | コントローラ | indexAction処理 |
| index.phtml | `application/modules/default/views/scripts/settings/index.phtml` | ビュー | プロフィールフォーム表示 |
| countriesOptions.php | `application/modules/default/views/helpers/countriesOptions.php` | ビューヘルパー | 国リスト生成 |
| RenderMessages.php | `application/modules/default/views/helpers/RenderMessages.php` | ビューヘルパー | エラーメッセージ表示 |
| RenderRotator.php | `application/modules/default/views/helpers/RenderRotator.php` | ビューヘルパー | ローテーター広告表示 |
| searchbox.phtml | `application/modules/default/views/scripts/_partials/searchbox.phtml` | 部分テンプレート | 検索ボックス |
| info.phtml | `application/modules/default/views/scripts/_partials/info.phtml` | 部分テンプレート | 情報メッセージ表示 |
| common.js | `public/_scripts/default/common.js` | JavaScript | サイト共通処理 |
| screen.css | `public/_styles/default/screen.css` | CSS | スタイルシート |
